/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.jms;

import com.att.aft.dme2.api.DME2ReplyHandler;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.handler.AsyncResponseHandlerIntf;
import com.att.aft.dme2.jms.DME2JMSManager;
import com.att.aft.dme2.jms.DME2JMSMessage;
import com.att.aft.dme2.jms.DME2JMSQueue;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.ErrorContext;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class DME2JMSHttpReplyHandler
implements DME2ReplyHandler,
AsyncResponseHandlerIntf {
    private static final Logger logger = LoggerFactory.getLogger(DME2JMSHttpReplyHandler.class.getName());
    private final DME2JMSManager manager;
    private DME2Configuration config;

    protected DME2JMSHttpReplyHandler(DME2JMSManager manager) {
        this.manager = manager;
        this.config = manager.getDME2Manager().getConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleException(Map<String, String> requestHeaders, Throwable e) {
        logger.debug(null, "handleException", LogMessage.METHOD_ENTER);
        String replyToQueue = null;
        try {
            replyToQueue = requestHeaders.get("JMSReplyTo");
            if (replyToQueue == null) {
                replyToQueue = requestHeaders.get(this.config.getProperty("DME2_HEADER_PREFIX") + "JMSReplyTo");
            }
            if (replyToQueue != null) {
                replyToQueue = "http://DME2LOCAL" + replyToQueue;
                DME2JMSMessage m = this.manager.createErrorMessage(e, requestHeaders);
                DME2JMSQueue queue = this.manager.getQueueFromCache(replyToQueue);
                if (queue == null) {
                    logger.error((URI)null, "handleException", "AFT-DME2-5300", (Object)new ErrorContext().add("JMSDestination", replyToQueue).add("extendedMessage", e.getMessage()), (Object)e);
                } else if (m != null) {
                    queue.put(m);
                }
            }
        }
        catch (Throwable x) {
            logger.error((URI)null, "handleException", "AFT-DME2-5301", (Object)new ErrorContext().add("JMSDestination", replyToQueue).add("extendedMessage", x.getMessage()), (Object)x);
        }
        finally {
            logger.debug(null, "handleException", LogMessage.METHOD_EXIT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleReply(int rc, String rm, InputStream in, Map<String, String> requestHeaders, Map<String, String> responseHeaders) {
        logger.debug(null, "handleReply", LogMessage.METHOD_ENTER);
        String replyToQueue = null;
        try {
            HashMap<String, String> finalResponseHeaders = new HashMap<String, String>();
            for (String key : responseHeaders.keySet()) {
                if (key == null) continue;
                finalResponseHeaders.put(key, responseHeaders.get(key));
            }
            if (!finalResponseHeaders.containsKey("Content-Type")) {
                finalResponseHeaders.put("Content-Type", "text/xml");
                if (requestHeaders.containsKey("SOAPJMS_bindingVersion") || requestHeaders.containsKey("SOAPJMS_contentType")) {
                    finalResponseHeaders.put("SOAPJMS_contentType", "text/xml");
                    if (!finalResponseHeaders.containsKey("SOAPJMS_requestURI")) {
                        finalResponseHeaders.put("SOAPJMS_requestURI", "DummyValueAddedByDME2");
                    }
                }
            }
            if ((replyToQueue = (String)finalResponseHeaders.get("JMSDestination")) == null) {
                replyToQueue = (String)finalResponseHeaders.get(this.config.getProperty("DME2_HEADER_PREFIX").concat("JMSDestination"));
            }
            if (replyToQueue != null) {
                replyToQueue = "http://DME2LOCAL" + replyToQueue;
                DME2JMSMessage m = this.manager.createMessage(in, finalResponseHeaders);
                DME2JMSQueue queue = this.manager.getQueueFromCache(replyToQueue);
                if (queue == null) {
                    logger.error((URI)null, "handleReply", "AFT-DME2-5300", (Object)new ErrorContext().add("JMSDestination", replyToQueue));
                } else {
                    queue.put(m);
                }
            }
        }
        catch (Throwable e) {
            logger.error((URI)null, "hanleReply", "AFT-DME2-5302", (Object)new ErrorContext().add("JMSDestination", replyToQueue), (Object)e);
        }
        finally {
            logger.debug(null, "handleReply", LogMessage.METHOD_EXIT);
        }
    }

    @Override
    public String getResponse(long timeoutMs) throws Exception {
        return null;
    }
}

