/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.jms;

import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.jms.DME2JMSManager;
import com.att.aft.dme2.jms.DME2JMSMessage;
import com.att.aft.dme2.jms.DME2JMSMessageConsumer;
import com.att.aft.dme2.jms.MessageListenerHolder;
import com.att.aft.dme2.jms.util.JMSLogMessage;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Queue;

public abstract class DME2JMSQueue
implements Queue,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<MessageListenerHolder> listeners = Collections.synchronizedList(new LinkedList());
    private String name;
    private String queueHost;
    private final URI originalURI;
    private static final int DEFAULT_JMS_PRIORITY = 4;
    private static final int DEFAULTTTLMS = 300000;
    private int defaultPriority = 4;
    private long defaultTtlMs = 300000L;
    private boolean client = true;
    private long createTime = 0L;
    private final DME2JMSManager manager;
    private int directPort;
    private String userName;
    private String password;
    private String realmName;
    private String[] allowedRoles;
    private String loginMethod;
    private boolean qdebug;
    private AtomicInteger activeReceiverCount = new AtomicInteger(0);
    private final Map<String, String> queryParams = new HashMap<String, String>();
    private DME2Configuration config;
    private static final Logger logger = LoggerFactory.getLogger(DME2JMSQueue.class.getName());

    protected DME2JMSQueue(DME2JMSManager manager, URI uri) throws JMSException {
        this.originalURI = uri;
        this.manager = manager;
        this.config = manager.getDME2Manager().getConfig();
        if (uri != null && uri.getQuery() != null) {
            String[] pairs;
            for (String pair : pairs = uri.getQuery().split("&")) {
                String[] keyValue = pair.split("=");
                if (keyValue.length != 2) continue;
                if (keyValue[0].equals("defaultTtlMs")) {
                    this.defaultTtlMs = Long.parseLong(keyValue[1]);
                } else if (keyValue[0].equals("defaultPriority")) {
                    this.defaultPriority = Integer.parseInt(keyValue[1]);
                } else if (keyValue[0].equals("server")) {
                    logger.debug(null, "DME2JMSQueue", "DME2JMSQueue is server type ");
                    this.client = false;
                } else if (keyValue[0].equals("qdebug")) {
                    this.qdebug = true;
                } else if (keyValue[0].equals("realm")) {
                    this.realmName = keyValue[1];
                } else if (keyValue[0].equals("loginMethod")) {
                    this.loginMethod = keyValue[1];
                } else if (keyValue[0].equals("allowedRoles")) {
                    String allowedRolesStr = keyValue[1];
                    if (allowedRolesStr != null) {
                        this.allowedRoles = allowedRolesStr.split(",");
                    }
                } else if (keyValue[0].equals("userName")) {
                    this.userName = keyValue[1];
                } else if (keyValue[0].equals("password")) {
                    this.password = keyValue[1];
                } else {
                    logger.info((URI)null, "ctor", "Overriding property from queue. Key: {} Value: {}", (Object)keyValue[0], (Object)keyValue[1]);
                    this.config.setOverrideProperty(keyValue[0], keyValue[1]);
                }
                this.queryParams.put(keyValue[0], keyValue[1]);
            }
        }
        if (this.userName == null && this.password == null && manager.getUserName() != null && manager.getPassword() != null) {
            this.userName = manager.getUserName();
            this.password = manager.getPassword();
        }
        if (uri != null) {
            this.queueHost = uri.getHost();
            this.directPort = uri.getPort();
            this.name = uri.getPath();
        }
        if (this.name != null) {
            String qname = this.name.toLowerCase();
            if (qname.indexOf("version=") != -1 && qname.indexOf("routeoffer=") != -1 && qname.indexOf("service=") != -1) {
                this.client = false;
            }
            logger.debug(null, "DME2JMSQueue", "DME2JMSQueue [{}] - init {}; queue isClient={}", this.getQueueName(), this.name, this.isClient());
        }
        this.createTime = System.currentTimeMillis();
    }

    public void setClient(boolean client) {
        this.client = client;
    }

    public String getQueueName() throws JMSException {
        return this.name;
    }

    public String getQueueNameURI() throws JMSException {
        String qParams = this.getQueryParamsAsString();
        if (qParams != null && qParams.length() > 0) {
            return this.name + "?" + qParams;
        }
        return this.name.toString();
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public URI getDME2URI() {
        return this.originalURI;
    }

    public String getQueueHost() {
        if (this.directPort > 0) {
            return this.queueHost + ":" + this.directPort;
        }
        return this.queueHost;
    }

    public abstract void put(DME2JMSMessage var1) throws JMSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DME2JMSMessageConsumer consumer, MessageListener listener, String filter) throws JMSException {
        MessageListenerHolder holder = new MessageListenerHolder(consumer, listener, filter, (Destination)this);
        List<MessageListenerHolder> list = this.listeners;
        synchronized (list) {
            this.listeners.add(holder);
        }
        if (this.qdebug) {
            logger.debug(null, "addListener", (LogMessage)JMSLogMessage.QUEUE_ADDLISTENER, this.getQueueName(), listener.getClass(), this.listeners.size());
        }
        logger.debug(null, "addListener", "DME2JMSQueue [{}] - addListener {};size={}", this.getQueueName(), listener, this.listeners.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DME2JMSMessageConsumer consumer) throws JMSException {
        List<MessageListenerHolder> list = this.listeners;
        synchronized (list) {
            Iterator<MessageListenerHolder> it = this.listeners.iterator();
            while (it.hasNext()) {
                MessageListenerHolder holder = it.next();
                if (!holder.isSameListener(consumer)) continue;
                if (consumer != null) {
                    logger.info(null, "removeListener", (LogMessage)JMSLogMessage.QUEUE_REMOVELISTNR, this.getQueueName(), consumer.getClass(), consumer.getMessageListener(), this.getListeners().size());
                }
                it.remove();
            }
        }
        logger.debug((URI)null, "removeListener", "DME2JMSQueue [{}] - removeListener listeners size={}", (Object)this.getQueueName(), (Object)this.listeners.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DME2JMSMessageConsumer consumer, MessageListener listener) throws JMSException {
        List<MessageListenerHolder> list = this.listeners;
        synchronized (list) {
            Iterator<MessageListenerHolder> it = this.listeners.iterator();
            while (it.hasNext()) {
                MessageListenerHolder holder = it.next();
                if (!holder.isSameListener(listener)) continue;
                if (this.qdebug) {
                    logger.info(null, "removeListener", (LogMessage)JMSLogMessage.QUEUE_REMOVE_SAME, this.getQueueName(), consumer.getClass(), listener, this.listeners.size());
                }
                holder.checkin();
                it.remove();
            }
        }
        logger.debug(null, "removeListener", "DME2JMSQueue [{}] - removeListener {};listeners size={}", this.getQueueName(), listener, this.listeners.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageListenerHolder checkoutListener(DME2JMSMessage m) throws JMSException {
        MessageListenerHolder holder = null;
        logger.debug((URI)null, "checkoutListener", "DME2JMSQueue [{}] - checkoutListener ;listeners size={}", (Object)this.getQueueName(), (Object)this.listeners.size());
        List<MessageListenerHolder> list = this.listeners;
        synchronized (list) {
            for (MessageListenerHolder h : this.listeners) {
                logger.debug(null, "checkoutListener", "Checking holder {} - isAvailable: {} matches message {}: {}", h, h.isAvailable(), m, h.matches(m));
                try {
                    if (!h.isAvailable() || !h.matches(m)) continue;
                    if (this.qdebug) {
                        logger.info(null, "checkoutListener", (LogMessage)JMSLogMessage.QUEUE_CHECKOUT, this.getQueueName(), h, this.listeners.size());
                    }
                    h.checkout();
                    holder = h;
                    break;
                }
                catch (Exception e) {
                    logger.error((URI)null, "checkoutListener", (LogMessage)JMSLogMessage.CHECKOUT_FAIL, (Object)e);
                }
            }
        }
        logger.debug(null, "checkoutListener", "DME2JMSQueue [{}] - checkoutListener Holder={};listeners size={}", this.getQueueName(), holder, this.listeners.size());
        return holder;
    }

    public void setListeners(List<MessageListenerHolder> listeners) throws JMSException {
        this.listeners = listeners;
        if (this.qdebug) {
            logger.info(null, "setListeners", (LogMessage)JMSLogMessage.QUEUE_REMOVELISTNR, this.getQueueName(), listeners, listeners.size());
        }
        logger.debug(null, "setListeners", "DME2JMSQueue [", this.getQueueName(), "] - setListeners;listeners size=", listeners.size());
    }

    public List<MessageListenerHolder> getListeners() {
        return this.listeners;
    }

    public int getDefaultPriority() {
        return this.defaultPriority;
    }

    public long getDefaultTtlMs() {
        return this.defaultTtlMs;
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void setAllowedRoles(String[] newAllowedRoles) {
        this.allowedRoles = newAllowedRoles == null ? null : Arrays.copyOf(newAllowedRoles, newAllowedRoles.length);
    }

    public String[] getAllowedRoles() {
        return this.allowedRoles;
    }

    public void setLoginMethod(String loginMethod) {
        this.loginMethod = loginMethod;
    }

    public String getLoginMethod() {
        return this.loginMethod;
    }

    public boolean isClient() {
        return this.client;
    }

    public boolean isQdebug() {
        return this.qdebug;
    }

    public void setQdebug(boolean qdebug) {
        this.qdebug = qdebug;
    }

    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    public String getQueryParamsAsString() {
        StringBuffer temp = new StringBuffer();
        for (String key : this.queryParams.keySet()) {
            temp.append(key + "=" + this.queryParams.get(key) + "&");
        }
        return temp.toString();
    }

    public DME2Configuration getConfig() {
        return this.config;
    }

    public void setConfig(DME2Configuration config) {
        this.config = config;
    }

    protected String getUserName() {
        return this.userName;
    }

    protected void setUserName(String userName) {
        this.userName = userName;
    }

    protected String getPassword() {
        return this.password;
    }

    protected void setPassword(String password) {
        this.password = password;
    }

    public AtomicInteger getActiveReceiverCount() {
        return this.activeReceiverCount;
    }
}

