/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.jms;

import com.att.aft.dme2.jms.DME2JMSConnection;
import com.att.aft.dme2.jms.DME2JMSConnectionConsumer;
import com.att.aft.dme2.jms.DME2JMSConnectionMetaData;
import com.att.aft.dme2.jms.DME2JMSException;
import com.att.aft.dme2.jms.DME2JMSManager;
import com.att.aft.dme2.jms.DME2JMSMessageConsumer;
import com.att.aft.dme2.jms.DME2JMSNotImplementedException;
import com.att.aft.dme2.jms.DME2JMSQueue;
import com.att.aft.dme2.jms.DME2JMSQueueSession;
import com.att.aft.dme2.jms.DME2JMSTemporaryQueue;
import com.att.aft.dme2.jms.util.UniqueIdGenerator;
import com.att.aft.dme2.util.ErrorContext;
import java.net.URI;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;

public class DME2JMSQueueConnection
extends DME2JMSConnection
implements QueueConnection {
    private String username = null;
    private String password = null;
    private boolean open = false;
    private boolean started = false;
    private ExceptionListener exceptionListener;
    private String clientID;
    private DME2JMSManager manager;

    public DME2JMSQueueConnection(DME2JMSManager manager, String name, String username, String password) {
        this.username = username;
        this.password = password;
        this.open = true;
        this.manager = manager;
        if (this.manager != null) {
            this.manager.setClientCredentials(username, password);
        }
    }

    public ConnectionConsumer createConnectionConsumer(Queue destination, String messageSelector, ServerSessionPool sessionPool, int count) throws JMSException {
        DME2JMSMessageConsumer messageConsumer = (DME2JMSMessageConsumer)this.createQueueSession(false, 0).createConsumer((Destination)destination, messageSelector);
        return new DME2JMSConnectionConsumer(this, (DME2JMSQueue)destination, messageSelector, sessionPool, messageConsumer);
    }

    public QueueSession createQueueSession(boolean transacted, int ackMode) throws JMSException {
        return new DME2JMSQueueSession(this, transacted, ackMode);
    }

    public void close() throws JMSException {
        this.open = false;
        this.started = false;
        this.manager.closeTemporaryQueues(this);
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessage) throws JMSException {
        if (!(destination instanceof DME2JMSQueue)) {
            throw new DME2JMSException("AFT-DME2-5700", new ErrorContext().add("DestinationType", destination.getClass().getName()));
        }
        return this.createConnectionConsumer((DME2JMSQueue)destination, messageSelector, sessionPool, maxMessage);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic arg0, String arg1, String arg2, ServerSessionPool arg3, int arg4) throws JMSException {
        throw new DME2JMSNotImplementedException("Connection.createDurableConnectionConsumer");
    }

    public Session createSession(boolean transacted, int acknowledged) throws JMSException {
        return new DME2JMSQueueSession(this, transacted, acknowledged);
    }

    public String getClientID() throws JMSException {
        return this.clientID;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        return this.exceptionListener;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        return DME2JMSConnectionMetaData.getMETA_DATA();
    }

    public void setClientID(String clientID) throws JMSException {
        this.clientID = clientID;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        this.exceptionListener = exceptionListener;
    }

    public void start() throws JMSException {
        this.started = true;
    }

    public void stop() throws JMSException {
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isOpen() {
        return this.open;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    protected Destination createTemporaryDestination(Session session, boolean topic) throws JMSException {
        if (topic) {
            throw new DME2JMSNotImplementedException("Topic ");
        }
        URI uri = UniqueIdGenerator.getUniqueTemporaryQueueURI();
        DME2JMSTemporaryQueue tempQueue = new DME2JMSTemporaryQueue(this.manager, uri, (QueueSession)session, this);
        return tempQueue;
    }

    public DME2JMSManager getManager() {
        return this.manager;
    }

    void setManager(DME2JMSManager manager) {
        this.manager = manager;
    }
}

