/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.jms;

import com.att.aft.dme2.jms.DME2JMSConnectionFactory;
import com.att.aft.dme2.jms.DME2JMSManager;
import com.att.aft.dme2.jms.DME2JMSQueueConnection;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.ErrorContext;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;

public class DME2JMSQueueConnectionFactory
extends DME2JMSConnectionFactory
implements QueueConnectionFactory,
Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private transient DME2JMSManager manager;
    private static final Logger logger = LoggerFactory.getLogger(DME2JMSQueueConnectionFactory.class.getName());

    public DME2JMSQueueConnectionFactory() throws Exception {
        this.manager = DME2JMSManager.getDefaultInstance();
    }

    protected DME2JMSQueueConnectionFactory(DME2JMSManager manager, String uriStr) throws URISyntaxException {
        try {
            String path;
            URI uri = new URI(uriStr);
            this.name = path = uri.getPath();
            this.manager = manager;
        }
        catch (Exception e) {
            logger.debug((URI)null, "DME2JMSQueueConnectionFactory", "Exception", (Object)new ErrorContext().add("extendedMessage", e.toString()));
        }
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return new DME2JMSQueueConnection(this.manager, this.name, null, null);
    }

    public QueueConnection createQueueConnection(String username, String password) throws JMSException {
        return new DME2JMSQueueConnection(this.manager, this.name, username, password);
    }

    public String toString() {
        return "DME2JMSQueueConnectionFactory: Name=" + this.name;
    }

    public Connection createConnection(String username, String password) {
        return new DME2JMSQueueConnection(this.manager, this.name, username, password);
    }

    public Connection createConnection() throws JMSException {
        return new DME2JMSQueueConnection(this.manager, this.name, null, null);
    }

    @Override
    protected void buildFromProperties(Properties props) {
    }

    @Override
    protected void populateProperties(Properties props) {
    }

    protected String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected DME2JMSManager getManager() {
        return this.manager;
    }

    protected void setManager(DME2JMSManager manager) {
        this.manager = manager;
    }
}

