/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.jms;

import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.jms.DME2JMSException;
import com.att.aft.dme2.jms.DME2JMSMessage;
import com.att.aft.dme2.jms.DME2JMSQueue;
import com.att.aft.dme2.jms.DME2JMSQueueSession;
import com.att.aft.dme2.jms.DME2JMSSession;
import com.att.aft.dme2.jms.DME2JMSTemporaryQueue;
import com.att.aft.dme2.jms.util.DME2JMSExceptionHandler;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.ErrorContext;
import java.net.URI;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueSender;

public class DME2JMSQueueSender
implements QueueSender {
    private static final Logger logger = LoggerFactory.getLogger(DME2JMSQueueSender.class.getName());
    private final DME2JMSQueue queue;
    private final DME2JMSSession session;
    private boolean open = true;
    private int deliveryMode = 1;
    private boolean disableMessageID;
    private boolean disableMessageTimestamp;
    private static final int CONSTANT_FOUR = 4;
    private static final String TEMP_QUEUE_IDLE_TIMEOUT_PROPERTY = "dme2.tempqueue.idletimeoutms";
    private int priority = 4;
    private long timeToLive = 0L;
    private DME2Configuration config;

    protected DME2JMSQueueSender(DME2JMSQueue queue, DME2JMSQueueSession session) {
        this.queue = queue;
        this.session = session;
        if (null != queue) {
            this.config = queue.getConfig();
        }
        try {
            this.disableMessageTimestamp = this.config.getBoolean("DME2_DISABLE_TIMESTAMP");
        }
        catch (Exception e) {
            this.disableMessageTimestamp = false;
        }
    }

    public Queue getQueue() throws JMSException {
        return this.queue;
    }

    public void send(Message message) throws JMSException {
        this.send(this.queue, message);
    }

    public void send(Queue queue, Message message) throws JMSException {
        this.send(queue, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void send(Message message, int deliveryMode, int priority, long ttl) throws JMSException {
        this.send(this.queue, message, deliveryMode, priority, ttl);
    }

    public void send(Queue queue, Message message, int deliveryMode, int priority, long ttl) throws JMSException {
        logger.debug(null, "send", LogMessage.METHOD_ENTER);
        long expiration = 0L;
        long timeStamp = System.currentTimeMillis();
        try {
            if (!this.isOpen()) {
                throw new DME2JMSException("AFT-DME2-5900", new ErrorContext());
            }
            if (!(queue instanceof DME2JMSQueue)) {
                throw new DME2JMSException("AFT-DME2-5901", new ErrorContext());
            }
            if (!(message instanceof DME2JMSMessage)) {
                throw new DME2JMSException("AFT-DME2-5902", new ErrorContext());
            }
            DME2JMSQueue q2 = (DME2JMSQueue)queue;
            if (q2 instanceof DME2JMSTemporaryQueue && message.getLongProperty(TEMP_QUEUE_IDLE_TIMEOUT_PROPERTY) != 0L) {
                logger.debug((URI)null, "send", "DME2JMSQueueSender send DME2JMSQueueSender send Received custom temporary queue idle timeout specified by client. dme2.tempqueue.idletimeoutms=" + message.getLongProperty(TEMP_QUEUE_IDLE_TIMEOUT_PROPERTY) + "ms.JMSTimestamp={}; CorrelationID={}", (Object)message.getJMSTimestamp(), (Object)message.getJMSCorrelationID());
                ((DME2JMSTemporaryQueue)q2).setIdleTimeoutMs(message.getLongProperty(TEMP_QUEUE_IDLE_TIMEOUT_PROPERTY));
            }
            if (q2 instanceof DME2JMSTemporaryQueue && message.getLongProperty(TEMP_QUEUE_IDLE_TIMEOUT_PROPERTY) != 0L) {
                logger.debug((URI)null, "send", "DME2JMSQueueSender send Received custom temporary queue idle timeout specified by client. {}={}ms.", (Object)TEMP_QUEUE_IDLE_TIMEOUT_PROPERTY, (Object)message.getLongProperty(TEMP_QUEUE_IDLE_TIMEOUT_PROPERTY));
                ((DME2JMSTemporaryQueue)q2).setIdleTimeoutMs(message.getLongProperty(TEMP_QUEUE_IDLE_TIMEOUT_PROPERTY));
            }
            if (!this.disableMessageTimestamp) {
                message.setJMSTimestamp(timeStamp);
                logger.debug((URI)null, "send", "DME2JMSQueueSender send JMSTimestamp={}; CorrelationID={}", (Object)message.getJMSTimestamp(), (Object)message.getJMSCorrelationID());
                if (ttl > 0L) {
                    expiration = ttl + timeStamp;
                }
            }
            if (expiration > 0L) {
                message.setJMSExpiration(expiration);
            } else if (ttl > 0L) {
                message.setJMSExpiration(System.currentTimeMillis() + ttl);
            }
            logger.debug((URI)null, "send", "message correlationID: {} AFT_DME2_EP_READ_TIMEOUT_MS: {}", (Object)message.getJMSCorrelationID(), (Object)message.getStringProperty("AFT_DME2_EP_READ_TIMEOUT_MS"));
            q2.put((DME2JMSMessage)message);
        }
        catch (Exception e) {
            throw DME2JMSExceptionHandler.handleException(e, queue.getQueueName());
        }
        logger.debug(null, "send", LogMessage.METHOD_EXIT);
    }

    private boolean isOpen() {
        if (!this.open) {
            return false;
        }
        return this.session.isOpen();
    }

    public void close() throws JMSException {
        this.open = false;
    }

    public int getDeliveryMode() throws JMSException {
        return this.deliveryMode;
    }

    public Destination getDestination() throws JMSException {
        return this.queue;
    }

    public boolean getDisableMessageID() throws JMSException {
        return this.disableMessageID;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return this.disableMessageTimestamp;
    }

    public int getPriority() throws JMSException {
        return this.priority;
    }

    public long getTimeToLive() throws JMSException {
        return this.timeToLive;
    }

    public void send(Destination dest, Message message) throws JMSException {
        this.send((Queue)dest, message, this.deliveryMode, this.priority, this.timeToLive);
    }

    public void send(Destination dest, Message message, int deliveryMode, int priority, long ttl) throws JMSException {
        this.send((Queue)dest, message, deliveryMode, priority, ttl);
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        if (deliveryMode == 2) {
            throw new DME2JMSException("AFT-DME2-5903", new ErrorContext());
        }
        this.deliveryMode = deliveryMode;
    }

    public void setDisableMessageID(boolean disableMessageID) throws JMSException {
        this.disableMessageID = disableMessageID;
    }

    public void setDisableMessageTimestamp(boolean disableMessageTimestamp) throws JMSException {
        this.disableMessageTimestamp = disableMessageTimestamp;
    }

    public void setPriority(int priority) throws JMSException {
        this.priority = priority;
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.timeToLive = timeToLive;
    }
}

