/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.jms;

import com.att.aft.dme2.api.DME2Server;
import com.att.aft.dme2.api.util.DME2MessageHeaderUtils;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.internal.apache.commons.lang.ArrayUtils;
import com.att.aft.dme2.internal.jetty.continuation.Continuation;
import com.att.aft.dme2.internal.jetty.continuation.ContinuationSupport;
import com.att.aft.dme2.jms.DME2JMSContinuationQueue;
import com.att.aft.dme2.jms.DME2JMSManager;
import com.att.aft.dme2.jms.DME2JMSMessage;
import com.att.aft.dme2.jms.DME2JMSQueue;
import com.att.aft.dme2.jms.DME2JMSServiceUnavailableException;
import com.att.aft.dme2.jms.util.DME2ContinuationEventListener;
import com.att.aft.dme2.jms.util.JMSLogMessage;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.DME2Constants;
import com.att.aft.dme2.util.ErrorContext;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.jms.Destination;
import javax.jms.Message;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DME2JMSServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final DME2JMSManager manager;
    private Integer maxRetry = 0;
    private static final long SLEEP_INTERVAL = 5L;
    private static final int TIMEOUT_5 = 5;
    private static final int TIMEOUT_60 = 60;
    private static final long TIMEOUT_1000L = 1000L;
    private static final int DME2_RECEIVE_MAX_RETRY = 3;
    private static final int CONTENT_LENGTH = 100;
    private static final int JMSXDME2FORCEFAILOVERCODE = 222;
    private Long maxSleep = 5L;
    private static final String CLASS_NAME = "com.att.aft.dme2.jms.DME2JMSServlet";
    private static final Logger logger = LoggerFactory.getLogger(DME2JMSServlet.class.getName());
    private Long continuationTimeout = 300000L;
    private static final String EVENT = "Event";
    private static final String RESULT = "Result";
    private static final String REASONCODE = "ReasonCode";
    private static final String FAULT = "Fault";
    private static final String EXTENDEDMESSAGE = "extendedMessage";
    private DME2Configuration config;

    protected DME2JMSServlet(DME2JMSManager manager) {
        this.manager = manager;
        this.config = manager.getDME2Manager().getConfig();
        try {
            this.maxRetry = this.config.getInt("AFT_DME2_RECEIVE_MAX_RETRY");
            if (this.maxRetry == null) {
                this.maxRetry = this.config.getInt("DME2_RECEIVE_MAX_RETRY");
            }
            this.maxSleep = this.config.getLong("AFT_DME2_RETRY_SLEEP");
            if (this.maxSleep == null) {
                this.maxSleep = this.config.getLong("DME2_RETRY_SLEEP");
            }
            this.continuationTimeout = this.config.getLong("AFT_DME2_CONT_TIMEOUT", this.continuationTimeout);
            if (this.continuationTimeout == null) {
                this.continuationTimeout = this.config.getLong("AFT_DME2_CONT_TIMEOUT");
            }
        }
        catch (Exception e) {
            this.maxRetry = 3;
        }
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentLength(100);
        resp.setContentType("text/html");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doGet(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        logger.debug(null, "doPost", LogMessage.METHOD_ENTER);
        String serviceName = null;
        String version = null;
        String contextPath = null;
        String endpoint = req.getServerName() + ":" + req.getServerPort() + ":" + req.getServletPath();
        String requestPartnerName = null;
        try {
            String replyToQueueName;
            DME2Server server = this.manager.getDME2Manager().getServer();
            String healthCheck = req.getHeader("DME2HealthCheck");
            if (healthCheck != null) {
                if (server.getServerPoolIdleThreads() <= 0) {
                    resp.sendError(503, "NO IDLE THREADS AVAILABLE");
                    resp.flushBuffer();
                    return;
                }
                resp.setStatus(200);
                return;
            }
            if (server.getServerPoolIdleThreads() <= 0) {
                resp.sendError(503, "NO IDLE THREADS AVAILABLE");
                resp.flushBuffer();
                return;
            }
            String msgId = req.getHeader(this.config.getProperty("DME2_HEADER_PREFIX") + "JMSMessageID");
            if (msgId == null) {
                msgId = req.getHeader("JMSMessageID");
            }
            if (msgId == null) {
                msgId = "ID:" + UUID.randomUUID();
            }
            this.setRequestTimeout(req, msgId);
            String conversationId = req.getHeader(this.config.getProperty("DME2_HEADER_PREFIX") + "JMSConversationID");
            if (conversationId == null) {
                conversationId = req.getHeader("JMSConversationID");
            }
            String trackingId = msgId + (conversationId == null ? "" : "(" + conversationId + ")");
            String queueName = req.getRequestURI();
            if (queueName == null) {
                logger.warn((URI)null, "doPost", "AFT-DME2-6200 {}", (Object)new ErrorContext().add(EVENT, "Server.Reply").add(RESULT, FAULT).add(REASONCODE, "404"));
                resp.sendError(404, "JMSDestination not set");
                return;
            }
            if (req != null) {
                contextPath = req.getServletPath();
            }
            if (contextPath != null) {
                DME2Constants.setContext(contextPath + DME2Constants.LOGRECORDSEP + trackingId, null);
            } else {
                DME2Constants.setContext(trackingId, null);
            }
            logger.info((URI)null, "doPost", "AFT-DME2-6201 {}", (Object)new ErrorContext().add(EVENT, "Server.Recieve").add("RemoteHost", req.getRemoteHost()).add("RemotePort", req.getRemotePort() + "").add("JMSMessageId", msgId).add("ConversationID", conversationId).add("Queue", req.getRequestURI()));
            DME2JMSQueue requestQueue = this.manager.getQueue("http://DME2LOCAL" + queueName);
            if (requestQueue == null) {
                logger.warn((URI)null, "doPost", "AFT-DME2-6202 {}", (Object)new ErrorContext().add(EVENT, "Server.Reply").add(RESULT, FAULT).add(REASONCODE, "404"));
                resp.sendError(404, "QUEUE [" + queueName + "] NOT FOUND ON THIS SERVER");
                return;
            }
            DME2JMSMessage message = this.manager.createMessage((InputStream)req.getInputStream(), this.genHeaderMap(req), req.getCharacterEncoding());
            message.setStringProperty("X-EVENTSAMPLER-ENDPOINT", endpoint);
            message.setLongProperty("X-EVENTSAMPLER-RECEIVETIME", System.currentTimeMillis());
            message.setBooleanProperty("com.att.aft.dme2.jms.isReceiveToService", true);
            message.setStringProperty("requestQueue", queueName);
            logger.debug((URI)null, "doPost", "JMSMessage ID={};timestamp={}", message == null ? message : message.getJMSMessageID(), (Object)message.getJMSTimestamp());
            requestPartnerName = req.getHeader("DME2_REQUEST_PARTNER");
            if (requestPartnerName == null) {
                requestPartnerName = req.getHeader("DME2_JMS_REQUEST_PARTNER");
            }
            if ((replyToQueueName = req.getHeader(this.config.getProperty("DME2_HEADER_PREFIX") + "JMSReplyTo")) == null) {
                replyToQueueName = req.getHeader("JMSReplyTo");
            }
            if (replyToQueueName != null) {
                String handleAsSyncResponse = req.getHeader(this.config.getProperty("DME2_HEADER_PREFIX") + "JMSX_ReplyToQueueSync");
                if (handleAsSyncResponse == null) {
                    handleAsSyncResponse = req.getHeader("JMSX_ReplyToQueueSync");
                }
                if (handleAsSyncResponse == null) {
                    handleAsSyncResponse = "true";
                }
                if (handleAsSyncResponse.equals("true")) {
                    URI uri = new URI(replyToQueueName);
                    DME2JMSContinuationQueue replyToQueue = new DME2JMSContinuationQueue(this.manager, uri);
                    message.setJMSReplyTo((Destination)replyToQueue);
                    Continuation continuation = ContinuationSupport.getContinuation((ServletRequest)req);
                    continuation.setTimeout(this.continuationTimeout);
                    String contId = message.getJMSCorrelationID();
                    if (contId == null) {
                        contId = message.getJMSMessageID();
                    }
                    logger.debug(null, "doPost", "Created continuation queue for uri={}; CorrelationID={}; Continuation Object={}; contQueueObject={}", uri.getPath(), contId, continuation, replyToQueue);
                    DME2ContinuationEventListener listener = new DME2ContinuationEventListener(replyToQueue, contId, requestQueue.getQueueName());
                    continuation.addContinuationListener(listener);
                    logger.debug((URI)null, "doPost", "Code=Trace.DME2JMSServlet.service;Suspending request with JMSMessageID {}", (Object)msgId);
                    continuation.suspend((ServletResponse)resp);
                    if (message.getJMSCorrelationID() != null) {
                        logger.debug(null, "doPost", "Adding continuation queue for JMSCorrelationID={}; Continuation Object={}; contQueueObject={}", message.getJMSCorrelationID(), continuation, replyToQueue);
                        replyToQueue.addContinuation(message.getJMSCorrelationID(), continuation, requestQueue.getQueueName(), requestPartnerName);
                    } else {
                        logger.debug(null, "doPost", "Adding continuation queue for JMSMessageID={}; Continuation Object={}; contQueueObject={}", message.getJMSMessageID(), continuation, replyToQueue);
                        replyToQueue.addContinuation(message.getJMSMessageID(), continuation, requestQueue.getQueueName(), requestPartnerName);
                    }
                    logger.debug((URI)null, "doPost", "DME2JMSServlet JMSMessage added {}", (Object)message.getJMSMessageID());
                    try {
                        requestQueue.put(message);
                        Thread.yield();
                        logger.debug((URI)null, "doPost", "DME2JMSServlet JMSMessage put succeeded {}", (Object)message.getJMSMessageID());
                    }
                    catch (DME2JMSServiceUnavailableException e) {
                        try {
                            this.retryMessage(message, (Throwable)((Object)e));
                        }
                        catch (Exception e1) {
                            logger.warn((URI)null, "doPost", "AFT-DME2-6203 {}", (Object)new ErrorContext().add(EVENT, "Server.Reply.Failover").add(RESULT, FAULT).add(REASONCODE, "503").add("Endpoint", endpoint).add(EXTENDEDMESSAGE, e.toString()), (Object)e);
                            resp.sendError(503, e1.getMessage());
                        }
                        return;
                    }
                }
                DME2JMSQueue replyToQueue = this.manager.getQueue(req.getParameter("replyToQueue"));
                message.setJMSReplyTo((Destination)replyToQueue);
                requestQueue.put(message);
                resp.setStatus(200);
            } else {
                try {
                    requestQueue.put(message);
                    resp.setStatus(200);
                }
                catch (DME2JMSServiceUnavailableException e) {
                    try {
                        this.retryMessage(message, (Throwable)((Object)e));
                    }
                    catch (Exception e1) {
                        logger.warn((URI)null, "doPost", "AFT-DME2-6204 {}", (Object)new ErrorContext().add(EVENT, "Server.Reply.Failover").add(RESULT, FAULT).add(REASONCODE, "503").add("Endpoint", endpoint).add(EXTENDEDMESSAGE, e.toString()));
                        resp.sendError(503, e1.getMessage());
                    }
                }
            }
            logger.debug(null, "doPost", "Code=Trace.DME2JMSServlet.service;Completed request from {}:{} with message ID: {} to put() on queue {}", req.getRemoteHost(), req.getRemotePort(), msgId, req.getRequestURI());
            return;
        }
        catch (Exception e) {
            logger.warn((URI)null, "doPost", "AFT-DME2-6205 {}", (Object)new ErrorContext().add(EVENT, "Server.Reply.Failed").add(RESULT, FAULT).add(REASONCODE, "500").add("service", serviceName).add("version", version).add(EXTENDEDMESSAGE, e.toString()));
            resp.sendError(500, e.toString());
            return;
        }
    }

    private Map<String, String> genHeaderMap(HttpServletRequest req) {
        Enumeration e = req.getHeaderNames();
        HashMap<String, String> map = new HashMap<String, String>();
        boolean enableHeaderFiltering = this.config.getBoolean("DME2_FILTER_HTTP_HEADERS");
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = req.getHeader(key);
            if (enableHeaderFiltering) {
                List<Object> filter = this.getHeaderFilter();
                if (filter.contains(key)) continue;
                map.put(key, value);
                continue;
            }
            map.put(key, value);
        }
        Map<String, String> modHeaders = DME2MessageHeaderUtils.removeHeaderPrefix(this.config, map);
        return modHeaders;
    }

    private void retryMessage(Message message, Throwable th) throws Exception {
        logger.debug(null, "retryMessage", LogMessage.METHOD_ENTER);
        int retryCnt = 0;
        String queueName = message.getStringProperty("requestQueue");
        DME2JMSQueue requestQueue = this.manager.getQueue("http://DME2LOCAL" + queueName);
        if (requestQueue == null) {
            this.forceFailover(message, "Request queue not found");
            logger.debug(null, "retryMessage", LogMessage.METHOD_EXIT);
            return;
        }
        if (requestQueue.isClient()) {
            logger.debug(null, "retryMessage", LogMessage.METHOD_EXIT);
            return;
        }
        logger.debug(null, "retryMessage", "ServiceProvider receives message using timeout, retry allowed");
        try {
            retryCnt = message.getIntProperty("retry_count");
        }
        catch (Exception e) {
            logger.debug((URI)null, "retryMessage", "Exception {}", (Object)new ErrorContext().add(EXTENDEDMESSAGE, e.toString()));
        }
        while (true) {
            if (retryCnt >= this.maxRetry) {
                logger.error(null, "retryMessage", (LogMessage)JMSLogMessage.MAX_RETRIES, retryCnt, this.maxRetry, message.getJMSMessageID(), message.getJMSReplyTo(), th);
                this.forceFailover(message, "Listener expired");
                logger.debug(null, "retryMessage", LogMessage.METHOD_EXIT);
                return;
            }
            logger.info(null, "retryMessage", (LogMessage)JMSLogMessage.SERVLET_RETRY, ++retryCnt, this.maxRetry, message.getJMSMessageID(), message.getJMSReplyTo());
            message.setIntProperty("retry_count", retryCnt);
            Thread.yield();
            Thread.sleep(this.maxSleep);
            try {
                requestQueue.put((DME2JMSMessage)message);
            }
            catch (Exception e) {
                logger.debug((URI)null, "retryMessage", "Exception", (Object)new ErrorContext().add(EXTENDEDMESSAGE, e.toString()));
                continue;
            }
            break;
        }
        logger.debug(null, "retryMessage", LogMessage.METHOD_EXIT);
    }

    private void forceFailover(Message message, String failoverMsg) throws Exception {
        logger.warn((URI)null, "forceFailover", "AFT-DME2-6206 {}", (Object)new ErrorContext().add(EVENT, "Server.Reply.Failover").add(RESULT, FAULT).add(REASONCODE, "503").add("failoverMessage", failoverMsg));
        message.setBooleanProperty("JMSXDME2ForceFailoverFlag", true);
        message.setIntProperty("JMSXDME2ForceFailoverCode", 222);
        message.setStringProperty("JMSXDME2ForceFailoverMessage", failoverMsg);
        message.setJMSCorrelationID(message.getJMSMessageID());
        DME2JMSContinuationQueue replyToQueue = (DME2JMSContinuationQueue)message.getJMSReplyTo();
        replyToQueue.put((DME2JMSMessage)message);
        logger.debug(null, "forceFailover", LogMessage.METHOD_EXIT);
    }

    private void setRequestTimeout(HttpServletRequest req, String msgId) {
        long overrideTimeout = this.config.getLong("AFT_DME2_SERVER_REPLY_OVERRIDE_TIMEOUT_MS");
        if (overrideTimeout > 0L) {
            this.continuationTimeout = overrideTimeout;
        } else {
            String serverTimeout = req.getHeader(this.config.getProperty("DME2_HEADER_PREFIX") + "AFT_DME2_EP_READ_TIMEOUT_MS");
            if (serverTimeout == null) {
                serverTimeout = req.getHeader("AFT_DME2_EP_READ_TIMEOUT_MS");
            }
            if (serverTimeout != null) {
                try {
                    this.continuationTimeout = Long.parseLong(serverTimeout);
                }
                catch (Exception e) {
                    logger.debug((URI)null, "setRequestTimeout", "Exception {}", (Object)new ErrorContext().add(EXTENDEDMESSAGE, e.toString()));
                }
            } else {
                this.continuationTimeout = this.config.getLong("AFT_DME2_SERVER_REPLY_DEFAULT_TIMEOUT_MS");
            }
        }
        logger.debug((URI)null, "setRequestTimeout", "DME2JMSServlet.setRequestTimeout;Setting continuation timeout for request with JMSMessageID {}; ContinuationTimeoutinMs={}", (Object)msgId, (Object)this.continuationTimeout);
    }

    private List<Object> getHeaderFilter() {
        String defaultHttpHeadersToRemove = this.config.getProperty("DME2_HTTP_DEFAULT_HEADERS_TO_REMOVE").replaceAll("\\s", "");
        String httpHeadersToRemove = this.config.getProperty("DME2_HTTP_HEADERS_TO_REMOVE").replaceAll("\\s", "");
        return Arrays.asList(ArrayUtils.addAll(defaultHttpHeadersToRemove.split(","), httpHeadersToRemove.split(",")));
    }
}

