/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.jms;

import com.att.aft.dme2.jms.DME2JMSMessage;
import com.att.aft.dme2.jms.DME2JMSQueue;
import com.att.aft.dme2.jms.MessageListenerHolder;
import com.att.aft.dme2.jms.util.JMSLogMessage;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import java.net.URI;

class MessageArrivalProcessor
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(MessageArrivalProcessor.class.getName());
    private final DME2JMSMessage m;
    private final MessageListenerHolder h;
    private boolean qdebug = false;

    public MessageArrivalProcessor(DME2JMSQueue q, DME2JMSMessage m, MessageListenerHolder holder) {
        logger.debug(null, "MessageArrivalProcessor", LogMessage.METHOD_ENTER);
        this.m = m;
        this.h = holder;
        if (q != null) {
            this.qdebug = q.isQdebug();
        }
        logger.debug(null, "MessageArrivalProcessor", LogMessage.METHOD_EXIT);
    }

    @Override
    public void run() {
        logger.debug(null, "run", LogMessage.METHOD_ENTER);
        try {
            logger.debug((URI)null, "run", "MessageArrivalProcessor run {}", (Object)this.m.getJMSMessageID());
            if (this.qdebug) {
                logger.info((URI)null, "run", (LogMessage)JMSLogMessage.QUEUE_RUN, (Object)this.m.getJMSMessageID());
            }
            this.h.onMessage(this.m);
        }
        catch (Throwable e) {
            logger.warn((URI)null, "run", (LogMessage)JMSLogMessage.QUEUE_RUN_EX, (Object)e);
        }
        finally {
            if (!this.h.isReceiver()) {
                if (this.m != null) {
                    logger.debug(null, "run", "!h.isReceiver checkin invoked");
                    if (this.qdebug) {
                        logger.info((URI)null, "run", (LogMessage)JMSLogMessage.QUEUE_RUN_HOLDER, (Object)this.h);
                    }
                }
                this.h.checkin();
            }
            logger.debug(null, "run", LogMessage.METHOD_EXIT);
        }
    }
}

