/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.jms;

import com.att.aft.dme2.jms.DME2JMSDefaultListener;
import com.att.aft.dme2.jms.DME2JMSMessage;
import com.att.aft.dme2.jms.DME2JMSMessageConsumer;
import com.att.aft.dme2.jms.DME2JMSQueue;
import com.att.aft.dme2.jms.DME2JMSTextMessage;
import com.att.aft.dme2.jms.util.JMSLogMessage;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.ErrorContext;
import java.net.URI;
import java.util.Enumeration;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;

class MessageListenerHolder {
    private final MessageListener listener;
    private final String filter;
    private final DME2JMSMessageConsumer consumer;
    private boolean checkedOut = false;
    private boolean receiverType = false;
    private boolean qdebug = false;
    private Message msg = null;
    private final Destination destination;
    private static final Logger logger = LoggerFactory.getLogger(MessageListenerHolder.class.getName());

    public MessageListenerHolder(DME2JMSMessageConsumer consumer, MessageListener listener, String filter, Destination dest) {
        this.listener = listener;
        this.filter = filter;
        this.consumer = consumer;
        if (this.listener instanceof DME2JMSDefaultListener) {
            this.receiverType = true;
        }
        this.destination = dest;
        try {
            DME2JMSQueue queue = (DME2JMSQueue)this.destination;
            this.qdebug = queue.isQdebug();
        }
        catch (Throwable e) {
            logger.debug((URI)null, "MessageListenerHolder", "Exception", (Object)new ErrorContext().add("extendedMessage", e.toString()));
        }
    }

    public boolean matches(DME2JMSMessage m) throws JMSException {
        boolean match = m.matches(this.filter);
        logger.debug(null, "matches", "MessageListenerHolder [{}] - matches filter={};match={}", this.destination.toString(), this.filter, match);
        if (this.qdebug) {
            logger.info(null, "matches", (LogMessage)JMSLogMessage.QUEUE_MATCHES, this.destination, this.filter, match, this.listener);
        }
        return match;
    }

    public boolean isReceiver() {
        return this.receiverType;
    }

    public void onMessage(DME2JMSMessage m) throws JMSException {
        this.msg = m;
        try {
            this.listener.onMessage(this.msg);
        }
        catch (RuntimeException e) {
            logger.error((URI)null, "onMessage", "Exception", (Object)e);
        }
        if (this.qdebug) {
            logger.info((URI)null, "onMessage", (LogMessage)JMSLogMessage.QUEUE_MATCHES, (Object)this.destination, (Object)this.listener);
        }
    }

    public DME2JMSTextMessage copy(DME2JMSMessage message) throws JMSException {
        DME2JMSTextMessage copy = new DME2JMSTextMessage();
        Properties properties = message.getProperties();
        Enumeration<?> propertyNames = message.getPropertyNames();
        while (propertyNames.hasMoreElements()) {
            String name = propertyNames.nextElement().toString();
            String value = properties.getProperty(name);
            copy.setStringProperty(name, value);
        }
        if (message instanceof DME2JMSTextMessage) {
            copy.setText(((DME2JMSTextMessage)message).getText());
        }
        if (message.getJMSCorrelationID() != null) {
            copy.setJMSCorrelationID(message.getJMSCorrelationID());
        }
        if (message.getJMSCorrelationIDAsBytes() != null) {
            copy.setJMSCorrelationIDAsBytes(message.getJMSCorrelationIDAsBytes());
            copy.setJMSDeliveryMode(message.getJMSDeliveryMode());
        }
        if (message.getJMSDestination() != null) {
            copy.setJMSDestination(message.getJMSDestination());
        }
        copy.setJMSExpiration(message.getJMSExpiration());
        if (message.getJMSMessageID() != null) {
            copy.setJMSMessageID(message.getJMSMessageID());
        }
        copy.setJMSPriority(message.getJMSPriority());
        copy.setJMSRedelivered(message.getJMSRedelivered());
        if (message.getJMSReplyTo() != null) {
            copy.setJMSReplyTo(message.getJMSReplyTo());
        }
        copy.setJMSTimestamp(message.getJMSTimestamp());
        if (message.getJMSType() != null) {
            copy.setJMSType(message.getJMSType());
        }
        return copy;
    }

    public boolean acceptsMessage(DME2JMSMessage m) throws JMSException {
        return m.matches(this.filter);
    }

    public boolean isSameListener(DME2JMSMessageConsumer consumer) {
        return this.consumer.getID().equals(consumer.getID());
    }

    public boolean isSameListener(MessageListener jlistener) {
        return jlistener instanceof DME2JMSDefaultListener && ((DME2JMSDefaultListener)this.listener).getID() == ((DME2JMSDefaultListener)jlistener).getID();
    }

    public synchronized boolean isAvailable() {
        logger.debug((URI)null, "isAvailable", "MessageListenerHolder [{}] - isAvailable {}", (Object)this.destination.toString(), (Object)(!this.checkedOut ? 1 : 0));
        if (this.qdebug) {
            logger.info((URI)null, "isAvailable", (LogMessage)JMSLogMessage.QUEUE_LISTEN_AVAIL, (Object)this.listener, (Object)(!this.checkedOut ? 1 : 0));
        }
        return !this.checkedOut;
    }

    public synchronized void checkout() {
        if (this.qdebug) {
            logger.info((URI)null, "checkout", (LogMessage)JMSLogMessage.QUEUE_CHECKING_OUT, (Object)this.listener);
        }
        this.checkedOut = true;
    }

    public synchronized void checkin() {
        if (this.qdebug) {
            logger.info((URI)null, "checkout", (LogMessage)JMSLogMessage.QUEUE_CHECKING_IN, (Object)this.listener);
        }
        this.checkedOut = false;
    }
}

