/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.jms.quick;

import com.att.aft.dme2.jms.util.JMSLogMessage;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Session;

public class QuickListener
implements Runnable,
MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(QuickListener.class.getName());
    private MessageListener listener;

    public QuickListener(Connection connection, Destination destination, Session session, MessageListener listener) {
        this.listener = listener;
    }

    public void onMessage(Message message) {
        long start = System.currentTimeMillis();
        try {
            Queue replyTo = (Queue)message.getJMSReplyTo();
            this.listener.onMessage(message);
            long elapsed = System.currentTimeMillis() - start;
            if (replyTo == null) {
                logger.info(null, "onMessage", (LogMessage)JMSLogMessage.QUICK_RECOW, message.getJMSMessageID(), message.getJMSCorrelationID(), elapsed);
            } else {
                logger.info(null, "onMessage", (LogMessage)JMSLogMessage.QUICK_RECOW, message.getJMSMessageID(), message.getJMSCorrelationID(), replyTo.getQueueName(), elapsed);
            }
        }
        catch (Throwable e) {
            long elapsed = System.currentTimeMillis() - start;
            try {
                logger.info(null, "onMessage", (LogMessage)JMSLogMessage.QUICK_RECOW, message.getJMSMessageID(), message.getJMSCorrelationID(), elapsed, e);
            }
            catch (JMSException e1) {
                logger.warn(null, "onMessage", (LogMessage)JMSLogMessage.QUICK_RECRR, "??; message=" + message, "", elapsed, e);
            }
        }
    }

    @Override
    public void run() {
    }
}

