/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.jms.samples;

import com.att.aft.dme2.jms.samples.TestReceiveServerListener;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class TestReceiveServer {
    private static final Logger logger = LoggerFactory.getLogger(TestReceiveServer.class);
    private String jndiClass = null;
    private String jndiUrl = null;
    private String serverConn = null;
    private String serverDest = null;
    private int threads = 0;
    private int receiveTimeout = 0;
    private QueueConnection connection = null;
    private static final int CONSTANT_30000 = 30000;
    private static final int CONSTANT_5000 = 5000;
    private TestReceiveServerListener[] listeners = null;

    public TestReceiveServer(String jndiClass, String jndiUrl, String serverConn, String serverDest, int threads, int receiveTimeout) throws Exception {
        logger.debug(null, "ctor", LogMessage.METHOD_ENTER);
        logger.info(null, "ctor", "jndiClass={} jndiUrl={} serverConn={} serverDest={} threads={} receiveTimeout={}", jndiClass, jndiUrl, serverConn, serverDest, threads, receiveTimeout);
        this.jndiClass = jndiClass;
        this.jndiUrl = jndiUrl;
        this.serverConn = serverConn;
        this.serverDest = serverDest;
        this.threads = threads;
        this.receiveTimeout = receiveTimeout;
        logger.debug(null, "ctor", LogMessage.METHOD_EXIT);
    }

    public void start() throws JMSException, NamingException {
        logger.debug(null, "start", LogMessage.METHOD_ENTER);
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("java.naming.factory.initial", this.jndiClass);
        table.put("java.naming.provider.url", this.jndiUrl);
        System.out.println("Getting InitialContext");
        InitialContext context = new InitialContext(table);
        System.out.println("Looking up QueueConnectionFactory");
        QueueConnectionFactory qcf = (QueueConnectionFactory)context.lookup(this.serverConn);
        System.out.println("Looking up request Queue");
        Queue requestQueue = (Queue)context.lookup(this.serverDest);
        System.out.println("Creating QueueConnection");
        this.connection = qcf.createQueueConnection();
        this.listeners = new TestReceiveServerListener[this.threads];
        for (int i = 0; i < this.threads; ++i) {
            this.listeners[i] = new TestReceiveServerListener(this.connection, requestQueue, this.receiveTimeout);
            this.listeners[i].start();
        }
        logger.debug(null, "start", LogMessage.METHOD_EXIT);
    }

    public void stop() throws JMSException {
        logger.debug(null, "stop", LogMessage.METHOD_ENTER);
        if (this.listeners != null) {
            for (int i = 0; i < this.threads; ++i) {
                this.listeners[i].stop1();
            }
        }
        this.listeners = null;
        this.connection.close();
        this.connection = null;
        logger.debug(null, "stop", LogMessage.METHOD_EXIT);
    }

    public static void main(String[] args) throws Exception {
        logger.debug(null, "main", LogMessage.METHOD_ENTER);
        String jndiClass = null;
        String jndiUrl = null;
        String serverConn = null;
        String serverDest = null;
        String serverThreadsStr = "0";
        String receiveTimeoutStr = null;
        System.out.println("Starting HttpJMS TestServer");
        String usage = "TestServer -jndiClass <jndiClass> -jndiUrl <jndiUrl> -serverConn <url> -serverDest <url> -serverThreads <n> -receiveTimeout <value>";
        for (int i = 0; i < args.length; ++i) {
            if ("-jndiClass".equals(args[i])) {
                jndiClass = args[i + 1];
                continue;
            }
            if ("-jndiUrl".equals(args[i])) {
                jndiUrl = args[i + 1];
                continue;
            }
            if ("-serverConn".equals(args[i])) {
                serverConn = args[i + 1];
                continue;
            }
            if ("-serverDest".equals(args[i])) {
                serverDest = args[i + 1];
                continue;
            }
            if ("-serverThreads".equals(args[i])) {
                serverThreadsStr = args[i + 1];
                continue;
            }
            if ("-receiveTimeout".equals(args[i])) {
                receiveTimeoutStr = args[i + 1];
                continue;
            }
            if (!"-?".equals(args[i])) continue;
            System.out.println(usage);
            System.exit(0);
        }
        int serverThreads = Integer.parseInt(serverThreadsStr);
        int receiveTimeout = 30000;
        if (receiveTimeoutStr != null) {
            receiveTimeout = Integer.parseInt(receiveTimeoutStr);
        }
        System.out.println("Running with following arguments:");
        System.out.println("    JNDI Provider Class: " + jndiClass);
        System.out.println("    JNDI Provider URL: " + jndiUrl);
        System.out.println("    Server Connection: " + serverConn);
        System.out.println("    Server Destination: " + serverDest);
        System.out.println("    Server Threads: " + serverThreads);
        System.out.println("    Server Receive timeout: " + receiveTimeout);
        TestReceiveServer server = null;
        if (serverThreads > 0) {
            System.out.println("Starting listeners...");
            server = new TestReceiveServer(jndiClass, jndiUrl, serverConn, serverDest, serverThreads, receiveTimeout);
            server.start();
        } else {
            System.out.flush();
            System.err.println("No thread count specified, cannot start server");
            System.exit(1);
        }
        while (true) {
            Thread.sleep(5000L);
        }
    }
}

