/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.jms.util;

import com.att.aft.dme2.internal.jetty.continuation.Continuation;
import com.att.aft.dme2.internal.jetty.continuation.ContinuationListener;
import com.att.aft.dme2.jms.DME2JMSContinuationQueue;
import com.att.aft.dme2.jms.DME2JMSTextMessage;
import com.att.aft.dme2.jms.util.JMSLogMessage;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import java.net.URI;
import javax.jms.JMSException;

public class DME2ContinuationEventListener
implements ContinuationListener {
    private DME2JMSContinuationQueue cQueue;
    private String msgId;
    private String reqQueue;
    private static final Logger logger = LoggerFactory.getLogger(DME2ContinuationEventListener.class.getName());

    public DME2ContinuationEventListener(DME2JMSContinuationQueue cQueue, String msgId, String reqQueue) {
        this.cQueue = cQueue;
        this.msgId = msgId;
        this.reqQueue = reqQueue;
    }

    @Override
    public void onComplete(Continuation arg0) {
        logger.debug((URI)null, "onComplete", "DME2ContinuationEventListener onComplete invoked for correlationID", (Object)this.msgId);
    }

    @Override
    public void onTimeout(Continuation arg0) {
        logger.debug((URI)null, "onComplete", "Continuation onTimeout invoked for correlationID: ", (Object)this.msgId);
        DME2JMSTextMessage errMsg = new DME2JMSTextMessage();
        try {
            errMsg.setText("");
            logger.debug((URI)null, "onComplete", "DME2ContinuationEventListener timeout invoked for correlationID ", (Object)this.msgId);
            errMsg.setJMSCorrelationID(this.msgId);
            errMsg.setStringProperty("requestQueue", this.reqQueue);
            errMsg.setBooleanProperty("JMSXDME2ForceFailoverFlag", true);
            errMsg.setIntProperty("JMSXDME2ForceFailoverCode", -1);
            errMsg.setStringProperty("JMSXDME2ForceFailoverMessage", "Continuation timed out for correlationID:" + this.msgId);
            this.cQueue.put(errMsg);
        }
        catch (JMSException e) {
            logger.debug((URI)null, "exception in onTimeout for ", this.msgId, (Object)e);
            logger.error((URI)null, "onTimeout", (LogMessage)JMSLogMessage.CONTINUATION_FAIL, (Object)this.msgId, (Object)e);
        }
        try {
            arg0.complete();
        }
        catch (Exception e) {
            logger.error((URI)null, "onTimeout", (LogMessage)JMSLogMessage.CONTINUATION_FAIL, (Object)this.msgId, (Object)e);
        }
    }
}

