/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.logging;

import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.ErrorCatalog;
import java.net.URI;
import java.util.ResourceBundle;

public class DME2LoggingConfig {
    private static final Logger logger = LoggerFactory.getLogger(DME2LoggingConfig.class.getCanonicalName());
    private static DME2LoggingConfig loggingConfig;
    private static ResourceBundle errorTable;

    private DME2LoggingConfig() {
    }

    public static DME2LoggingConfig getInstance() {
        if (loggingConfig == null) {
            loggingConfig = new DME2LoggingConfig();
        }
        return loggingConfig;
    }

    public ResourceBundle initializeDME2ErrorTable(String baseName) {
        if (errorTable == null) {
            try {
                errorTable = ResourceBundle.getBundle(baseName);
                ErrorCatalog.getInstance().addErrorTable(errorTable);
            }
            catch (Throwable e) {
                logger.error((URI)null, "initializeDME2ErrorTable", LogMessage.ERRORTABLE_MISSING, (Object)e);
            }
        }
        return errorTable;
    }
}

