/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.manager.registry;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.cache.domain.CacheElement;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.manager.registry.DME2AbstractRegistryCache;
import com.att.aft.dme2.manager.registry.DME2EndpointRegistryAdapter;
import com.att.aft.dme2.request.DmeUniformResource;
import com.att.aft.dme2.util.ErrorContext;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public abstract class DME2AbstractEndpointRegistry
implements DME2EndpointRegistryAdapter {
    private static final Logger logger = LoggerFactory.getLogger(DME2AbstractEndpointRegistry.class);
    private double[] DISTANCE_BANDS = null;
    public static final double CALCULATED_DISTANCE_MAX = 20000.0;
    private static final double[] DISTANCE_BANDS_DEFAULT = new double[]{0.1, 500.0, 5000.0, 20000.0};
    private static Long ROUTEOFFER_STALE_PERIOD_IN_MS = null;
    private DME2Configuration config;
    protected DME2AbstractRegistryCache<String, Long> staleEndpointCache;
    protected DME2AbstractRegistryCache<String, Long> staleRouteOfferCache;
    protected String managerName;
    private static Double clientLatitude;
    private static Double clientLongitude;
    private byte[] lock = new byte[0];

    public DME2AbstractRegistryCache<String, Long> getStaleEndpointCache() {
        return this.staleEndpointCache;
    }

    public DME2AbstractRegistryCache<String, Long> getStaleRouteOfferCache() {
        return this.staleRouteOfferCache;
    }

    public DME2AbstractEndpointRegistry(DME2Configuration config, String managerName) throws DME2Exception {
        if (managerName == null || managerName.isEmpty()) {
            throw new DME2Exception("AFT-DME2-9603", "Manager name must not be null or empty during Endpoint Registry construction", new Object[0]);
        }
        this.managerName = managerName;
        this.config = config;
        if (DME2AbstractEndpointRegistry.getClientLatitude() == null || DME2AbstractEndpointRegistry.getClientLongitude() == null) {
            clientLatitude = config.getDouble("AFT_LATITUDE");
            clientLongitude = config.getDouble("AFT_LONGITUDE");
            if (DME2AbstractEndpointRegistry.getClientLatitude() == null || DME2AbstractEndpointRegistry.getClientLongitude() == null) {
                throw new DME2Exception("AFT_DME2_0000", "AFT_LATITUDE or AFT_LONGITUDE were null from configuration.  These lat,long values are required.", new Object[0]);
            }
        }
        boolean isExcludingOutOfBandEndpoints = config.getBoolean("DME2_ENDPOINT_BANDS_EXCLUDE_OUT_OF_BAND");
        String bandStrs = config.getProperty("DME2_ENDPOINT_BANDS");
        if (bandStrs != null) {
            String[] bandToks = bandStrs.split(",");
            double[] distanceBands = new double[bandToks.length];
            for (int i = 0; i < bandToks.length; ++i) {
                distanceBands[i] = Double.parseDouble(bandToks[i]);
            }
            if (distanceBands.length > 0) {
                int length = distanceBands.length;
                if (distanceBands[length - 1] >= 20000.0 || isExcludingOutOfBandEndpoints) {
                    this.DISTANCE_BANDS = new double[length];
                    System.arraycopy(distanceBands, 0, this.DISTANCE_BANDS, 0, length);
                } else {
                    this.DISTANCE_BANDS = new double[length + 1];
                    System.arraycopy(distanceBands, 0, this.DISTANCE_BANDS, 0, length);
                    this.DISTANCE_BANDS[length] = 20000.0;
                }
            }
        }
        if (this.DISTANCE_BANDS == null) {
            this.DISTANCE_BANDS = DISTANCE_BANDS_DEFAULT;
        }
    }

    private static void staticInit() {
        String defaultStalePeriod = System.getProperty("AFT_DME2_ROUTEOFFER_STALENESS_IN_MIN");
        if (defaultStalePeriod != null) {
            logger.debug((URI)null, "init", "RouteOffer staleness duration found in System Properties. Value = {} minutes", (Object)defaultStalePeriod);
            try {
                ROUTEOFFER_STALE_PERIOD_IN_MS = Long.parseLong(defaultStalePeriod) * 60000L;
            }
            catch (NumberFormatException e) {
                logger.warn((URI)null, "init", "Exception occured while parsing staleness duration provided in System Properties. Provided value was {}", (Object)defaultStalePeriod);
                ROUTEOFFER_STALE_PERIOD_IN_MS = 900000L;
            }
        }
    }

    @Override
    public void init(Properties properties) throws DME2Exception {
    }

    public DME2Configuration getConfig() {
        return this.config;
    }

    protected DmeUniformResource buildUniformResource(String protocol, String servicePath, String host, int port) throws DME2Exception {
        DmeUniformResource uniformResource = null;
        try {
            if (servicePath.startsWith("http://")) {
                uniformResource = new DmeUniformResource(this.config, servicePath);
            } else {
                String urlStr = null;
                urlStr = servicePath.startsWith("/") ? "http://" + host + ":" + port + servicePath : "http://" + host + ":" + port + "/" + servicePath;
                uniformResource = new DmeUniformResource(this.config, urlStr);
            }
        }
        catch (MalformedURLException e) {
            throw new DME2Exception("AFT-DME2-0607", new ErrorContext().add("extendedMessage", e.getMessage()).add("servicePath", servicePath).add("host", host).add("port", "" + port), (Throwable)e);
        }
        return uniformResource;
    }

    @Override
    public Long getEndpointExpirationTime(String url) {
        return this.staleEndpointCache.get(url);
    }

    @Override
    public Boolean isEndpointStale(String url) {
        return this.staleEndpointCache.get(url) != null;
    }

    @Override
    public void removeStaleEndpoint(String url) {
        this.staleEndpointCache.remove(url);
    }

    @Override
    public void addStaleEndpoint(String url, Long expirationTime) {
        if (expirationTime == null || expirationTime == 0L) {
            expirationTime = 90000L;
        }
        this.staleEndpointCache.put(url, expirationTime);
    }

    @Override
    public void clearStaleEndpoints() {
        this.staleEndpointCache.clear();
    }

    @Override
    public Long getRouteOfferExpirationTime(String url) {
        Long expirationTime = this.staleRouteOfferCache.get(url);
        logger.debug((URI)null, "getRouteOfferExpirationTime", "Checking route offer expiration time for {} (is {})", (Object)url, (Object)expirationTime);
        return expirationTime;
    }

    @Override
    public Boolean isRouteOfferStale(String url) {
        Long expTime = this.getRouteOfferExpirationTime(url);
        if (expTime != null) {
            if (expTime <= System.currentTimeMillis()) {
                this.removeStaleRouteOffer(url);
                logger.debug((URI)null, "isRouteOfferStale", LogMessage.DEBUG_MESSAGE, (Object)"Removed stale route offer from cache: {}", (Object)url);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void removeStaleRouteOffer(String url) {
        logger.debug((URI)null, "removeStaleRouteOffer", "Removing {} from stale route offer cache", (Object)url);
        this.staleRouteOfferCache.remove(url);
        logger.info((URI)null, "removeStaleRouteOffer", "searching it after removal:[{}]", (Object)this.staleRouteOfferCache.get(url));
        if (this.staleRouteOfferCache.get(url) != null) {
            logger.error(null, "removeStaleRouteOffer", "REMOVED STALE ROUTE OFFER` BUT IT IS STILL THERE!");
        }
    }

    @Override
    public void addStaleRouteOffer(String url, Long expirationTime) {
        if (ROUTEOFFER_STALE_PERIOD_IN_MS != null) {
            expirationTime = System.currentTimeMillis() + ROUTEOFFER_STALE_PERIOD_IN_MS;
        } else if (expirationTime == null || expirationTime == 0L) {
            expirationTime = System.currentTimeMillis() + 900000L;
        }
        this.staleRouteOfferCache.put(url, expirationTime);
        logger.debug((URI)null, "addStaleRouteOffer", "Marked RouteOffer stale for service: {}. Staleness duration in milliseconds is: {}", (Object)url, (Object)expirationTime);
    }

    @Override
    public void clearStaleRouteOffers() {
        logger.debug(null, "clearStaleRouteOffers", LogMessage.METHOD_ENTER);
        this.staleRouteOfferCache.clear();
        logger.debug(null, "clearStaleRouteOffers", LogMessage.METHOD_EXIT);
    }

    public static Double getClientLatitude() {
        return clientLatitude;
    }

    public static Double getClientLongitude() {
        return clientLongitude;
    }

    @Override
    public double[] getDistanceBands() {
        return this.DISTANCE_BANDS;
    }

    @Override
    public Set<String> getStaleEndpoints() {
        return this.convertCacheElementKeySet(this.staleEndpointCache.getKeySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getStaleRouteOffers() {
        HashSet<String> keys = new HashSet<String>();
        HashSet keysToRemove = new HashSet();
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            for (CacheElement.Key key : this.staleRouteOfferCache.getKeySet()) {
                Long expTime = this.getRouteOfferExpirationTime((String)key.getKey());
                if (expTime != null) {
                    if (expTime <= System.currentTimeMillis()) {
                        keysToRemove.add(key.getKey());
                        continue;
                    }
                    keys.add((String)key.getKey());
                    continue;
                }
                keysToRemove.add(key.getKey());
            }
            for (String keyToRemove : keysToRemove) {
                this.removeStaleEndpoint(keyToRemove);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return keys;
        }
    }

    private Set<String> convertCacheElementKeySet(Set<CacheElement.Key> cacheKeys) {
        HashSet<String> keys = new HashSet<String>();
        for (CacheElement.Key key : cacheKeys) {
            keys.add((String)key.getKey());
        }
        return keys;
    }

    static {
        DME2AbstractEndpointRegistry.staticInit();
    }
}

