/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.manager.registry;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.cache.AbstractCache;
import com.att.aft.dme2.cache.DME2CacheStats;
import com.att.aft.dme2.cache.domain.CacheElement;
import com.att.aft.dme2.cache.service.DME2Cache;
import com.att.aft.dme2.cache.service.DME2CacheableCallback;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.factory.DME2CacheFactory;
import com.att.aft.dme2.internal.apache.commons.lang3.tuple.ImmutablePair;
import com.att.aft.dme2.internal.apache.commons.lang3.tuple.Pair;
import com.att.aft.dme2.iterator.domain.DME2RouteOffer;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.manager.registry.DME2Endpoint;
import com.att.aft.dme2.manager.registry.DME2EndpointRegistry;
import com.att.aft.dme2.manager.registry.DME2EndpointRegistryType;
import com.att.aft.dme2.manager.registry.DME2RouteInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class DME2AbstractRegistryCache<K, V>
implements DME2CacheableCallback<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(DME2AbstractRegistryCache.class);
    protected DME2Cache cache;
    protected String cacheName;
    protected DME2Configuration config;

    public DME2Cache getCache() {
        return this.cache;
    }

    public DME2AbstractRegistryCache(DME2Configuration config, Class valueClass, DME2EndpointRegistryType type, DME2EndpointRegistry registry, String managerName, boolean isStale) throws DME2Exception {
        this.config = config;
        this.cacheName = valueClass.getName() + "_" + type.toString() + "_" + managerName;
        if (isStale) {
            this.cacheName = this.cacheName + "_stale";
        }
        this.cache = DME2CacheFactory.getCacheManager(config).getCache(this.cacheName);
        if (this.cache == null) {
            String cacheType;
            if (DME2Endpoint.class.equals((Object)valueClass)) {
                cacheType = "EndpointCache";
            } else if (DME2RouteInfo.class.equals((Object)valueClass)) {
                cacheType = "RouteInfoCache";
            } else if (DME2RouteOffer.class.equals((Object)valueClass)) {
                cacheType = "RouteOfferCache";
            } else {
                throw new DME2Exception("SOME-CODE", "Unknown cache type", new Object[0]);
            }
            if (isStale) {
                cacheType = "Stale" + cacheType;
            }
            this.cache = DME2CacheFactory.getCacheManager(config).createCache(this.cacheName, cacheType, this);
        }
    }

    public V get(K key) {
        CacheElement.Value cacheElement = this.cache.get(this.createCacheKey(key));
        if (cacheElement != null) {
            return cacheElement.getValue();
        }
        return null;
    }

    public CacheElement getCacheElement(K key) {
        return this.cache.getEntryView().getEntry(this.createCacheKey(key));
    }

    public void put(K key, V value) {
        CacheElement.Key<K> cacheKey = this.createCacheKey(key);
        ((AbstractCache)this.cache).put(cacheKey, this.createCacheElement(cacheKey, this.createCacheValue(value)));
    }

    protected CacheElement.Key<K> createCacheKey(K key) {
        return new CacheElement.Key<K>(key);
    }

    protected CacheElement.Value<V> createCacheValue(V value) {
        return new CacheElement.Value<V>(value);
    }

    public void remove(K key) {
        this.cache.remove(this.createCacheKey(key));
    }

    public Set<CacheElement.Key> getKeySet() {
        return ((AbstractCache)this.cache).getKeySet();
    }

    public boolean containsKey(K key) {
        return this.get(key) != null;
    }

    public int getCurrentSize() {
        return ((AbstractCache)this.cache).getCurrentSize();
    }

    public void clear() {
        logger.debug(null, "clear", LogMessage.METHOD_ENTER);
        this.cache.clear();
        logger.debug(null, "clear", LogMessage.METHOD_EXIT);
    }

    @Override
    public Map<CacheElement.Key<K>, Pair<CacheElement, Exception>> fetchFromSource(Set<CacheElement.Key<K>> requestValues) {
        HashMap<CacheElement.Key<CacheElement.Key<K>>, Pair<CacheElement, Exception>> map = new HashMap<CacheElement.Key<CacheElement.Key<K>>, Pair<CacheElement, Exception>>();
        for (CacheElement.Key<K> key : requestValues) {
            try {
                CacheElement value = this.fetchFromSource(key);
                map.put(key, new ImmutablePair<CacheElement, Object>(value, null));
            }
            catch (DME2Exception e) {
                map.put(key, new ImmutablePair<Object, DME2Exception>(null, e));
            }
        }
        return map;
    }

    protected CacheElement createCacheElement(CacheElement.Key k, CacheElement.Value v) {
        return ((AbstractCache)this.cache).createElement(k, v);
    }

    public abstract DME2CacheStats getStats(String var1, Integer var2);

    public abstract void disableCacheStats();

    public abstract void enableCacheStats();

    public abstract boolean isCacheStatsEnabled();
}

