/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.manager.registry;

import com.att.aft.dme2.request.DmeUniformResource;
import com.att.aft.dme2.util.DME2URIUtils;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;

public class DME2Endpoint
implements Serializable,
Comparable<DME2Endpoint> {
    private int port;
    private String serviceName;
    private String simpleName;
    private String routeOffer;
    private double latitude;
    private double longitude;
    private long lease;
    private String protocol;
    private String contextPath;
    private String host;
    private String path;
    private String serviceVersion;
    private String envContext;
    private Boolean cached;
    private Properties endpointProperties;
    private String DME2Version;
    private DmeUniformResource dmeUniformResource;
    private String supportedVersionRange;
    private Double distance = null;

    public DME2Endpoint(double distanceToClient) {
        this.distance = distanceToClient;
    }

    public DME2Endpoint() {
    }

    public DME2Endpoint(String servicePath, double distanceToClient) {
        Map<String, String> serviceMap = DME2URIUtils.splitServiceURIString(servicePath);
        this.setServiceName(serviceMap.get("service"));
        this.setRouteOffer(serviceMap.get("routeOffer"));
        this.setServiceVersion(serviceMap.get("version"));
        this.setEnvContext(serviceMap.get("envContext"));
        this.setPath(servicePath);
        this.distance = distanceToClient;
    }

    public String getServiceVersion() {
        return this.serviceVersion;
    }

    public String getEnvContext() {
        return this.envContext;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setSimpleName(String simpleName) {
        this.simpleName = simpleName;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public void setServiceVersion(String serviceVersion) {
        this.serviceVersion = serviceVersion;
    }

    public void setEnvContext(String envContext) {
        this.envContext = envContext;
    }

    public void setRouteOffer(String routeOffer) {
        this.routeOffer = routeOffer;
    }

    public String getRouteOffer() {
        return this.routeOffer;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLease(long lease) {
        this.lease = lease;
    }

    public long getLease() {
        return this.lease;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getPath() {
        return this.path;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getHost() {
        return this.host;
    }

    public Boolean getCached() {
        return this.cached;
    }

    public void setCached(Boolean cached) {
        this.cached = cached;
    }

    public Properties getEndpointProperties() {
        return this.endpointProperties;
    }

    public void setEndpointProperties(Properties endpointProperties) {
        this.endpointProperties = endpointProperties;
    }

    public String toURLString() {
        if (this.protocol == null) {
            this.protocol = "http";
        }
        if (this.path != null && this.path.startsWith("/")) {
            return this.protocol + "://" + this.host + ":" + this.port + this.path;
        }
        return this.protocol + "://" + this.host + ":" + this.port + "/" + this.path;
    }

    public void setDME2Version(String DME2Version) {
        this.DME2Version = DME2Version;
    }

    public String getDME2Version() {
        return this.DME2Version;
    }

    public void setDmeUniformResource(DmeUniformResource DmeUniformResource2) {
        this.dmeUniformResource = DmeUniformResource2;
    }

    public DmeUniformResource getDmeUniformResource() {
        return this.dmeUniformResource;
    }

    public double getDistance() {
        return this.distance;
    }

    public String getServiceEndpointID() {
        if (this.getDmeUniformResource() != null && this.getDmeUniformResource().getUrlType() == DmeUniformResource.DmeUrlType.DIRECT) {
            return this.getDmeUniformResource().toString();
        }
        String format = "%s:%s:%s|%s-%s";
        int i = this.serviceName.indexOf("/envContext=");
        String env = "";
        if (i != -1) {
            int end = this.serviceName.indexOf("/", i + 1);
            if (end == -1) {
                end = this.serviceName.length();
            }
            String subStr = this.serviceName.substring(i, end);
            String[] tokens = subStr.split("=");
            env = tokens[1];
        }
        return String.format(format, this.simpleName, this.serviceVersion, String.valueOf(this.port), this.host, env);
    }

    public String toURLString(String context, String extraContext, String queryString) {
        if (this.protocol == null) {
            this.protocol = "http";
        }
        String url = null;
        url = context != null && context.length() > 0 ? (context.startsWith("/") ? this.protocol + "://" + this.host + ":" + this.port + context : this.protocol + "://" + this.host + ":" + this.port + "/" + context) : (this.path != null && this.path.startsWith("/") ? this.protocol + "://" + this.host + ":" + this.port + this.path : this.protocol + "://" + this.host + ":" + this.port + "/" + this.path);
        int qsIndex = url.indexOf("?");
        String qsExtra = "";
        String curl = url;
        if (qsIndex > -1) {
            url = url.substring(0, qsIndex);
            qsExtra = curl.substring(qsIndex + 1);
        }
        if (extraContext != null && extraContext.length() > 0) {
            url = extraContext.startsWith("/") ? (!url.endsWith("/") ? url + extraContext : url + extraContext.substring(extraContext.indexOf("/") + 1, extraContext.length())) : url + "/" + extraContext;
        }
        if (queryString != null && queryString.length() > 0) {
            url = extraContext != null && extraContext.startsWith("?") ? url + "?" + qsExtra + queryString.substring(1) : (qsExtra.isEmpty() ? (queryString.startsWith("?") ? url + queryString : url + "?" + queryString) : (qsExtra.startsWith("?") ? url + qsExtra + "&" + queryString : url + "?" + qsExtra + "&" + queryString));
        }
        return url;
    }

    public String getSupportedVersionRange() {
        return this.supportedVersionRange;
    }

    public void setSupportedVersionRange(String supportedVersionRange) {
        this.supportedVersionRange = supportedVersionRange;
    }

    @Override
    public int compareTo(DME2Endpoint o) {
        if (o == null) {
            return -1;
        }
        return (int)(this.getDistance() - o.getDistance());
    }

    public boolean equals(Object other) {
        DME2Endpoint de = (DME2Endpoint)other;
        return this.getHost().equals(de.getHost()) && this.getPort() == de.getPort() && this.getContextPath().equals(de.getContextPath());
    }

    public int hashCode() {
        return super.hashCode();
    }
}

