/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.manager.registry;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.manager.registry.DME2EndpointRegistry;
import com.att.aft.dme2.manager.registry.DME2EndpointRegistryFS;
import com.att.aft.dme2.manager.registry.DME2EndpointRegistryGRM;
import com.att.aft.dme2.manager.registry.DME2EndpointRegistryMemory;
import com.att.aft.dme2.manager.registry.DME2EndpointRegistryType;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class DME2EndpointRegistryFactory {
    private static DME2EndpointRegistryFactory factory = new DME2EndpointRegistryFactory();
    private static Map<MapKey, DME2EndpointRegistry> endpointRegistryMap = new ConcurrentHashMap<MapKey, DME2EndpointRegistry>();

    private DME2EndpointRegistryFactory() {
    }

    public static DME2EndpointRegistryFactory getInstance() {
        return factory;
    }

    public DME2EndpointRegistry createEndpointRegistry(String containerName, DME2Configuration config, DME2EndpointRegistryType type, String managerName, Properties props) throws DME2Exception {
        DME2EndpointRegistry endpointRegistry;
        if (containerName == null) {
            throw new UnsupportedOperationException("Attempted to create endpoint registry with null container name");
        }
        if (type == null) {
            throw new UnsupportedOperationException("Attempted to create unknown DME endpoint registry with null type");
        }
        MapKey mapKey = new MapKey(containerName, type);
        switch (type) {
            case FileSystem: {
                endpointRegistry = this.getEndpointRegistry(mapKey);
                if (endpointRegistry != null) break;
                endpointRegistry = new DME2EndpointRegistryFS(config, managerName);
                this.storeEndpointRegistry(mapKey, endpointRegistry);
                break;
            }
            case GRM: {
                endpointRegistry = this.getEndpointRegistry(mapKey);
                if (endpointRegistry != null) break;
                endpointRegistry = new DME2EndpointRegistryGRM(config, managerName);
                this.storeEndpointRegistry(mapKey, endpointRegistry);
                break;
            }
            case Memory: {
                endpointRegistry = this.getEndpointRegistry(mapKey);
                if (endpointRegistry != null) break;
                endpointRegistry = new DME2EndpointRegistryMemory(config, managerName);
                this.storeEndpointRegistry(mapKey, endpointRegistry);
                break;
            }
            case GRMREST: {
                endpointRegistry = this.getEndpointRegistry(mapKey);
                if (endpointRegistry != null) break;
                this.storeEndpointRegistry(mapKey, endpointRegistry);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Attempted to create unknown DME endpoint registry with type " + type.toString());
            }
        }
        endpointRegistry.init(props);
        return endpointRegistry;
    }

    private synchronized void storeEndpointRegistry(MapKey mapKey, DME2EndpointRegistry registry) {
        endpointRegistryMap.put(mapKey, registry);
    }

    private DME2EndpointRegistry getEndpointRegistry(MapKey key) {
        return endpointRegistryMap.get(key);
    }

    class MapKey {
        private String containerName;
        private DME2EndpointRegistryType registryType;

        MapKey(String containerName, DME2EndpointRegistryType registryType) {
            this.containerName = containerName;
            this.registryType = registryType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MapKey mapKey = (MapKey)o;
            if (!this.containerName.equals(mapKey.containerName)) {
                return false;
            }
            return this.registryType == mapKey.registryType;
        }

        public int hashCode() {
            int result = this.containerName.hashCode();
            result = 31 * result + this.registryType.hashCode();
            return result;
        }
    }
}

