/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.manager.registry;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.api.DME2Manager;
import com.att.aft.dme2.api.util.SecurityContext;
import com.att.aft.dme2.cache.domain.CacheElement;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.internal.grm.types.v1.ClientJVMAction;
import com.att.aft.dme2.internal.grm.types.v1.ClientJVMInstance;
import com.att.aft.dme2.internal.grm.v1.FindClientJVMInstanceRequest;
import com.att.aft.dme2.internal.grm.v1.RegisterClientJVMInstanceRequest;
import com.att.aft.dme2.iterator.domain.DME2RouteOffer;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.manager.registry.DME2AbstractEndpointRegistry;
import com.att.aft.dme2.manager.registry.DME2Endpoint;
import com.att.aft.dme2.manager.registry.DME2EndpointCacheGRM;
import com.att.aft.dme2.manager.registry.DME2EndpointRegistryType;
import com.att.aft.dme2.manager.registry.DME2RouteInfo;
import com.att.aft.dme2.manager.registry.DME2RouteInfoCacheGRM;
import com.att.aft.dme2.manager.registry.DME2ServiceEndpointData;
import com.att.aft.dme2.manager.registry.DME2StaleCache;
import com.att.aft.dme2.manager.registry.util.DME2EndpointUtil;
import com.att.aft.dme2.registry.accessor.BaseAccessor;
import com.att.aft.dme2.registry.accessor.GRMAccessorFactory;
import com.att.aft.dme2.registry.dto.ServiceEndpoint;
import com.att.aft.dme2.request.DmeUniformResource;
import com.att.aft.dme2.types.RouteInfo;
import com.att.aft.dme2.util.DME2Constants;
import com.att.aft.dme2.util.DME2URIUtils;
import com.att.aft.dme2.util.DME2Utils;
import com.att.aft.dme2.util.DME2ValidationUtil;
import com.att.aft.dme2.util.ErrorContext;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class DME2EndpointRegistryGRM
extends DME2AbstractEndpointRegistry
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(DME2EndpointRegistryGRM.class);
    private static final String EXTENDED_STRING = "extendedMessage";
    private static final String MANAGER = "manager";
    private static final String KEY_ENABLE_GRM_TOPOLOGY_SERVICE_OVERRIDE = "KEY_ENABLE_GRM_TOPOLOGY_SERVICE_OVERRIDE";
    private static final String DME2_EP_ACCESSOR_CLASS = "DME2_EP_ACCESSOR_CLASS";
    private static final String AFT_DME2_GRM_USER = "DME2_GRM_USER";
    private static final String AFT_DME2_GRM_PASS = "DME2_GRM_PASS";
    private static final String DME_EXCEPTION_INIT_EP_REGISTRY_GRM = "AFT-DME2-0600";
    private static final String REGEX0TO9 = "=[0-9]+";
    private DME2Configuration config;
    private JAXBContext jaxBContext = null;
    private BaseAccessor grm;
    private DME2EndpointCacheGRM endpointCache;
    private DME2RouteInfoCacheGRM routeInfoCache;
    private long sepCacheTtlMs;
    private long sepCacheEmptyTtlMs;
    private long routeInfoCacheTtlMs;
    private int sEPLEASELENGTHMS;
    private boolean iGNOREEXPIREDLEASESEPS;
    private final Map<String, Boolean> fetchRouteInfoFromGRM = new HashMap<String, Boolean>();
    private boolean initialized = false;
    private final byte[] ldapLockObj = new byte[0];
    private final byte[] routeInfoLockObj = new byte[0];
    private long[] emptyCacheTTLRefreshIntervals;
    private final long[] emptyCacheTTLRefreshDefaultIntervals = new long[]{300000L, 300000L, 300000L, 600000L, 900000L};
    private final List<DME2Endpoint> localPublishedList = Collections.synchronizedList(new ArrayList());

    public DME2EndpointRegistryGRM(DME2Configuration config, String managerName) throws DME2Exception {
        super(config, managerName);
        this.config = config;
        this.staleEndpointCache = new DME2StaleCache(config, DME2Endpoint.class, DME2EndpointRegistryType.GRM, this, managerName);
        this.staleRouteOfferCache = new DME2StaleCache(config, DME2RouteOffer.class, DME2EndpointRegistryType.GRM, this, managerName);
        this.emptyCacheTTLRefreshIntervals = this.emptyCacheTTLRefreshDefaultIntervals;
        ClassLoader[] cls = new ClassLoader[]{Thread.currentThread().getContextClassLoader(), this.getClass().getClassLoader(), ClassLoader.getSystemClassLoader()};
        for (ClassLoader cl : Arrays.asList(cls)) {
            if (cl == null) continue;
            try {
                Thread.currentThread().setContextClassLoader(cl);
                this.loadJAXBContext();
                break;
            }
            catch (Exception exception) {
            }
        }
        if (this.jaxBContext == null) {
            throw new DME2Exception("AFT-DME2-0404", "Unable to create JAXBContext with any ClassLoader for RouteInfo", new Object[0]);
        }
    }

    @Override
    public void init(Properties properties) throws DME2Exception {
        super.init(properties);
        this.endpointCache = new DME2EndpointCacheGRM(this.config, this, this.managerName, false);
        this.routeInfoCache = new DME2RouteInfoCacheGRM(this.config, this, this.managerName);
        try {
            GRMAccessorFactory.getInstance();
            this.grm = GRMAccessorFactory.getGrmAccessorHandlerInstance(this.config, SecurityContext.create(this.config));
            this.sepCacheTtlMs = this.getConfig().getLong("DME2_SEP_CACHE_TTL_MS");
            this.sepCacheEmptyTtlMs = this.getConfig().getLong("DME2_SEP_CACHE_EMPTY_TTL_MS");
            this.routeInfoCacheTtlMs = this.getConfig().getLong("DME2_ROUTEINFO_CACHE_TTL_MS");
            this.sEPLEASELENGTHMS = this.getConfig().getInt("DME2_SEP_LEASE_LENGTH_MS");
            this.iGNOREEXPIREDLEASESEPS = this.getConfig().getBoolean("DME2_SEP_IGNORE_LEASE_EXPIRED");
            boolean shutdownEnabled = this.getConfig().getBoolean("AFT_DME2_REG_SHUTDOWN_HOOK");
            if (shutdownEnabled) {
                Runtime.getRuntime().addShutdownHook(new Thread(this));
            }
            this.initialized = true;
        }
        catch (Throwable e) {
            throw new DME2Exception(DME_EXCEPTION_INIT_EP_REGISTRY_GRM, new ErrorContext().add(EXTENDED_STRING, e.getMessage()), e);
        }
    }

    @Override
    public void publish(String service, String path, String host, int port, double latitude, double longitude, String protocol) throws DME2Exception {
        this.publish(service, path, host, port, latitude, longitude, protocol, null, false, null);
    }

    @Override
    public void publish(String service, String path, String host, int port, double latitude, double longitude, String protocol, boolean updateLease) throws DME2Exception {
        this.publish(service, path, host, port, latitude, longitude, protocol, null, updateLease, null);
    }

    @Override
    public void publish(String service, String path, String host, int port, String protocol, Properties props) throws DME2Exception {
        this.publish(service, path, host, port, this.getConfig().getDouble("AFT_LATITUDE"), this.getConfig().getDouble("AFT_LONGITUDE"), protocol, null, false, props);
    }

    @Override
    public void publish(String service, String path, String host, int port, String protocol) throws DME2Exception {
        this.publish(service, path, host, port, protocol, null);
    }

    @Override
    public void publish(String service, String path, String host, int port, String protocol, boolean updateLease) throws DME2Exception {
        this.publish(service, path, host, port, this.getConfig().getDouble("AFT_LATITUDE"), this.getConfig().getDouble("AFT_LONGITUDE"), protocol, null, updateLease, null);
    }

    @Override
    public void publish(String serviceURI, String contextPath, String hostAddress, int port, double latitude, double longitude, String protocol, Properties props, boolean updateLease) throws DME2Exception {
        this.publish(serviceURI, contextPath, hostAddress, port, latitude, longitude, protocol, null, updateLease, props);
    }

    private void publish(String servicePath, String contextPath, String host, int port, Double latitude, Double longitude, String protocol, String namespace, boolean updateLease, Properties props) throws DME2Exception {
        String runTimeHost;
        String routeOffer;
        String hostFromArgs;
        String env;
        assert (this.initialized);
        if (protocol.equalsIgnoreCase("dme2jdbc")) {
            try {
                DME2ValidationUtil.validateJDBCEndpointRequiredFields(props, servicePath);
            }
            catch (DME2Exception e) {
                throw new DME2Exception(e.getErrorCode(), e.getErrorMessage(), new Object[0]);
            }
        }
        DmeUniformResource uniformResource = this.buildUniformResource(protocol, servicePath, host, port);
        String tmpPath = servicePath;
        if (servicePath.contains("?")) {
            tmpPath = servicePath.split("\\?")[0];
        }
        if (uniformResource.getUrlType() == DmeUniformResource.DmeUrlType.STANDARD && uniformResource.getBindContext() != null) {
            contextPath = uniformResource.getBindContext();
        } else if (contextPath == null) {
            contextPath = tmpPath;
        }
        logger.info(null, "publish", "DME2Constants.AFT_DME2_CONTAINER_ENV_KEY: config-{}, config.getProp - {}, config.getProp.config.getProp - {}", this.config != null ? this.config : null, this.config != null && this.config.getProperty("AFT_DME2_CONTAINER_ENV_KEY") != null ? this.config.getProperty("AFT_DME2_CONTAINER_ENV_KEY") : null, this.config != null && this.config.getProperty("AFT_DME2_CONTAINER_ENV_KEY") != null ? this.config.getProperty(this.config.getProperty("AFT_DME2_CONTAINER_ENV_KEY")) : null);
        String lrmEnv = this.config.getProperty(this.config.getProperty("AFT_DME2_CONTAINER_ENV_KEY"));
        String uriEnv = uniformResource.getEnvContext();
        String string = env = lrmEnv != null ? lrmEnv : uriEnv;
        if (lrmEnv != null) {
            logger.debug((URI)null, "publish", LogMessage.PUBLISH_OVERRIDE, (Object)lrmEnv, (Object)uniformResource.getEnvContext());
        }
        if (lrmEnv != null && !uriEnv.equals(lrmEnv)) {
            tmpPath = tmpPath.replace("envContext=" + uriEnv, "envContext=" + lrmEnv);
        }
        if ((hostFromArgs = this.config.getProperty(this.config.getProperty("AFT_DME2_CONTAINER_HOST_KEY"))) == null) {
            hostFromArgs = host;
        }
        if ((routeOffer = uniformResource.getRouteOffer()) == null) {
            routeOffer = this.config.getProperty("AFT_DME2_DEFAULT_RO");
        }
        if ((runTimeHost = this.config.getProperty(this.config.getProperty("AFT_DME2_CONTAINER_HOST_KEY"))) != null && !DME2Utils.isHostMyLocalHost(runTimeHost, this.config.getBoolean("DME2.DEBUG"))) {
            throw new DME2Exception("AFT-DME2-0613", new ErrorContext().add("uri", uniformResource.toString()).add("host", host).add("lrmhost", runTimeHost).add("port", "" + port).add(EXTENDED_STRING, "JVM arg provided lrmhost value does not match a localhost address"));
        }
        DME2Endpoint publishedEndpoint = DME2EndpointUtil.buildDME2Endpoint(DME2EndpointRegistryGRM.getClientLatitude(), DME2EndpointRegistryGRM.getClientLongitude(), uniformResource, contextPath, env, hostFromArgs, port, protocol, latitude, longitude, props);
        try {
            this.publish(publishedEndpoint);
        }
        catch (DME2Exception e) {
            if (this.isGRMRetryException(e)) {
                this.localPublishedList.add(publishedEndpoint);
            }
            throw e;
        }
        this.localPublishedList.add(publishedEndpoint);
        logger.debug((URI)null, "publish", LogMessage.PUBLISH_ENDPOINT, (Object)host, (Object)port);
    }

    private void publish(DME2Endpoint publishedEndpoint) throws DME2Exception {
        this.grm.addServiceEndPoint(DME2EndpointUtil.convertToServiceEndpoint(this.config, publishedEndpoint));
    }

    public void unpublish(DME2Endpoint endpoint) throws DME2Exception {
        if (endpoint.getDmeUniformResource() != null) {
            this.unpublish(endpoint.getDmeUniformResource().getOriginalURL().toString(), endpoint.getContextPath(), endpoint.getHost(), endpoint.getPort());
        } else {
            this.unpublish(endpoint.getPath(), endpoint.getContextPath(), endpoint.getHost(), endpoint.getPort());
        }
    }

    @Override
    public void unpublish(String serviceName, String host, int port) throws DME2Exception {
        this.unpublish(serviceName, null, host, port);
    }

    private void unpublish(String originalServicePath, String contextPath, String host, int port) throws DME2Exception {
        String servicePath = originalServicePath;
        logger.debug(null, "unpublish", LogMessage.UNPUBLISH_ENTER);
        Object urlStr = null;
        DmeUniformResource uniformResource = this.buildUniformResource(null, servicePath, host, port);
        String lrmEnv = this.config.getProperty(this.config.getProperty("AFT_DME2_CONTAINER_ENV_KEY"));
        String serviceName = uniformResource.getService();
        String version = uniformResource.getVersion();
        String namespace = uniformResource.getNamespace();
        String env = lrmEnv != null ? lrmEnv : uniformResource.getEnvContext();
        logger.debug((URI)null, "unpublish", LogMessage.UNPUBLISH_ENV, (Object)lrmEnv, (Object)uniformResource.getEnvContext());
        ServiceEndpoint serviceEndpoint = new ServiceEndpoint();
        serviceEndpoint.setContextPath(contextPath);
        serviceEndpoint.setHostAddress(host);
        serviceEndpoint.setPort(String.valueOf(port));
        serviceEndpoint.setName(serviceName);
        serviceEndpoint.setVersion(version);
        serviceEndpoint.setEnv(env);
        this.grm.deleteServiceEndPoint(serviceEndpoint);
        logger.debug((URI)null, "unpublish", LogMessage.UNPUBLISHED, (Object)host, (Object)port);
        if (!servicePath.startsWith("/")) {
            servicePath = "/" + servicePath;
        }
        ArrayList<DME2Endpoint> publishedList = new ArrayList<DME2Endpoint>();
        publishedList.addAll(this.localPublishedList);
        String csvcName = namespace == null ? serviceName : namespace + DME2Constants.getNAME_SEP() + serviceName;
        for (DME2Endpoint ep : publishedList) {
            if (!ep.getHost().equals(host) || ep.getPort() != port || !ep.getServiceName().equals(csvcName) || !ep.getEnvContext().equals(env)) continue;
            logger.debug(null, "unpublish", "DME2EndpointRegistryGRM.unpublish removing from publishedList ep serviceName={},envContext={},host={},port={}", ep.getServiceName(), ep.getEnvContext(), ep.getHost(), ep.getPort());
            this.localPublishedList.remove(ep);
        }
        if (this.endpointCache.containsKey(servicePath)) {
            logger.debug((URI)null, "unpublish", "Removing/refreshing endpoint for localPublishedEndpoint servicePath {}", (Object)servicePath);
            this.endpointCache.refreshCachedEndpoint(servicePath);
        }
        logger.debug(null, "unpublish", LogMessage.UNPUBLISH_EXIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DME2Endpoint> refreshCachedEndpoint(String service) throws DME2Exception {
        logger.debug(null, "refreshCachedEndpoint", LogMessage.METHOD_ENTER);
        long start = System.currentTimeMillis();
        ArrayList<DME2Endpoint> endpointList = new ArrayList<DME2Endpoint>();
        String serviceName = null;
        String serviceVersion = null;
        String envContext = null;
        String routeOffer = null;
        try {
            String uriStr = "http://DME2LOCAL/" + service;
            DmeUniformResource uri = new DmeUniformResource(this.config, new URI(uriStr));
            serviceName = uri.getService();
            serviceVersion = uri.getVersion();
            envContext = uri.getEnvContext();
            routeOffer = uri.getRouteOffer();
            String serviceURI = DME2URIUtils.buildServiceURIString(serviceName, serviceVersion, envContext, routeOffer);
            endpointList.addAll(this.fetchEndpoints(serviceName, serviceVersion, envContext, routeOffer, serviceURI));
        }
        catch (Exception e) {
            throw new DME2Exception("AFT-DME2-0605", new ErrorContext().add(EXTENDED_STRING, e.getMessage()).add(MANAGER, this.managerName).add("uri", service), (Throwable)e);
        }
        byte[] byArray = this.ldapLockObj;
        synchronized (this.ldapLockObj) {
            long ttl;
            long lastQueriedAt = 0L;
            if (endpointList.size() > 0) {
                ttl = 0L;
                this.endpointCache.put(service, new DME2ServiceEndpointData(endpointList, service, 0L, System.currentTimeMillis()));
            } else {
                logger.warn((URI)null, "refreshCachedEndpoint", LogMessage.REFRESH_DEFERRED, (Object)service);
                ttl = 0L;
                if (this.endpointCache.get(service) != null) {
                    int emptyCacheRefreshAttemptCount = ((DME2ServiceEndpointData)this.endpointCache.get(service)).getEmptyCacheRefreshAttemptCount();
                    if (emptyCacheRefreshAttemptCount == this.emptyCacheTTLRefreshIntervals.length - 1) {
                        ttl = this.emptyCacheTTLRefreshIntervals[this.emptyCacheTTLRefreshIntervals.length - 1];
                        logger.debug(null, "refreshCachedEndpoint", "SEP Empty Cache TTL has already reached the last interval for service {}. TTL value will remain at: {}. Current empty cache refresh attempt count: {} ", service, ttl, emptyCacheRefreshAttemptCount);
                    } else if (this.emptyCacheTTLRefreshIntervals.length == 1) {
                        ttl = this.emptyCacheTTLRefreshIntervals[0];
                    } else {
                        ttl = this.emptyCacheTTLRefreshIntervals[++emptyCacheRefreshAttemptCount];
                        ((DME2ServiceEndpointData)this.endpointCache.get(service)).setEmptyCacheRefreshAttemptCount(emptyCacheRefreshAttemptCount);
                        logger.debug((URI)null, "refreshCachedEndpoint", "New empty cache refresh attempt count: {}", (Object)emptyCacheRefreshAttemptCount);
                        logger.debug((URI)null, "refreshCachedEndpoint", "Advancing to next Emtpy Cache TTL interval value for service {}. New value: {}", (Object)service, (Object)ttl);
                    }
                }
            }
            if (this.endpointCache.get(service) != null) {
                ((DME2ServiceEndpointData)this.endpointCache.get(service)).setCacheTTL(ttl);
            }
            logger.debug(null, "refreshCachedEndpoint", LogMessage.CACHED_ENDPOINTS, service, System.currentTimeMillis() - start, endpointList.size());
            // ** MonitorExit[var9_8] (shouldn't be in output)
            logger.debug(null, "refreshCachedEndpoint", LogMessage.METHOD_EXIT);
            return endpointList;
        }
    }

    @Override
    public List<DME2Endpoint> findEndpoints(String serviceName, String serviceVersion, String envContext, String routeOffer) throws DME2Exception {
        long start = System.currentTimeMillis();
        assert (this.initialized);
        String servicePath = DME2URIUtils.buildServiceURIString(serviceName, serviceVersion, envContext, routeOffer);
        List<DME2Endpoint> endpointList = null;
        if (this.endpointCache.get(servicePath) != null) {
            endpointList = this.endpointCache.getEndpoints(servicePath);
        }
        if (endpointList != null && endpointList.size() > 0) {
            for (DME2Endpoint endpoint : endpointList) {
                endpoint.setCached(true);
            }
            return endpointList;
        }
        endpointList = this.fetchEndpoints(serviceName, serviceVersion, envContext, routeOffer, servicePath);
        if (endpointList == null) {
            return null;
        }
        for (DME2Endpoint endpoint : endpointList) {
            endpoint.setCached(false);
        }
        return endpointList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DME2RouteInfo getRouteInfo(String serviceName, String serviceVersion, String envContext) throws DME2Exception {
        DME2RouteInfo data = null;
        String path = DME2URIUtils.buildServiceURIString(serviceName, serviceVersion, envContext);
        if (this.fetchRouteInfoFromGRM.containsKey(serviceName) && !this.fetchRouteInfoFromGRM.get(serviceName).booleanValue()) {
            data = (DME2RouteInfo)this.routeInfoCache.get(path);
        } else if (!this.fetchRouteInfoFromGRM.containsKey(serviceName)) {
            data = (DME2RouteInfo)this.routeInfoCache.get(path);
        }
        if (data != null) {
            return data;
        }
        try {
            data = this.fetchRouteInfo(serviceName, serviceVersion, envContext);
            this.fetchRouteInfoFromGRM.remove(serviceName);
        }
        catch (DME2Exception e) {
            this.fetchRouteInfoFromGRM.remove(serviceName);
            throw e;
        }
        byte[] byArray = this.routeInfoLockObj;
        synchronized (this.routeInfoLockObj) {
            this.routeInfoCache.put(path, data);
            // ** MonitorExit[var6_7] (shouldn't be in output)
            logger.debug((URI)null, "getRouteInfo", LogMessage.CACHED_PATH, (Object)path);
            return data;
        }
    }

    @Override
    public void lease(DME2Endpoint endpoint) throws DME2Exception {
        this.renewLease(endpoint);
        logger.debug(null, "lease", LogMessage.RENEW_LEASE, endpoint.getPath(), endpoint.getHost(), endpoint.getPort(), this.sEPLEASELENGTHMS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() {
        assert (this.initialized);
        byte[] byArray = this.ldapLockObj;
        synchronized (this.ldapLockObj) {
            this.endpointCache.clear();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            try {
                this.endpointCache.refresh();
            }
            catch (Exception e) {
                logger.warn(null, "refresh", LogMessage.FORCE_REFRESH_FAILED);
            }
            this.renewAllLeases();
            logger.info((URI)null, "refresh", "AFT-DME2-0630 {}", (Object)new ErrorContext().add("RefreshSuccessful", ""));
            return;
        }
    }

    private void renewLease(DME2Endpoint endpoint) throws DME2Exception {
        assert (this.initialized);
        this.grm.updateServiceEndPoint(DME2EndpointUtil.convertToServiceEndpoint(this.config, endpoint));
        logger.debug((URI)null, "renewLease", LogMessage.PUBLISH_LEASE, (Object)endpoint.getHost(), (Object)endpoint.getPort());
    }

    @Override
    public void shutdown() {
        logger.debug(null, "shutdown", LogMessage.METHOD_ENTER);
        this.endpointCache.shutdownTimerTask();
        this.routeInfoCache.shutdownTimerTask();
        this.unpublishAll();
        logger.debug(null, "shutdown", LogMessage.METHOD_EXIT);
    }

    private void unpublishAll() {
        assert (this.initialized);
        ArrayList<DME2Endpoint> localEpList = new ArrayList<DME2Endpoint>();
        localEpList.addAll(this.localPublishedList);
        for (DME2Endpoint ep : localEpList) {
            try {
                this.unpublish(ep);
            }
            catch (Exception e) {
                logger.warn((URI)null, "unpublishAll", LogMessage.UNPUBLISH_IGNORABLE, (Object)e);
            }
        }
    }

    void loadJAXBContext() throws DME2Exception {
        try {
            this.jaxBContext = JAXBContext.newInstance((String)RouteInfo.class.getPackage().getName());
        }
        catch (JAXBException e) {
            throw new DME2Exception(DME_EXCEPTION_INIT_EP_REGISTRY_GRM, new ErrorContext().add(EXTENDED_STRING, e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public void run() {
        this.shutdown();
    }

    protected void renewAllLeases() {
        assert (this.initialized);
        logger.debug((URI)null, "renewAllLeases", LogMessage.RENEW_ALL_START, (Object)this.localPublishedList.size());
        long start = System.currentTimeMillis();
        Collections.shuffle(this.localPublishedList);
        ArrayList<DME2Endpoint> localEpList = new ArrayList<DME2Endpoint>();
        localEpList.addAll(this.localPublishedList);
        for (DME2Endpoint ep : localEpList) {
            try {
                this.lease(ep);
                logger.debug((URI)null, "renewAllLeases", LogMessage.RENEW_ENDPOINT, (Object)ep.toURLString());
            }
            catch (DME2Exception e) {
                logger.warn((URI)null, "renewAllLeases", LogMessage.RENEW_ENDPT_FAIL, (Object)ep.toURLString(), (Object)e);
            }
        }
        logger.debug((URI)null, "renewAllLeases", LogMessage.RENEW_ALL_END, (Object)this.localPublishedList.size(), (Object)(System.currentTimeMillis() - start));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected List<DME2Endpoint> fetchEndpoints(String serviceName, String serviceVersion, String envContext, String routeOffer, String servicePath) throws DME2Exception {
        long start = System.currentTimeMillis();
        ServiceEndpoint serviceEndpoint = new ServiceEndpoint();
        serviceEndpoint.setName(serviceName);
        serviceEndpoint.setVersion(serviceVersion);
        serviceEndpoint.setEnv(envContext);
        List<ServiceEndpoint> serviceEndpointList = this.grm.findRunningServiceEndPoint(serviceEndpoint);
        logger.debug((URI)null, "fetchEndpoints", "Got {} endpoints from GRM", (Object)serviceEndpointList.size());
        String serviceURI = DME2URIUtils.buildServiceURIString(serviceName, serviceVersion, envContext, routeOffer);
        Iterator<ServiceEndpoint> endpointIterator = serviceEndpointList.iterator();
        HashMap<String, List<DME2Endpoint>> tempCache = new HashMap<String, List<DME2Endpoint>>();
        ArrayList epList = new ArrayList();
        while (endpointIterator.hasNext()) {
            ServiceEndpoint sep = endpointIterator.next();
            String errorMsg = "";
            errorMsg = errorMsg + (sep.getLatitude() == null ? "latitude " : "");
            errorMsg = errorMsg + (sep.getLongitude() == null ? "longitude " : "");
            errorMsg = errorMsg + (sep.getVersion() == null ? "version " : "");
            errorMsg = errorMsg + (sep.getRouteOffer() == null ? "route offer " : "");
            errorMsg = errorMsg + (sep.getPort() == null ? "listen port " : "");
            if (!(errorMsg = errorMsg + (sep.getHostAddress() == null ? "host address " : "")).isEmpty()) {
                errorMsg = "Invalid endpoint returned from GRM. Missing " + errorMsg;
            }
            if (!errorMsg.isEmpty()) {
                logger.warn((URI)null, "fetchEndpoints", LogMessage.DEBUG_MESSAGE, (Object)errorMsg);
                endpointIterator.remove();
                continue;
            }
            try {
                Double.parseDouble(sep.getLatitude());
                Double.parseDouble(sep.getLongitude());
                Double.parseDouble(sep.getPort());
            }
            catch (NumberFormatException e) {
                logger.warn((URI)null, "fetchEndpoints", "Invalid endpoint found for URI: {}. Detailed message: NumberFormatException -  {}.", (Object)sep.getName(), (Object)e.getMessage());
                endpointIterator.remove();
                continue;
            }
            long expireTime = sep.getExpirationTime() != null ? sep.getExpirationTime().toGregorianCalendar(DME2Manager.getTimezone(), DME2Manager.getLocale(), null).getTimeInMillis() : 0L;
            String service = DME2URIUtils.buildServiceURIString(serviceName, serviceVersion, envContext, sep.getRouteOffer());
            DME2Endpoint dme2Endpoint = DME2EndpointUtil.convertEndpoint(sep, service, expireTime, DME2EndpointRegistryGRM.getClientLatitude(), DME2EndpointRegistryGRM.getClientLongitude());
            List endpointList = tempCache.get(service) != null ? (List)tempCache.get(service) : new ArrayList();
            if (this.iGNOREEXPIREDLEASESEPS || !this.isLeaseExpired(sep)) {
                endpointList.add(dme2Endpoint);
            }
            logger.debug((URI)null, "fetchEndpoints", "Adding/updating tempcache key {} with endpoint list of size {}", (Object)service, (Object)endpointList.size());
            tempCache.put(service, endpointList);
        }
        if (tempCache.size() > 0) {
            Collection values = tempCache.values();
            Iterator iter = values.iterator();
            ArrayList allEpList = new ArrayList();
            while (iter.hasNext()) {
                ArrayList localList = (ArrayList)iter.next();
                allEpList.addAll(localList);
            }
            String defaultRouteURI = DME2URIUtils.buildServiceURIString(serviceName, serviceVersion, envContext, this.config.getProperty("AFT_DME2_DEFAULT_RO"));
            tempCache.put(defaultRouteURI, allEpList);
            for (String fservice : tempCache.keySet()) {
                DME2ServiceEndpointData endpointData;
                List flist = (List)tempCache.get(fservice);
                byte[] byArray = this.ldapLockObj;
                // MONITORENTER : this.ldapLockObj
                long ttl = 0L;
                if (flist.size() > 0) {
                    ttl = this.sepCacheTtlMs;
                    if (this.isRouteOfferStale(fservice).booleanValue()) {
                        this.removeStaleRouteOffer(fservice);
                    }
                } else {
                    logger.warn((URI)null, "fetchEndpoints", LogMessage.REFRESH_DEFERRED, (Object)fservice);
                    ttl = this.sepCacheEmptyTtlMs;
                }
                if ((endpointData = this.endpointCache.getEndpointData(fservice)) != null) {
                    endpointData.setEndpointList(flist);
                    endpointData.setCacheTTL(ttl);
                    endpointData.setLastQueried(System.currentTimeMillis());
                } else {
                    endpointData = new DME2ServiceEndpointData(flist, fservice, ttl, System.currentTimeMillis());
                }
                this.endpointCache.put(fservice, endpointData);
                logger.debug(null, "fetchEndpoints", LogMessage.CACHED_ENDPOINTS_FETCH, fservice, System.currentTimeMillis() - start, flist.size());
                // MONITOREXIT : byArray
            }
        }
        if (!this.config.getBoolean("AFT_DME2_ALLOW_EMPTY_SEP_GRM")) return this.endpointCache.getEndpoints(serviceURI);
        String partialURI = DME2URIUtils.buildServiceURIString(serviceName, serviceVersion, envContext);
        ArrayList cachedEpList = new ArrayList();
        for (CacheElement.Key cacheElement : this.endpointCache.getKeySet()) {
            cachedEpList.add(cacheElement.getKey());
        }
        Iterator<CacheElement.Key<Object>> iterator = cachedEpList.iterator();
        block8: while (iterator.hasNext()) {
            String endpointURI = (String)((Object)iterator.next());
            if (!endpointURI.startsWith(partialURI) || endpointURI.contains("~")) continue;
            if (routeOffer != null && routeOffer.contains("~")) {
                String[] routeOffers = routeOffer.split("~");
                int i = 0;
                while (true) {
                    if (i >= routeOffers.length) continue block8;
                    String roService = DME2URIUtils.buildServiceURIString(serviceName, serviceVersion, envContext, routeOffers[i]);
                    this.checkAndMarkStale(tempCache, roService);
                    ++i;
                }
            }
            this.checkAndMarkStale(tempCache, endpointURI);
        }
        return this.endpointCache.getEndpoints(serviceURI);
    }

    protected boolean isLeaseExpired(ServiceEndpoint endpoint) {
        logger.debug(null, "isLeaseExpired", LogMessage.METHOD_ENTER);
        long expireTime = 0L;
        if (endpoint.getExpirationTime() != null) {
            GregorianCalendar gc = endpoint.getExpirationTime().toGregorianCalendar();
            logger.debug((URI)null, "isLeaseExpired", "gc: {}", (Object)gc);
            expireTime = gc.getTimeInMillis();
        }
        logger.debug(null, "isLeaseExpired", "expirationTime: {} convertedExpirationTime: {} currentTime: {} diff: {} TZ: {} Locale: {}", endpoint.getExpirationTime(), expireTime, System.currentTimeMillis(), expireTime - System.currentTimeMillis(), DME2Manager.getTimezone(), DME2Manager.getLocale());
        return expireTime < System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkAndMarkStale(Map<String, List<DME2Endpoint>> filteredEndpoints, String endpointURI) {
        List<DME2Endpoint> clist = filteredEndpoints.get(endpointURI);
        if (clist != null && (clist == null || clist.size() != 0)) return;
        this.addStaleRouteOffer(endpointURI, null);
        byte[] byArray = this.ldapLockObj;
        synchronized (this.ldapLockObj) {
            DME2ServiceEndpointData endpointData = this.endpointCache.getEndpointData(endpointURI);
            if (endpointData != null) {
                endpointData.setEndpointList(new ArrayList<DME2Endpoint>());
                endpointData.setCacheTTL(this.sepCacheEmptyTtlMs);
                endpointData.setLastQueried(System.currentTimeMillis());
            } else {
                endpointData = new DME2ServiceEndpointData(new ArrayList<DME2Endpoint>(), endpointURI, this.sepCacheEmptyTtlMs, System.currentTimeMillis());
            }
            this.endpointCache.put(endpointURI, endpointData);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    protected DME2RouteInfo fetchRouteInfo(String service, String version, String env) throws DME2Exception {
        assert (this.initialized);
        logger.debug((URI)null, "fetchRouteInfo", LogMessage.ENTER_CODEPOINT, (Object)"DME2EndpointRegistryGRM.getRouteInfo");
        DME2RouteInfo data = null;
        ServiceEndpoint serviceEndpoint = new ServiceEndpoint();
        serviceEndpoint.setEnv(env);
        serviceEndpoint.setVersion(version);
        serviceEndpoint.setName(service);
        String xmlContent = this.grm.getRouteInfo(serviceEndpoint);
        logger.debug((URI)null, "fetchRouteInfo", "xmlContent {}", (Object)xmlContent);
        if (xmlContent != null) {
            data = this.buildRouteInfo(service, version, env, xmlContent);
        }
        logger.debug((URI)null, "fetchRouteInfo", LogMessage.EXIT_CODEPOINT, (Object)"DME2EndpointRegistryGRM.getRouteInfo");
        return data;
    }

    private DME2RouteInfo buildRouteInfo(String service, String version, String envContext, String xmlContent) throws DME2Exception {
        logger.debug((URI)null, "buildRouteInfo", LogMessage.ENTER_CODEPOINT, (Object)"DME2EndpointRegistryGRM.buildRouteInfo");
        long start = System.currentTimeMillis();
        DME2RouteInfo data = null;
        try {
            Unmarshaller unmarshaller = this.jaxBContext.createUnmarshaller();
            JAXBElement element = unmarshaller.unmarshal((Source)new StreamSource(new StringReader(xmlContent)), RouteInfo.class);
            RouteInfo rtInfo = (RouteInfo)element.getValue();
            if (rtInfo.getServiceName() == null) {
                rtInfo.setServiceName(service);
            }
            rtInfo.setServiceVersion(version);
            if (rtInfo.getEnvContext() == null) {
                rtInfo.setEnvContext(envContext);
            }
            data = new DME2RouteInfo(rtInfo, this.getConfig());
        }
        catch (JAXBException je) {
            throw new DME2Exception("AFT-DME2-0602", new ErrorContext().add(EXTENDED_STRING, je.getMessage()).add("service", service), (Throwable)je);
        }
        catch (Exception e) {
            throw new DME2Exception("AFT-DME2-0604", new ErrorContext().add(EXTENDED_STRING, e.getMessage()).add("service", service), (Throwable)e);
        }
        logger.debug((URI)null, "buildRouteInfo", LogMessage.EXIT_CODEPOINT_TIME, (Object)"DME2EndpointRegistryGRM.buildRouteInfo", (Object)(System.currentTimeMillis() - start));
        logger.debug((URI)null, "buildRouteInfo", "DME2EndpointRegistryGRM.buildRouteInfo {} ms", (Object)(System.currentTimeMillis() - start));
        return data;
    }

    public boolean isGRMRetryException(DME2Exception e) {
        String errorCode = e.getErrorCode();
        if (errorCode != null) {
            String[] codes;
            String failoverErrCodes = this.config.getProperty("AFT_DME2_GRM_FAILOVER_ERROR_CODES");
            for (String code : codes = failoverErrCodes.split(",")) {
                if (!(code.endsWith("*") ? errorCode.contains(code.substring(0, code.indexOf("*"))) : errorCode.equalsIgnoreCase(code))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public DME2Endpoint[] find(String serviceKey, String version, String env, String routeOffer) throws DME2Exception {
        List<DME2Endpoint> endpoints = this.findEndpoints(serviceKey, version, env, routeOffer);
        return endpoints.toArray(new DME2Endpoint[endpoints.size()]);
    }

    @Override
    public void registerJVM(String envContext, ClientJVMInstance instanceInfo) throws DME2Exception {
        long start = System.currentTimeMillis();
        RegisterClientJVMInstanceRequest registerReq = new RegisterClientJVMInstanceRequest();
        registerReq.setEnv(envContext);
        registerReq.setAction(ClientJVMAction.REGISTER);
        registerReq.setClientJvmInstance(instanceInfo);
        String user = this.config.getProperty(AFT_DME2_GRM_USER);
        String pass = this.config.getProperty(AFT_DME2_GRM_PASS);
        SecurityContext ctx = SecurityContext.create(user, pass, this.config.getBoolean("AFT_DME2_GRM_USE_SSL", false));
        BaseAccessor grmSA = GRMAccessorFactory.getGrmAccessorHandlerInstance(this.config, SecurityContext.create(this.config));
        grmSA.registerClientJVMInstance(registerReq);
        logger.debug((URI)null, "registerJVM", LogMessage.JVM_REGISTER, (Object)"DME2EndpointRegistryGRM.registerJVM", (Object)(System.currentTimeMillis() - start));
    }

    @Override
    public void updateJVM(String envContext, ClientJVMInstance instanceInfo) throws DME2Exception {
        long start = System.currentTimeMillis();
        RegisterClientJVMInstanceRequest registerReq = new RegisterClientJVMInstanceRequest();
        registerReq.setEnv(envContext);
        registerReq.setAction(ClientJVMAction.REFRESH);
        registerReq.setClientJvmInstance(instanceInfo);
        String user = this.config.getProperty(AFT_DME2_GRM_USER);
        String pass = this.config.getProperty(AFT_DME2_GRM_PASS);
        SecurityContext ctx = SecurityContext.create(user, pass, this.config.getBoolean("AFT_DME2_GRM_USE_SSL", false));
        BaseAccessor grmSA = GRMAccessorFactory.getGrmAccessorHandlerInstance(this.config, SecurityContext.create(this.config));
        grmSA.registerClientJVMInstance(registerReq);
        logger.debug((URI)null, "updateJVM", LogMessage.JVM_REGISTER, (Object)"DME2EndpointRegistryGRM.updateJVM", (Object)(System.currentTimeMillis() - start));
    }

    @Override
    public void deregisterJVM(String envContext, ClientJVMInstance instanceInfo) throws DME2Exception {
        long start = System.currentTimeMillis();
        RegisterClientJVMInstanceRequest registerReq = new RegisterClientJVMInstanceRequest();
        registerReq.setEnv(envContext);
        registerReq.setAction(ClientJVMAction.DEREGISTER);
        registerReq.setClientJvmInstance(instanceInfo);
        String user = this.config.getProperty(AFT_DME2_GRM_USER);
        String pass = this.config.getProperty(AFT_DME2_GRM_PASS);
        SecurityContext ctx = SecurityContext.create(user, pass, this.config.getBoolean("AFT_DME2_GRM_USE_SSL", false));
        BaseAccessor grmSA = GRMAccessorFactory.getGrmAccessorHandlerInstance(this.config, SecurityContext.create(this.config));
        grmSA.registerClientJVMInstance(registerReq);
        logger.debug((URI)null, "deregisterJVM", LogMessage.JVM_REGISTER, (Object)"DME2EndpointRegistryGRM.deregisterJVM", (Object)(System.currentTimeMillis() - start));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ClientJVMInstance> findRegisteredJVM(String envContext, Boolean activeOnly, String hostAddress, String mechID, String processID) throws DME2Exception {
        logger.debug(null, "findRegisteredJVM", LogMessage.METHOD_ENTER);
        long start = System.currentTimeMillis();
        List<Object> jvmlist = new ArrayList();
        try {
            FindClientJVMInstanceRequest findReq = new FindClientJVMInstanceRequest();
            findReq.setEnv(envContext);
            findReq.setActiveOnly(activeOnly);
            findReq.setHostAddress(hostAddress);
            findReq.setMechId(mechID);
            findReq.setProcessId(processID);
            String user = this.config.getProperty(AFT_DME2_GRM_USER);
            String pass = this.config.getProperty(AFT_DME2_GRM_PASS);
            SecurityContext ctx = SecurityContext.create(user, pass, this.config.getBoolean("AFT_DME2_GRM_USE_SSL", false));
            BaseAccessor grmSA = GRMAccessorFactory.getGrmAccessorHandlerInstance(this.config, SecurityContext.create(this.config));
            jvmlist = grmSA.findClientJVMInstance(findReq);
        }
        catch (Throwable throwable) {
            logger.debug(null, "findRegisteredJVM", LogMessage.JVM_FIND, "DME2EndpointRegistryGRM.deregisterJVM", jvmlist.size(), System.currentTimeMillis() - start);
            throw throwable;
        }
        logger.debug(null, "findRegisteredJVM", LogMessage.JVM_FIND, "DME2EndpointRegistryGRM.deregisterJVM", jvmlist.size(), System.currentTimeMillis() - start);
        logger.debug(null, "findRegisteredJVM", LogMessage.METHOD_EXIT);
        return jvmlist;
    }

    public boolean containsServiceEndpoint(String serviceName) {
        return this.endpointCache.getEndpointData(serviceName) != null;
    }

    public long getEndpointTTL(String serviceName) {
        DME2ServiceEndpointData data = this.endpointCache.getEndpointData(serviceName);
        if (data != null) {
            return data.getCacheTTL();
        }
        return 0L;
    }
}

