/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.manager.registry;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.internal.apache.commons.collections.CollectionUtils;
import com.att.aft.dme2.internal.grm.types.v1.ClientJVMInstance;
import com.att.aft.dme2.iterator.domain.DME2RouteOffer;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.manager.registry.DME2AbstractEndpointRegistry;
import com.att.aft.dme2.manager.registry.DME2Endpoint;
import com.att.aft.dme2.manager.registry.DME2EndpointRegistryType;
import com.att.aft.dme2.manager.registry.DME2RouteInfo;
import com.att.aft.dme2.manager.registry.DME2StaleCache;
import com.att.aft.dme2.manager.registry.util.DME2DistanceUtil;
import com.att.aft.dme2.request.DmeUniformResource;
import com.att.aft.dme2.util.ErrorContext;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class DME2EndpointRegistryMemory
extends DME2AbstractEndpointRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(DME2EndpointRegistryMemory.class);
    private final List<DME2Endpoint> endpoints = new ArrayList<DME2Endpoint>();
    private double latitude;
    private double longitude;

    public DME2EndpointRegistryMemory(DME2Configuration config, String managerName) throws DME2Exception {
        super(config, managerName);
        LOGGER.debug(null, "DME2EndpointRegistryMemory", LogMessage.METHOD_ENTER);
        this.staleEndpointCache = new DME2StaleCache(config, DME2Endpoint.class, DME2EndpointRegistryType.Memory, this, managerName);
        this.staleRouteOfferCache = new DME2StaleCache(config, DME2RouteOffer.class, DME2EndpointRegistryType.Memory, this, managerName);
        LOGGER.debug(null, "DME2EndpointRegistryMemory", LogMessage.METHOD_EXIT);
    }

    @Override
    public List<DME2Endpoint> findEndpoints(String serviceName, String serviceVersion, String envContext, String routeOffer) {
        LOGGER.debug(null, "findEndpoints", LogMessage.METHOD_ENTER);
        LOGGER.info(null, "findEndpoints", "serviceName={} serviceVersion={} envContext={} routeOffer={}", serviceName, serviceVersion, envContext, routeOffer);
        ArrayList<DME2Endpoint> matching = new ArrayList<DME2Endpoint>();
        for (DME2Endpoint ep : this.endpoints) {
            if (!ep.getServiceName().equals(serviceName) || !this.versionMatches(ep, serviceVersion) || !ep.getEnvContext().equals(envContext) || !ep.getRouteOffer().equals(routeOffer)) continue;
            matching.add(ep);
        }
        LOGGER.debug(null, "findEndpoints", LogMessage.METHOD_EXIT);
        return matching;
    }

    private boolean versionMatches(DME2Endpoint ep, String requestedVersion) {
        if (requestedVersion == null) {
            return true;
        }
        String range = ep.getSupportedVersionRange();
        if (range == null) {
            String serviceVersion = ep.getServiceVersion();
            return serviceVersion.equals(requestedVersion) || serviceVersion.startsWith(requestedVersion + ".");
        }
        String[] rv = requestedVersion.split("\\.");
        String[] startEnd = range.split(",");
        String[] start = startEnd[0].split("\\.");
        switch (Math.min(rv.length, start.length)) {
            case 1: {
                if (Integer.parseInt(rv[0]) >= Integer.parseInt(start[0])) break;
                return false;
            }
            case 2: {
                if (Integer.parseInt(rv[0]) < Integer.parseInt(start[0])) {
                    return false;
                }
                if (Integer.parseInt(rv[0]) != Integer.parseInt(start[0]) || Integer.parseInt(rv[1]) >= Integer.parseInt(start[1])) break;
                return false;
            }
            case 3: {
                if (Integer.parseInt(rv[0]) < Integer.parseInt(start[0])) {
                    return false;
                }
                if (Integer.parseInt(rv[0]) == Integer.parseInt(start[0]) && Integer.parseInt(rv[1]) < Integer.parseInt(start[1])) {
                    return false;
                }
                if (Integer.parseInt(rv[0]) != Integer.parseInt(start[0]) || Integer.parseInt(rv[1]) != Integer.parseInt(start[1]) || rv[1].compareTo(start[1]) >= 0) break;
                return false;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (startEnd[1].equals("*")) {
            return true;
        }
        String[] end = startEnd[1].split("\\.");
        switch (end.length) {
            case 1: {
                if (Integer.parseInt(rv[0]) <= Integer.parseInt(end[0])) break;
                return false;
            }
            case 2: {
                if (Integer.parseInt(rv[0]) > Integer.parseInt(end[0])) {
                    return false;
                }
                if (Integer.parseInt(rv[0]) != Integer.parseInt(end[0]) || Integer.parseInt(rv[1]) <= Integer.parseInt(end[1])) break;
                return false;
            }
            case 3: {
                if (Integer.parseInt(rv[0]) > Integer.parseInt(end[0])) {
                    return false;
                }
                if (Integer.parseInt(rv[0]) == Integer.parseInt(end[0]) && Integer.parseInt(rv[1]) > Integer.parseInt(end[1])) {
                    return false;
                }
                if (Integer.parseInt(rv[0]) != Integer.parseInt(end[0]) || Integer.parseInt(rv[1]) != Integer.parseInt(end[1]) || rv[1].compareTo(end[1]) <= 0) break;
                return false;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return true;
    }

    @Override
    public DME2RouteInfo getRouteInfo(String service, String version, String envContext) throws DME2Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void lease(DME2Endpoint endpoint) throws DME2Exception {
    }

    @Override
    public void publish(String servicePath, String contextPath, String host, int port, String protocol, Properties props) throws DME2Exception {
        this.publish(servicePath, contextPath, host, port, this.latitude, this.longitude, protocol);
    }

    @Override
    public void publish(String service, String path, String host, int port, double latitude, double longitude, String protocol) throws DME2Exception {
        this.publish(service, path, host, port, latitude, longitude, protocol, null, false);
    }

    @Override
    public void publish(String service, String path, String host, int port, double latitude, double longitude, String protocol, boolean updateLease) throws DME2Exception {
        this.publish(service, path, host, port, latitude, longitude, protocol);
    }

    @Override
    public void publish(String service, String path, String host, int port, String protocol, boolean updateLease) throws DME2Exception {
        this.publish(service, path, host, port, this.latitude, this.longitude, protocol, null, updateLease, null);
    }

    private void publish(String newService, String path, String host, int port, double latitude, double longitude, String protocol, String namespace, boolean updateLease, Properties props) throws DME2Exception {
        LOGGER.debug(null, "publish", LogMessage.METHOD_ENTER);
        LOGGER.info(null, "publish", "newService={} path={} host={} port={} latitude={} longitude={} protocol={} namespace={} updateLease={} props={}", newService, path, host, port, latitude, longitude, protocol, namespace, updateLease, props);
        String service = newService;
        String uri = service.startsWith("http://") ? service : "http://" + host + ":" + port + (service.startsWith("/") ? "" : "/") + service;
        DmeUniformResource uniformResource = null;
        try {
            uniformResource = new DmeUniformResource(this.getConfig(), uri);
        }
        catch (Exception e) {
            throw new DME2Exception("AFT-DME2-0607", new ErrorContext().add("extendedMessage", e.getMessage()).add("manager", this.managerName).add("service", service).add("host", host).add("port", "" + port).add("latitude", "" + latitude).add("longitude", "" + longitude).add("protocol", protocol), (Throwable)e);
        }
        if (service.contains("?")) {
            String[] tokens = service.split("\\?");
            service = tokens[0];
        }
        String serviceName = uniformResource.getService();
        String env = uniformResource.getEnvContext();
        DME2Endpoint publishedEndpoint = new DME2Endpoint(DME2DistanceUtil.calculateDistanceBetween(DME2AbstractEndpointRegistry.getClientLatitude(), DME2AbstractEndpointRegistry.getClientLongitude(), latitude, longitude));
        publishedEndpoint.setHost(host);
        publishedEndpoint.setPort(port);
        publishedEndpoint.setDmeUniformResource(uniformResource);
        if (path != null) {
            if (uniformResource.getUrlType() == DmeUniformResource.DmeUrlType.STANDARD) {
                publishedEndpoint.setContextPath(uniformResource.getBindContext());
            } else {
                publishedEndpoint.setContextPath(path);
            }
        } else if (uniformResource.getUrlType() == DmeUniformResource.DmeUrlType.STANDARD) {
            String cpath = uniformResource.getBindContext() + (path == null ? "" : "," + path);
            publishedEndpoint.setContextPath(cpath);
        } else {
            publishedEndpoint.setContextPath(service);
        }
        publishedEndpoint.setPath(service);
        publishedEndpoint.setServiceName(serviceName);
        publishedEndpoint.setEnvContext(env);
        publishedEndpoint.setProtocol(protocol);
        publishedEndpoint.setLatitude(latitude);
        publishedEndpoint.setLongitude(longitude);
        publishedEndpoint.setServiceVersion(uniformResource.getVersion());
        publishedEndpoint.setRouteOffer(uniformResource.getRouteOffer());
        String versionRange = uniformResource.getSupportedVersionRange();
        if (versionRange != null) {
            publishedEndpoint.setSupportedVersionRange(versionRange);
        }
        LOGGER.info((URI)null, "publish", "Published Endpoint: {}", (Object)publishedEndpoint);
        this.endpoints.add(publishedEndpoint);
        LOGGER.debug(null, "findEndpoints", LogMessage.METHOD_ENTER);
    }

    @Override
    public void unpublish(String serviceName, String host, int port) throws DME2Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void refresh() {
        throw new UnsupportedOperationException();
    }

    public long getEndpointCacheUpdatedAt() {
        return 0L;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void init(Properties properties) {
    }

    public void setEndpointCacheUpdatedAt(long currentTime) {
    }

    @Override
    public void publish(String service, String path, String host, int port, String protocol) throws DME2Exception {
        this.publish(service, path, host, port, protocol, null);
    }

    @Override
    public void publish(String serviceURI, String serviceURI2, String hostAddress, int port, double latitude, double longitude, String protocol, Properties props, boolean updateLease) throws DME2Exception {
        this.publish(serviceURI, serviceURI2, hostAddress, port, latitude, longitude, protocol, null, updateLease, props);
    }

    @Override
    public DME2Endpoint[] find(String serviceKey, String version, String env, String routeOffer) throws DME2Exception {
        List<DME2Endpoint> endpoints = this.findEndpoints(serviceKey, version, env, routeOffer);
        DME2Endpoint[] endpointArray = null;
        if (CollectionUtils.isNotEmpty(endpoints)) {
            endpointArray = endpoints.toArray(new DME2Endpoint[endpoints.size()]);
        }
        return endpointArray;
    }

    @Override
    public void registerJVM(String envContext, ClientJVMInstance instanceInfo) throws DME2Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateJVM(String envContext, ClientJVMInstance instanceInfo) throws DME2Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deregisterJVM(String envContext, ClientJVMInstance instanceInfo) throws DME2Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ClientJVMInstance> findRegisteredJVM(String envContext, Boolean activeOnly, String hostAddress, String mechID, String processID) throws DME2Exception {
        throw new UnsupportedOperationException();
    }
}

