/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.manager.registry;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.manager.registry.DME2Endpoint;
import com.att.aft.dme2.manager.registry.DME2JDBCEndpoint;
import com.att.aft.dme2.manager.registry.util.DME2DistanceUtil;
import com.att.aft.dme2.manager.registry.util.DME2FileUtil;
import com.att.aft.dme2.util.DME2URIUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class DME2FileHandler {
    private static final Logger logger = LoggerFactory.getLogger(DME2FileHandler.class);
    private static final String EXCEPTION_EPREGISTRY_FS_LOCK_FILE = "AFT-DME2-9601";
    private static final String EXCEPTION_EPREGISTRY_FS_IO_EXC = "AFT-DME2-9600";
    private final long defaultCacheStaleness;
    private File baseDir;
    private String service;
    private File sourceFile;
    private List<File> inputFiles;
    private double clientLatitude;
    private double clientLongitude;

    public DME2FileHandler(File dir, String service, long defaultCacheStaleness, double clientLatitude, double clientLongitude) throws DME2Exception {
        this.sourceFile = new File(dir, service + ".txt");
        if (!this.sourceFile.exists()) {
            try {
                if (!new File(this.sourceFile.getParent()).mkdirs() && !this.sourceFile.createNewFile()) {
                    throw new DME2Exception(EXCEPTION_EPREGISTRY_FS_IO_EXC, "Unable to create file for service " + service + " with filename " + this.sourceFile.getName(), new Object[0]);
                }
            }
            catch (IOException e) {
                throw new DME2Exception(EXCEPTION_EPREGISTRY_FS_IO_EXC, "Unable to create file for service " + service, (Throwable)e);
            }
        }
        this.inputFiles = DME2FileUtil.hierarchicalFileLookup(dir, service + ".txt");
        if (this.inputFiles.isEmpty()) {
            this.inputFiles.add(this.sourceFile);
        }
        this.baseDir = dir;
        this.service = service;
        this.defaultCacheStaleness = defaultCacheStaleness;
        this.clientLatitude = clientLatitude;
        this.clientLongitude = clientLongitude;
    }

    public long getLastModified() {
        return this.sourceFile.lastModified();
    }

    public List<DME2Endpoint> readEndpoints() throws DME2Exception {
        return this.propsToEps(this.readProperties(), this.service);
    }

    public Properties readProperties() throws DME2Exception {
        Properties props = new Properties();
        for (File inputFile : this.inputFiles) {
            String lockFileName = inputFile.getAbsolutePath();
            lockFileName = lockFileName.substring(0, lockFileName.length() - 4) + ".lock";
            File lockfile = new File(lockFileName);
            RandomAccessFile randomAccessFile = null;
            FileLock fileLock = null;
            try {
                randomAccessFile = new RandomAccessFile(lockfile, "rw");
                fileLock = randomAccessFile.getChannel().tryLock();
                if (fileLock != null) {
                    Properties theseProps = this.loadPropsFromFile(inputFile);
                    for (String s : theseProps.stringPropertyNames()) {
                        props.setProperty(s, theseProps.getProperty(s));
                    }
                    continue;
                }
                throw new DME2Exception(EXCEPTION_EPREGISTRY_FS_LOCK_FILE, "File lock " + lockfile + " is in use", new Object[0]);
            }
            catch (IOException e) {
                throw new DME2Exception(EXCEPTION_EPREGISTRY_FS_IO_EXC, e);
            }
            finally {
                if (fileLock != null && fileLock.isValid()) {
                    try {
                        fileLock.release();
                    }
                    catch (IOException e) {
                        logger.debug((String)null, (URI)null, "readProperties", LogMessage.DEBUG_MESSAGE, (Object)"IO Exception", (Object)e);
                    }
                }
                if (randomAccessFile == null) continue;
                try {
                    randomAccessFile.close();
                }
                catch (IOException e) {
                    logger.debug((String)null, (URI)null, "readProperties", LogMessage.DEBUG_MESSAGE, (Object)"IO Exception", (Object)e);
                }
            }
        }
        return props;
    }

    public void storeProperties(Properties props, boolean includeTimestamp) throws DME2Exception {
        try (PrintWriter writer = null;){
            writer = new PrintWriter(new FileWriter(this.sourceFile));
            String msg = includeTimestamp ? "" + System.currentTimeMillis() : "";
            props.store(writer, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadPropsFromFile(File inputFile) throws IOException {
        inputFile.getParentFile().mkdir();
        inputFile.createNewFile();
        Properties props = new Properties();
        try (FileInputStream is = null;){
            is = new FileInputStream(inputFile);
            props.load(is);
        }
        return props;
    }

    List<DME2Endpoint> propsToEps(Properties props, String path) {
        ArrayList<DME2Endpoint> list = new ArrayList<DME2Endpoint>();
        block8: for (Object obj : props.keySet()) {
            String key = (String)obj;
            String[] hostPort = key.split(",");
            String valueStr = props.getProperty(key);
            String[] valuePairs = valueStr.split(";");
            Double latitude = null;
            Double longitude = null;
            for (String pairStr : valuePairs) {
                String[] pair = pairStr.split("=");
                if (pair.length != 2) continue;
                if (pair[0].equals("latitude")) {
                    if (pair[1] == null) {
                        logger.error((URI)null, "propsToEps", "Invalid endpoint found for URI: {}. Detailed message: Latitude is null", (Object)path);
                        continue block8;
                    }
                    try {
                        latitude = Double.parseDouble(pair[1]);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        logger.error((String)null, (URI)null, "propsToEps", "Invalid endpoint found for URI: {}. Detailed message: NumberFormatException - {}", (Object)path, (Object)e.getMessage());
                        continue block8;
                    }
                }
                if (!pair[0].equals("longitude")) continue;
                if (pair[1] == null) {
                    logger.error((URI)null, "propsToEps", "Invalid endpoint found for URI: {}. Detailed message: Longitude is null", (Object)path);
                    continue block8;
                }
                try {
                    longitude = Double.parseDouble(pair[1]);
                }
                catch (NumberFormatException e) {
                    logger.error((String)null, (URI)null, "propsToEps", "Invalid endpoint found for URI: {}. Detailed message: NumberFormatException - {}", (Object)path, (Object)e.getMessage());
                    continue block8;
                }
            }
            if (latitude == null || longitude == null) {
                logger.error((URI)null, "propsToEps", "Latitude or longitude null for {}", (Object)path);
                continue;
            }
            double distance = DME2DistanceUtil.calculateDistanceBetween(this.clientLatitude, this.clientLongitude, latitude, longitude);
            DME2Endpoint ep = valueStr.contains("protocol=dme2jdbc") ? new DME2JDBCEndpoint(distance) : new DME2Endpoint(distance);
            ep.setHost(hostPort[0]);
            ep.setPort(Integer.parseInt(hostPort[1]));
            ep.setPath(path);
            ep.setServiceName(path);
            Map<String, String> map = DME2URIUtils.splitServiceURIString(path);
            ep.setSimpleName(map.get("service"));
            ep.setServiceVersion(map.get("version"));
            ep.setEnvContext(map.get("envContext"));
            ep.setEndpointProperties(new Properties());
            for (String pairStr : valuePairs) {
                String[] pair = null;
                if (pairStr.contains("routeOffer")) {
                    pair = pairStr.split("=");
                    ep.setRouteOffer(pair[1]);
                }
                if (pairStr.contains("contextPath")) {
                    pair = pairStr.split("=", 2);
                    ep.setContextPath(pair[1]);
                    ep.setPath(pair[1]);
                } else {
                    pair = pairStr.split("=");
                }
                if (pair[0].equals("latitude")) {
                    if (pair[1] == null) {
                        logger.error((URI)null, "propsToEps", LogMessage.DEBUG_MESSAGE, (Object)"Invalid endpoint found for URI: {}. Detailed message: Latitude is null", (Object)path);
                        break;
                    }
                    try {
                        ep.setLatitude(Double.parseDouble(pair[1]));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        logger.error(null, "propsToEps", LogMessage.DEBUG_MESSAGE, "Invalid endpoint found for URI: {}. Detailed message: NumberFormatException - {}", path, e.getMessage());
                        break;
                    }
                }
                if (pair[0].equals("longitude")) {
                    if (pair[1] == null) {
                        logger.error((URI)null, "propsToEps", LogMessage.DEBUG_MESSAGE, (Object)"Invalid endpoint found for URI: {}. Detailed message: Longitude is null", (Object)path);
                        break;
                    }
                    try {
                        ep.setLongitude(Double.parseDouble(pair[1]));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        logger.error(null, "propsToEps", LogMessage.DEBUG_MESSAGE, "Invalid endpoint found for URI: {}. Detailed message: NumberFormatException - {}", path, e.getMessage());
                        break;
                    }
                }
                if (pair[0].equals("lease")) {
                    long t = Long.parseLong(pair[1]);
                    ep.setLease(t);
                    continue;
                }
                if (pair[0].equals("protocol")) {
                    ep.setProtocol(pair[1]);
                    continue;
                }
                if (pair[0].equals("DME2JDBCDatabaseName")) {
                    ((DME2JDBCEndpoint)ep).setDatabaseName(pair[1]);
                    continue;
                }
                if (pair[0].equals("DME2JDBCHealthCheckUser")) {
                    ((DME2JDBCEndpoint)ep).setHealthCheckUser(pair[1]);
                    continue;
                }
                if (pair[0].equals("DME2JDBCHealthCheckPassword")) {
                    ((DME2JDBCEndpoint)ep).setHealthCheckPassword(pair[1]);
                    continue;
                }
                if (pair[0].equals("DME2JDBCHealthCheckDriver")) {
                    ((DME2JDBCEndpoint)ep).setHealthCheckDriver(pair[1]);
                    continue;
                }
                ep.getEndpointProperties().setProperty(pair[0], pair[1]);
            }
            if (System.currentTimeMillis() - ep.getLease() >= this.defaultCacheStaleness) continue;
            list.add(ep);
        }
        return list;
    }
}

