/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.manager.registry;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.cache.DME2CacheStats;
import com.att.aft.dme2.cache.DME2CacheStatsHolder;
import com.att.aft.dme2.cache.domain.CacheElement;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.manager.registry.DME2AbstractRegistryCache;
import com.att.aft.dme2.manager.registry.DME2EndpointRegistryGRM;
import com.att.aft.dme2.manager.registry.DME2EndpointRegistryType;
import com.att.aft.dme2.manager.registry.DME2RouteInfo;
import com.att.aft.dme2.request.DmeUniformResource;
import com.att.aft.dme2.util.DME2URIUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DME2RouteInfoCacheGRM
extends DME2AbstractRegistryCache<String, DME2RouteInfo> {
    private static final Logger logger = LoggerFactory.getLogger(DME2RouteInfoCacheGRM.class);
    private transient DME2EndpointRegistryGRM registry;
    private boolean enableCacheStats = true;
    private final Map<String, DME2CacheStatsHolder> cacheStats = Collections.synchronizedMap(new HashMap());
    private boolean isRefreshInProgress;

    public DME2RouteInfoCacheGRM(DME2Configuration config, DME2EndpointRegistryGRM registry, String managerName) throws DME2Exception {
        super(config, DME2RouteInfo.class, DME2EndpointRegistryType.GRM, registry, managerName, false);
        this.registry = registry;
    }

    @Override
    public CacheElement fetchFromSource(CacheElement.Key<String> requestValue) throws DME2Exception {
        String service = requestValue.getKey();
        Map<String, String> serviceMap = DME2URIUtils.splitServiceURIString(service);
        return this.createCacheElement(this.createCacheKey(service), this.createCacheValue(this.registry.fetchRouteInfo(serviceMap.get("service"), serviceMap.get("version"), serviceMap.get("envContext"))));
    }

    public void shutdownTimerTask() {
        logger.debug(null, "shutdownTimerTask", LogMessage.METHOD_ENTER);
        this.cache.shutdownTimerTask();
        logger.debug(null, "shutdownTimerTask", LogMessage.METHOD_EXIT);
    }

    @Override
    public void refresh() {
        try {
            this.isRefreshInProgress = true;
            this.refreshAllCachedRouteInfo();
            this.isRefreshInProgress = false;
        }
        catch (Exception e) {
            logger.warn((URI)null, "refresh", LogMessage.REFRESH_SVC_FAILED, (Object)e);
        }
    }

    private void refreshAllCachedRouteInfo() throws Exception {
        String cacheStatsURI = null;
        long startTime = 0L;
        if (this.cache.getCurrentSize() > 0) {
            ArrayList serviceURIs = new ArrayList();
            for (CacheElement.Key key : this.cache.getKeySet()) {
                serviceURIs.add(key.getKey());
            }
            for (String uriStr : serviceURIs) {
                if (uriStr == null || !this.isRouteInfoExpired(uriStr)) continue;
                DmeUniformResource uniformResource = new DmeUniformResource(this.config, new URI("http://DME2LOCAL/" + uriStr));
                String service = uniformResource.getService();
                String version = uniformResource.getVersion();
                String env = uniformResource.getEnvContext();
                cacheStatsURI = "/service=" + service + "/version=" + version + "/envContext=" + env;
                DME2CacheStatsHolder statsHolder = null;
                statsHolder = this.cacheStats.get(cacheStatsURI);
                if (statsHolder == null) {
                    statsHolder = new DME2CacheStatsHolder(cacheStatsURI, this.config);
                    this.cacheStats.put(cacheStatsURI, statsHolder);
                }
                startTime = System.currentTimeMillis();
                DME2RouteInfo routeInfo = null;
                try {
                    routeInfo = this.registry.fetchRouteInfo(service, version, env);
                    statsHolder.recordRefreshSuccess(System.currentTimeMillis() - startTime, this.isCacheStatsEnabled());
                }
                catch (DME2Exception dmeEx) {
                    statsHolder.recordRefreshFailure(System.currentTimeMillis() - startTime, this.isCacheStatsEnabled());
                    throw dmeEx;
                }
                if (routeInfo != null) {
                    this.cache.put(this.createCacheKey(uriStr), this.createCacheValue(routeInfo));
                    logger.debug((URI)null, "refreshAllCachedRouteInfo", LogMessage.REFRESH_SERVICE, (Object)uriStr);
                    continue;
                }
                logger.debug((URI)null, "refreshAllCachedRouteInfo", LogMessage.REFRESH_SVC_FAILED, (Object)uriStr);
            }
        }
    }

    private boolean isRouteInfoExpired(String serviceURI) {
        Long expirationTime = null;
        String uriString = null;
        uriString = serviceURI.startsWith("/") ? serviceURI : "/" + serviceURI;
        DME2RouteInfo routeInfo = (DME2RouteInfo)this.cache.get(this.createCacheKey(uriString)).getValue();
        return routeInfo != null && (expirationTime = routeInfo.getExpirationTime()) <= System.currentTimeMillis();
    }

    @Override
    public DME2CacheStats getStats(String serviceName, Integer hourOfDay) {
        if (serviceName != null && this.cacheStats.get(serviceName) != null) {
            DME2CacheStatsHolder stats = this.cacheStats.get(serviceName);
            if (hourOfDay >= 0 && hourOfDay <= 23) {
                return stats.getHourlyStats(hourOfDay);
            }
            return this.cacheStats.get(serviceName).getStats();
        }
        return null;
    }

    @Override
    public void disableCacheStats() {
        this.enableCacheStats = false;
    }

    @Override
    public void enableCacheStats() {
        this.enableCacheStats = true;
    }

    @Override
    public boolean isCacheStatsEnabled() {
        return this.enableCacheStats;
    }
}

