/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.manager.registry.util;

public class DME2DistanceUtil {
    private static final double DEGREES_TO_RADIANS = Math.PI / 180;
    public static final double EARTH_RADIUS_IN_KILOMETERS = 6373.0;

    private DME2DistanceUtil() {
    }

    public static double calculateDistanceBetween(double sourceLatitude, double sourceLongitude, double destinationLatitude, double destinationLongitude) {
        double sourceLatitudeRadians = sourceLatitude * (Math.PI / 180);
        double sourceLongitudeRadians = sourceLongitude * (Math.PI / 180);
        double destinationLatitudeRadians = destinationLatitude * (Math.PI / 180);
        double destinationLongitudeRadians = destinationLongitude * (Math.PI / 180);
        double deltaLatitude = destinationLatitudeRadians - sourceLatitudeRadians;
        double deltaLongitude = destinationLongitudeRadians - sourceLongitudeRadians;
        double a = Math.pow(Math.sin(deltaLatitude / 2.0), 2.0) + Math.cos(sourceLatitudeRadians) * Math.cos(destinationLatitudeRadians) * Math.pow(Math.sin(deltaLongitude / 2.0), 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return c * 6373.0;
    }
}

