/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.mbean;

import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.ErrorContext;
import java.lang.management.ManagementFactory;
import java.net.URI;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;

public class JMXUtil {
    private static final Logger logger = LoggerFactory.getLogger(JMXUtil.class.getCanonicalName());
    public static JMXUtil iNSTANCE = new JMXUtil();
    private final MBeanServer jmxPlatform = ManagementFactory.getPlatformMBeanServer();

    public <T> void registerMXAsStandardMBean(String name, T mxBean, Class<T> mxInterface) {
        logger.debug((String)null, (URI)null, "registerMXAsStandardMBean", LogMessage.JMX_REGISTER, (Object)name, (Object)mxBean);
        try {
            ObjectName objectName = new ObjectName(name);
            this.jmxPlatform.registerMBean(new StandardMBean(mxBean, mxInterface, true), objectName);
        }
        catch (Exception e) {
            if (e instanceof InstanceAlreadyExistsException || e.getCause() instanceof InstanceAlreadyExistsException) {
                logger.debug((URI)null, "registerMXAsStandardMBean", "Already Registered {}", (Object)new ErrorContext().add("DME2MBean", name));
                return;
            }
            logger.error((URI)null, "registerMXAsStandardMBean", "AFT-DME2-1900 {}", (Object)new ErrorContext().add("DME2MBean", name), (Object)e);
        }
    }

    public <T> void registerMXBean(String name, T mxBean) {
        try {
            ObjectName objectName = new ObjectName(name);
            this.jmxPlatform.registerMBean(mxBean, objectName);
        }
        catch (Exception e) {
            if (e instanceof InstanceAlreadyExistsException || e.getCause() instanceof InstanceAlreadyExistsException) {
                return;
            }
            logger.error((URI)null, "registerMXBean", "AFT-DME2-1900 {}", (Object)new ErrorContext().add("DME2MBean", name), (Object)e);
        }
    }
}

