/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.registry.accessor;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.api.util.SecurityContext;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.registry.accessor.BaseAccessor;
import com.att.aft.dme2.registry.accessor.GRMEndPointsDiscoveryDNS;
import com.att.aft.dme2.util.ErrorContext;
import com.att.aft.dme2.util.grm.IGRMEndPointDiscovery;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class GRMAccessorFactory {
    private static String grmAccessorHandlerClassName = null;
    private static Map<DME2Configuration, BaseAccessor> grmAccessorHandlerMap = new ConcurrentHashMap<DME2Configuration, BaseAccessor>();
    private static final Logger logger = LoggerFactory.getLogger(GRMAccessorFactory.class.getName());
    private static volatile GRMAccessorFactory instance;
    private static String grmEnvironmentDNS;
    private static IGRMEndPointDiscovery endPointDiscovery;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GRMAccessorFactory getInstance() {
        GRMAccessorFactory result = instance;
        if (result != null) return result;
        Class<GRMAccessorFactory> clazz = GRMAccessorFactory.class;
        synchronized (GRMAccessorFactory.class) {
            result = instance;
            if (result != null) return result;
            instance = result = new GRMAccessorFactory();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    public static void close() {
        endPointDiscovery.close();
        GRMAccessorFactory.getInstance().resetGrmAccessorHandler();
        instance = null;
    }

    private static BaseAccessor createGRMAccessorHandler(DME2Configuration configuration, SecurityContext securityContext) throws DME2Exception {
        Object grmServiceNameInGRM;
        logger.debug(null, "createGRMAccessorHandler", LogMessage.METHOD_ENTER);
        if (!configuration.getProperty("GRM_EDGE_DIRECT_HOST").isEmpty()) {
            logger.debug(null, "createGRMAccessorHandler", "Bootstrapping to Direct URL for GRM-Edge with Host: " + configuration.getProperty("GRM_EDGE_DIRECT_HOST"));
            endPointDiscovery = GRMEndPointsDiscoveryDNS.getInstance(configuration.getProperty("GRM_EDGE_DIRECT_HOST"), securityContext, configuration, false, false);
        } else if (!configuration.getProperty("GRM_EDGE_CUSTOM_DNS").isEmpty()) {
            logger.debug(null, "createGRMAccessorHandler", "Bootstrapping to Direct URL for GRM-Edge with DNS: " + configuration.getProperty("GRM_EDGE_CUSTOM_DNS"));
            endPointDiscovery = GRMEndPointsDiscoveryDNS.getInstance(configuration.getProperty("GRM_EDGE_CUSTOM_DNS"), securityContext, configuration, true, false);
        } else if (!configuration.getProperty("AFT_DME2_GRM_URLS").isEmpty()) {
            logger.debug(null, "createGRMAccessorHandler", "Bootstrapping to Direct URL AFT_DME2_GRM_URLS: " + configuration.getProperty("AFT_DME2_GRM_URLS"));
            endPointDiscovery = GRMEndPointsDiscoveryDNS.getInstance(configuration.getProperty("AFT_DME2_GRM_URLS"), securityContext, configuration, false, true);
        } else {
            String grmEnvironment;
            logger.debug(null, "createGRMAccessorHandler", "Using DNS Bootstrapping.");
            String grmDNSName = configuration.getProperty("DME2_GRM_DNS_BOOTSTRAP");
            if ((grmDNSName == null || grmDNSName.isEmpty()) && ((grmDNSName = GRMAccessorFactory.retrieveGRMDNSName(configuration)) == null || grmDNSName.isEmpty())) {
                logger.error((URI)null, "createGRMAccessorHandler", "{} parameter is mandatory please set a proper value", (Object)"DME2_GRM_DNS_BOOTSTRAP");
                throw new DME2Exception("AFT-DME2-9601", new ErrorContext().add("Missing configuration property name", "DME2_GRM_DNS_BOOTSTRAP"));
            }
            grmServiceNameInGRM = GRMAccessorFactory.reverseByDots(grmDNSName) + "." + configuration.getProperty("DME2_GRM_SERVICE_NAME", "GRMLWPRestService");
            String grmEnvironmentParameter = configuration.getProperty("GRM_ENVIRONMENT");
            String string = grmEnvironment = grmEnvironmentParameter != null ? grmEnvironmentParameter : grmEnvironmentDNS;
            if (grmEnvironment == null) {
                logger.error((URI)null, "createGRMAccessorHandler", "{} parameter is mandatory please set a proper value", (Object)"GRM_ENVIRONMENT");
                throw new DME2Exception("AFT-DME2-9601", new ErrorContext().add("Missing configuration property name", "GRM_ENVIRONMENT"));
            }
            endPointDiscovery = GRMEndPointsDiscoveryDNS.getInstance(grmDNSName, (String)grmServiceNameInGRM, grmEnvironment, securityContext, configuration, null);
        }
        try {
            Object grmAccessorHandlerObject = Class.forName(grmAccessorHandlerClassName).getDeclaredConstructor(DME2Configuration.class, SecurityContext.class, IGRMEndPointDiscovery.class).newInstance(configuration, securityContext, endPointDiscovery);
            if (grmAccessorHandlerObject instanceof BaseAccessor) {
                if (endPointDiscovery instanceof GRMEndPointsDiscoveryDNS) {
                    ((GRMEndPointsDiscoveryDNS)endPointDiscovery).getGrmEndPointsDiscoveryHelperGRM().setGrmServiceAccessor((BaseAccessor)grmAccessorHandlerObject);
                    if (configuration.getProperty("GRM_STATIC_ENDPOINT", "false").equalsIgnoreCase("false") || configuration.getProperty("GRM_EDGE_DIRECT_HOST").isEmpty() || configuration.getProperty("GRM_EDGE_CUSTOM_DNS").isEmpty() || configuration.getProperty("AFT_DME2_GRM_URLS").isEmpty()) {
                        ((GRMEndPointsDiscoveryDNS)endPointDiscovery).refreshGRMServerListFromGRMSeeds();
                    }
                }
                grmServiceNameInGRM = (BaseAccessor)grmAccessorHandlerObject;
                return grmServiceNameInGRM;
            }
            try {
                ErrorContext ec = new ErrorContext();
                ec.add("HandlerObject must implement interface - " + BaseAccessor.class.getName(), "HandlerObject must implement interface - " + BaseAccessor.class.getName());
                logger.error(null, "createGRMAccessorHandler", "{} {} {}", "HandlerObject must implement interface - ", BaseAccessor.class.getName(), "AFT-DME2-9000", ec);
                throw new DME2Exception("AFT-DME2-9000", ec);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                logger.error(null, "createGRMAccessorHandler", "{} {} {}", BaseAccessor.class.getName(), " implementation Class can't be instantiated", "AFT-DME2-9000", e);
                throw new DME2Exception(BaseAccessor.class.getName() + " implementation Class can't be instantiated", e);
            }
        }
        finally {
            logger.debug(null, "createGRMAccessorHandler", LogMessage.METHOD_EXIT);
        }
    }

    private static String reverseByDots(String name) {
        String[] parts = name.split("\\.");
        grmEnvironmentDNS = GRMAccessorFactory.buildEnvFromDNSPlatform(parts[0]);
        StringBuilder b = new StringBuilder(name.length());
        for (int i = parts.length - 1; i >= 0; --i) {
            if (b.length() > 0) {
                b.append(".");
            }
            b.append(parts[i]);
        }
        return b.toString();
    }

    protected static String buildEnvFromDNSPlatform(String name) {
        try {
            String[] parts = name.split("-");
            return parts[parts.length - 1].toUpperCase();
        }
        catch (Exception ex) {
            logger.info((URI)null, "buildEnvFromDNSPlatform", "first part of domain has no - to separate environment", (Object)ex);
            return null;
        }
    }

    public static BaseAccessor getGrmAccessorHandlerInstance(DME2Configuration configuration, SecurityContext securityContext) throws DME2Exception {
        if (!grmAccessorHandlerMap.containsKey(configuration) && null != (grmAccessorHandlerClassName = configuration.getProperty("GRMACESSOR_HANDLER_IMPL"))) {
            grmAccessorHandlerMap.put(configuration, GRMAccessorFactory.createGRMAccessorHandler(configuration, securityContext));
        }
        return grmAccessorHandlerMap.get(configuration);
    }

    public void resetGrmAccessorHandler() {
        grmAccessorHandlerMap.clear();
    }

    private static String retrieveGRMDNSName(DME2Configuration configuration) {
        String platStr = configuration.getProperty("platform");
        String aftEnv = configuration.getProperty("AFT_ENVIRONMENT");
        if (platStr != null && platStr.isEmpty()) {
            platStr = null;
        }
        if (aftEnv != null && aftEnv.isEmpty()) {
            aftEnv = null;
        }
        if (aftEnv != null && platStr == null) {
            if (aftEnv.equalsIgnoreCase("AFTUAT")) {
                return configuration.getProperty("DME2_GRM_NONPROD_DNS_NAME");
            }
            if (aftEnv.equalsIgnoreCase("AFTPRD")) {
                return configuration.getProperty("DME2_GRM_PROD_DNS_NAME");
            }
            return null;
        }
        if (aftEnv == null && platStr == null) {
            return null;
        }
        if (platStr != null) {
            if (platStr.equalsIgnoreCase("SANDBOX-DEV")) {
                return configuration.getProperty("DME2_GRM_INFRATEST_DNS_NAME");
            }
            if (platStr.equalsIgnoreCase("SANDBOX-LAB")) {
                return configuration.getProperty("DME2_GRM_INFRALAB_DNS_NAME");
            }
            if (platStr.equalsIgnoreCase("NON-PROD")) {
                return configuration.getProperty("DME2_GRM_NONPROD_DNS_NAME");
            }
            if (platStr.equalsIgnoreCase("PROD")) {
                return configuration.getProperty("DME2_GRM_PROD_DNS_NAME");
            }
            return null;
        }
        return null;
    }
}

