/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.registry.accessor;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.grm.IGRMEndPointDiscovery;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GRMEndPointsCache
implements IGRMEndPointDiscovery {
    protected String cacheFileName;
    protected int cacheRefreshIntervalInMS;
    protected int cacheRefreshStartDelayInMS;
    protected List<String> grmServerList = new ArrayList<String>();
    protected Map<String, Boolean> cachedServers = new HashMap<String, Boolean>();
    private static volatile GRMEndPointsCache instance;
    private static final Logger logger;
    private DME2Configuration config;

    private GRMEndPointsCache(DME2Configuration configuration) throws DME2Exception {
        this.config = configuration;
        this.cacheFileName = this.getCacheFileName();
        this.cacheRefreshIntervalInMS = Integer.parseInt(this.config.getProperty("GRM_ENDPOINT_CACHE_REFRESH_INTERVAL_MS"));
        this.cacheRefreshStartDelayInMS = Integer.parseInt(this.config.getProperty("GRM_ENDPOINT_CACHE__REFRESH_START_DELAY_MS"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GRMEndPointsCache getInstance(DME2Configuration configuration) throws DME2Exception {
        GRMEndPointsCache result = instance;
        if (result != null) return result;
        Class<GRMEndPointsCache> clazz = GRMEndPointsCache.class;
        synchronized (GRMEndPointsCache.class) {
            result = instance;
            if (result != null) return result;
            instance = result = new GRMEndPointsCache(configuration);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    protected void addEndpointURL(String address) {
        if (!this.cachedServers.containsKey(address)) {
            this.grmServerList.add(address);
            this.cachedServers.put(address, true);
        }
    }

    public void clear() {
        this.grmServerList = new ArrayList<String>();
        this.cachedServers = new HashMap<String, Boolean>();
    }

    public void addAllAddressList(List<String> newAddressList) {
        if (this.grmServerList == null) {
            return;
        }
        for (String address : newAddressList) {
            this.addEndpointURL(address);
        }
    }

    public void loadFromFile() throws IOException {
        try (BufferedReader bufferedReader = null;){
            String address;
            bufferedReader = new BufferedReader(new FileReader(this.cacheFileName));
            while ((address = bufferedReader.readLine()) != null) {
                logger.debug((URI)null, "loadFromFile", "adding follwing GRM seed from cache persistence storage: {}", (Object)address);
                this.addEndpointURL(address);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile() throws IOException {
        BufferedWriter bufferedWriter = null;
        File file = new File(this.cacheFileName);
        logger.debug((URI)null, "writeToFile", "Got cache file {}", (Object)this.cacheFileName);
        if (file.getParentFile() != null && !file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(this.cacheFileName, false));
            for (String url : this.grmServerList) {
                bufferedWriter.write(url);
                bufferedWriter.newLine();
            }
        }
        finally {
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshServerList(List<String> newServerList) throws IOException {
        List<String> list = this.grmServerList;
        synchronized (list) {
            this.grmServerList = newServerList;
        }
        this.writeToFile();
    }

    @Override
    public List<String> getGRMEndpoints() {
        return new ArrayList<String>(this.grmServerList);
    }

    public String getCacheFileName() {
        logger.debug((URI)null, "getCacheFileName", "Config Value: {}", (Object)this.config.getProperty("GRM_SERVER_CACHE_FILE"));
        this.cacheFileName = this.config.getProperty("GRM_SERVER_CACHE_FILE", "etc/dme2grmendpoints.txt");
        return this.cacheFileName;
    }

    @Override
    public void close() {
        instance = null;
    }

    static {
        logger = LoggerFactory.getLogger(GRMEndPointsCache.class);
    }
}

