/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.registry.accessor;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.api.DME2Manager;
import com.att.aft.dme2.api.util.SecurityContext;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.iterator.util.DME2CollectionUtils;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.manager.registry.DME2Endpoint;
import com.att.aft.dme2.registry.accessor.BaseAccessor;
import com.att.aft.dme2.registry.accessor.GRMEndPointsCache;
import com.att.aft.dme2.registry.accessor.GRMEndPointsDiscoveryHelperDNS;
import com.att.aft.dme2.registry.accessor.GRMEndPointsDiscoveryHelperGRM;
import com.att.aft.dme2.request.DmeUniformResource;
import com.att.aft.dme2.util.ErrorContext;
import com.att.aft.dme2.util.OfferCache;
import com.att.aft.dme2.util.grm.IGRMEndPointDiscovery;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.Timer;
import java.util.TimerTask;

public class GRMEndPointsDiscoveryDNS
implements IGRMEndPointDiscovery {
    private static final Logger logger = LoggerFactory.getLogger(GRMEndPointsDiscoveryDNS.class);
    private DME2Configuration config;
    private static volatile GRMEndPointsDiscoveryDNS instance;
    private final OfferCache offerCache;
    private GRMEndPointsDiscoveryHelperGRM grmEndPointsDiscoveryHelperGRM;
    private GRMEndPointsCache grmEndPointsCache;
    private DME2Manager manager;
    private Timer timerCacheRefresh;
    private TimerTask timerTask;
    private final String protocolAddress;
    private String grmSeedProtocol;
    private String grmSeedPort;
    private String grmSeedPath;
    private String grmServiceVersion;
    private String staticGRMEndpoint;
    private String grmEdgeNodePort;
    private String grmEdgeContextPath;

    private GRMEndPointsDiscoveryDNS(String dnsName, String servicename, String environment, SecurityContext ctx, DME2Configuration configuration, BaseAccessor grmServiceAccessor) throws DME2Exception {
        this.config = configuration;
        this.grmSeedProtocol = this.config.getProperty("DME2_GRM_SERVER_PROTOCOL");
        this.grmSeedPort = this.config.getProperty("DME2_GRM_SERVER_PORT");
        this.grmSeedPath = this.config.getProperty("DME2_GRM_SERVER_PATH");
        this.grmServiceVersion = this.config.getProperty("DME2_GRM_SERVICE_VERSION");
        this.staticGRMEndpoint = this.config.getProperty("GRM_STATIC_ENDPOINT", "false");
        this.offerCache = OfferCache.getInstance();
        this.manager = null;
        this.protocolAddress = this.grmSeedProtocol + ":";
        GRMEndPointsDiscoveryHelperDNS grmEndPointsDiscoveryHelperDNS = new GRMEndPointsDiscoveryHelperDNS(dnsName, this.grmSeedProtocol, this.grmSeedPort, this.grmSeedPath);
        List<String> seedServersFromDNS = grmEndPointsDiscoveryHelperDNS.getGRMEndpoints();
        this.grmEndPointsCache = GRMEndPointsCache.getInstance(this.config);
        List<String> seedServersFromDNSRandomized = DME2CollectionUtils.randomizeURLs(seedServersFromDNS);
        this.grmEndPointsCache.addAllAddressList(seedServersFromDNSRandomized);
        if (this.staticGRMEndpoint.equalsIgnoreCase("false")) {
            this.timerCacheRefresh = new Timer();
            this.timerTask = new CacheTimerTask();
            try {
                this.grmEndPointsCache.loadFromFile();
            }
            catch (IOException e) {
                logger.debug((URI)null, "ctor(String,String,String,SecurityContext)", "Can't read cached GRM servers Endpoints", (Object)e);
            }
            if (this.grmEndPointsCache.getGRMEndpoints().isEmpty()) {
                logger.error(null, "ctor(String,String,String,SecurityContext)", "Both cached file and DNS returned no server for setting up GRM seeds");
                throw new DME2Exception("AFT-DME2-9731", new ErrorContext());
            }
        }
        if ("https".equalsIgnoreCase(this.grmSeedProtocol)) {
            ctx.setSSL(true);
        }
        this.grmEndPointsDiscoveryHelperGRM = new GRMEndPointsDiscoveryHelperGRM(environment, this.grmSeedProtocol, servicename, this.grmServiceVersion, grmServiceAccessor, this.config);
        if (this.staticGRMEndpoint.equalsIgnoreCase("false")) {
            this.scheduleCacheRefresh();
        }
    }

    private GRMEndPointsDiscoveryDNS(String hostname, SecurityContext ctx, DME2Configuration configuration, Boolean dns, Boolean directURL) throws DME2Exception {
        this.config = configuration;
        this.grmSeedProtocol = this.config.getProperty("DME2_GRM_SERVER_PROTOCOL");
        this.grmSeedPort = this.config.getProperty("DME2_GRM_SERVER_PORT");
        this.grmSeedPath = this.config.getProperty("DME2_GRM_SERVER_PATH");
        this.grmServiceVersion = this.config.getProperty("DME2_GRM_SERVICE_VERSION");
        this.staticGRMEndpoint = this.config.getProperty("GRM_STATIC_ENDPOINT", "false");
        this.offerCache = OfferCache.getInstance();
        this.manager = null;
        this.protocolAddress = this.grmSeedProtocol + ":";
        this.grmEdgeNodePort = this.config.getProperty("GRM_EDGE_NODE_PORT");
        this.grmEdgeContextPath = this.config.getProperty("GRM_EDGE_CONTEXT_PATH");
        if (dns.booleanValue()) {
            GRMEndPointsDiscoveryHelperDNS grmEndPointsDiscoveryHelperDNS = new GRMEndPointsDiscoveryHelperDNS(hostname, this.grmSeedProtocol, this.grmEdgeNodePort, this.grmEdgeContextPath);
            List<String> seedServersFromDNS = grmEndPointsDiscoveryHelperDNS.getGRMEndpoints();
            this.grmEndPointsCache = GRMEndPointsCache.getInstance(this.config);
            for (String aURL : seedServersFromDNS) {
                this.grmEndPointsCache.addEndpointURL(aURL);
            }
            this.grmEndPointsDiscoveryHelperGRM = new GRMEndPointsDiscoveryHelperGRM(seedServersFromDNS, this.config);
            if ("https".equalsIgnoreCase(this.grmSeedProtocol)) {
                ctx.setSSL(true);
            }
        } else {
            this.grmEndPointsCache = GRMEndPointsCache.getInstance(this.config);
            if (directURL.booleanValue()) {
                String[] directUrls;
                for (String aURL : directUrls = hostname.split(",")) {
                    this.grmEndPointsCache.addEndpointURL(aURL);
                }
                this.grmEndPointsDiscoveryHelperGRM = new GRMEndPointsDiscoveryHelperGRM(directUrls, this.config);
                if ("https".equalsIgnoreCase(this.grmSeedProtocol)) {
                    ctx.setSSL(true);
                }
            } else {
                this.grmEndPointsCache.addEndpointURL(this.createGRMEdgeURL(hostname, this.grmEdgeNodePort, this.grmEdgeContextPath));
                this.grmEndPointsDiscoveryHelperGRM = new GRMEndPointsDiscoveryHelperGRM(this.createGRMEdgeURL(hostname, this.grmEdgeNodePort, this.grmEdgeContextPath), this.config);
                if ("https".equalsIgnoreCase(this.grmSeedProtocol)) {
                    ctx.setSSL(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static GRMEndPointsDiscoveryDNS getInstance(String dnsName, String servicename, String environment, SecurityContext ctx, DME2Configuration config, BaseAccessor grmServiceAccessor) throws DME2Exception {
        GRMEndPointsDiscoveryDNS result = instance;
        if (result != null) return result;
        Class<GRMEndPointsDiscoveryDNS> clazz = GRMEndPointsDiscoveryDNS.class;
        synchronized (GRMEndPointsDiscoveryDNS.class) {
            result = instance;
            if (result != null) return result;
            instance = result = new GRMEndPointsDiscoveryDNS(dnsName, servicename, environment, ctx, config, grmServiceAccessor);
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static GRMEndPointsDiscoveryDNS getInstance(String hostname, SecurityContext ctx, DME2Configuration config, Boolean dns, Boolean directURL) throws DME2Exception {
        GRMEndPointsDiscoveryDNS result = instance;
        if (result != null) return result;
        Class<GRMEndPointsDiscoveryDNS> clazz = GRMEndPointsDiscoveryDNS.class;
        synchronized (GRMEndPointsDiscoveryDNS.class) {
            result = instance;
            if (result != null) return result;
            instance = result = new GRMEndPointsDiscoveryDNS(hostname, ctx, config, dns, directURL);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return result;
        }
    }

    @Override
    public List<String> getGRMEndpoints() throws DME2Exception {
        return this.grmEndPointsCache.getGRMEndpoints();
    }

    public GRMEndPointsCache getGrmEndPointsCache() {
        return this.grmEndPointsCache;
    }

    public void setGrmEndPointsCache(GRMEndPointsCache grmEndPointsCache) {
        this.grmEndPointsCache = grmEndPointsCache;
    }

    @Override
    public void close() {
        this.timerTask.cancel();
        instance = null;
    }

    public void refreshGRMServerListFromGRMSeeds() {
        try {
            logger.debug(null, "refreshGRMServerListFromGRMSeeds", "refreshing GRM server endpoints from GRM.");
            List<String> newServerList = this.grmEndPointsDiscoveryHelperGRM.getGRMEndpoints();
            if (newServerList != null && !newServerList.isEmpty()) {
                newServerList = this.filterByGRMProtocol(newServerList);
                newServerList = this.sortIfPossible(newServerList);
                logger.debug((URI)null, "refreshGRMServerListFromGRMSeeds", "new GRM servers endpoints list = {}", (Object)newServerList);
                this.grmEndPointsCache.refreshServerList(newServerList);
            }
        }
        catch (IOException e) {
            logger.warn((URI)null, "refreshGRMServerListFromGRMSeeds", "can't write GRM Cache content to the file please check value set for parameter {}", (Object)"GRM_SERVER_CACHE_FILE", (Object)e);
        }
    }

    protected List<String> sortIfPossible(List<String> grmServerList) {
        if (this.manager == null) {
            return grmServerList;
        }
        try {
            return this.sort(grmServerList);
        }
        catch (Exception ex) {
            logger.error((URI)null, "sortIfPossible", "Can't get GRM server end points to sort them based on location", (Object)ex);
            return grmServerList;
        }
    }

    protected List<String> sort(List<String> grmServerList) throws Exception {
        DME2Endpoint[] endpoints = this.convertURLsToEndPoints(grmServerList).toArray(new DME2Endpoint[grmServerList.size()]);
        SortedMap<Double, DME2Endpoint[]> endpointsGroupedByDistance = DME2CollectionUtils.organizeEndpoints(endpoints);
        LinkedList<String> activeGRMServerList = new LinkedList<String>();
        LinkedList<String> staleGRMServerList = new LinkedList<String>();
        for (DME2Endpoint[] endpointsDistance : endpointsGroupedByDistance.values()) {
            for (DME2Endpoint endpoint : endpointsDistance) {
                String endPointURL = endpoint.getDmeUniformResource().toString();
                if (this.offerCache.isStale(endPointURL)) {
                    staleGRMServerList.add(endPointURL);
                    continue;
                }
                activeGRMServerList.add(endPointURL);
            }
        }
        ArrayList<String> retArrayList = new ArrayList<String>(activeGRMServerList.size() + staleGRMServerList.size());
        retArrayList.addAll(activeGRMServerList);
        staleGRMServerList.addAll(activeGRMServerList);
        return retArrayList;
    }

    protected void scheduleCacheRefresh() {
        logger.debug((URI)null, "scheduleCacheRefresh", "cacheRefreshStartDelayInMS: {}", (Object)this.grmEndPointsCache.cacheRefreshStartDelayInMS);
        logger.debug((URI)null, "scheduleCacheRefresh", "cacheRefreshIntervalInMS: {}", (Object)this.grmEndPointsCache.cacheRefreshIntervalInMS);
        this.timerCacheRefresh.schedule(this.timerTask, this.grmEndPointsCache.cacheRefreshStartDelayInMS, (long)this.grmEndPointsCache.cacheRefreshIntervalInMS);
    }

    protected List<DME2Endpoint> convertURLsToEndPoints(List<String> grmServerList) throws DME2Exception, MalformedURLException {
        LinkedList<DME2Endpoint> allGRMServerEndpoints = new LinkedList<DME2Endpoint>();
        for (String address : grmServerList) {
            DmeUniformResource uniformResource = new DmeUniformResource(this.config, address);
            DME2Endpoint[] endpoints = this.manager.getEndpoints(uniformResource);
            allGRMServerEndpoints.addAll(Arrays.asList(endpoints));
        }
        return allGRMServerEndpoints;
    }

    private final List<String> filterByGRMProtocol(List<String> grmServerList) {
        ArrayList<String> grmServersThisProtocol = new ArrayList<String>(grmServerList.size());
        for (String address : grmServerList) {
            if (!address.startsWith(this.protocolAddress)) continue;
            grmServersThisProtocol.add(address);
            logger.debug((URI)null, "filterByGRMProtocol", "returning filtered address: {}", (Object)address);
        }
        logger.debug((URI)null, "filterByGRMProtocol", "returning from filter for protocol {}", (Object)this.protocolAddress);
        return grmServersThisProtocol;
    }

    private String createGRMEdgeURL(String hostname, String port, String context) {
        StringBuilder buff = new StringBuilder();
        buff.append("https://");
        buff.append(hostname);
        buff.append(":");
        buff.append(port);
        buff.append(context);
        return buff.toString();
    }

    public GRMEndPointsDiscoveryHelperGRM getGrmEndPointsDiscoveryHelperGRM() {
        return this.grmEndPointsDiscoveryHelperGRM;
    }

    public class CacheTimerTask
    extends TimerTask {
        @Override
        public void run() {
            if (GRMEndPointsDiscoveryDNS.this.manager == null) {
                try {
                    GRMEndPointsDiscoveryDNS.this.manager = DME2Manager.getDefaultInstance();
                }
                catch (DME2Exception e) {
                    logger.warn((URI)null, "CacheTimerTask.run", "Can't create DME2Manager to use for sorting GRMServer Endpoints", (Object)e);
                }
            }
            GRMEndPointsDiscoveryDNS.this.refreshGRMServerListFromGRMSeeds();
        }
    }
}

