/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.registry.bootstrap;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.registry.bootstrap.RegistryBootstrap;
import com.att.aft.dme2.util.ErrorContext;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;

public class RegistryBootstrapFactory {
    private static String registryBootstrapHandlerClassName = null;
    private static RegistryBootstrap registryBootstrapAccessorHandler = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(RegistryBootstrapFactory.class.getName());
    private static RegistryBootstrapFactory registryBootstrapFactory = new RegistryBootstrapFactory();

    public static RegistryBootstrapFactory getInstance() {
        return registryBootstrapFactory;
    }

    private static RegistryBootstrap createRegistryBootstrapHandler(DME2Configuration configuration, String ... urls) throws DME2Exception {
        try {
            Object registryBootstrapHandlerObject = Class.forName(registryBootstrapHandlerClassName).getDeclaredConstructor(DME2Configuration.class).newInstance(configuration);
            if (null != registryBootstrapHandlerObject && registryBootstrapHandlerObject instanceof RegistryBootstrap) {
                return (RegistryBootstrap)registryBootstrapHandlerObject;
            }
            ErrorContext ec = new ErrorContext();
            ec.add("HandlerObject must implement interface - " + RegistryBootstrap.class.getName(), "HandlerObject must implement interface - " + RegistryBootstrap.class.getName());
            LOGGER.error((URI)null, "HandlerObject must implement interface - " + RegistryBootstrap.class.getName(), "AFT-DME2-9000", (Object)ec);
            throw new DME2Exception("AFT-DME2-9000", ec);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOGGER.error(null, "createRegistryBootstrapHandler", "{} {} {}", RegistryBootstrap.class.getName(), " implementation Class can't be instantiated", "AFT-DME2-9000", e);
            throw new DME2Exception(RegistryBootstrap.class.getName() + " implementation Class can't be instantiated", e);
        }
    }

    public static RegistryBootstrap getRegistryBootstrapHandler(DME2Configuration configuration) throws DME2Exception {
        if (null == registryBootstrapAccessorHandler && null != (registryBootstrapHandlerClassName = configuration.getProperty("REGISTRYBOOTSTRAP_HANDLER_IMPL")) && null == registryBootstrapAccessorHandler) {
            registryBootstrapAccessorHandler = RegistryBootstrapFactory.createRegistryBootstrapHandler(configuration, new String[0]);
        }
        return registryBootstrapAccessorHandler;
    }
}

