/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.server.jetty;

import com.att.aft.dme2.internal.jetty.io.ByteBufferPool;
import com.att.aft.dme2.internal.jetty.io.EndPoint;
import com.att.aft.dme2.internal.jetty.io.ManagedSelector;
import com.att.aft.dme2.internal.jetty.io.SelectorManager;
import com.att.aft.dme2.internal.jetty.io.ssl.SslConnection;
import com.att.aft.dme2.internal.jetty.proxy.ConnectHandler;
import com.att.aft.dme2.internal.jetty.server.ConnectionFactory;
import com.att.aft.dme2.internal.jetty.server.Server;
import com.att.aft.dme2.internal.jetty.server.ServerConnector;
import com.att.aft.dme2.internal.jetty.util.ssl.SslContextFactory;
import com.att.aft.dme2.server.jetty.DME2SelectChannelConnector;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLEngine;

public class DME2SslSelectChannelConnector
extends ServerConnector {
    private SslContextFactory sslContextFactory;

    public DME2SslSelectChannelConnector(Server server, SslContextFactory sslContextFactory, ConnectionFactory[] factories) {
        super(server, sslContextFactory, factories);
        this.sslContextFactory = sslContextFactory;
    }

    @Override
    protected DME2SelectChannelConnector.DME2SelectChannelEndPoint newEndPoint(SocketChannel channel, ManagedSelector selectSet, SelectionKey key) throws IOException {
        DME2SelectChannelConnector.DME2SelectChannelEndPoint endp = new DME2SelectChannelConnector.DME2SelectChannelEndPoint(channel, selectSet, key, (int)this.getIdleTimeout());
        ConnectHandler hand = new ConnectHandler();
        SelectorManager selectorManager = hand.getBean(SelectorManager.class);
        endp.setConnection(selectorManager.newConnection(channel, endp, key.attachment()));
        return endp;
    }

    protected SslConnection newSslConnection(SslConnection.DecryptedEndPoint endpoint, SSLEngine engine) {
        return new DME2SslConnection(null, null, endpoint, engine);
    }

    public SslContextFactory getSslContextFactory() {
        return this.sslContextFactory;
    }

    public class DME2SslConnection
    extends SslConnection {
        public DME2SslConnection(ByteBufferPool byteBufferPool, Executor executor, EndPoint endPoint, SSLEngine sslEngine) {
            super(byteBufferPool, executor, endPoint, sslEngine);
        }

        protected SslConnection.DecryptedEndPoint newSslEndPoint() {
            return new DME2SslEndPoint();
        }

        public class DME2SslEndPoint
        extends SslConnection.DecryptedEndPoint {
            public DME2SslEndPoint() {
                super(DME2SslConnection.this);
            }
        }
    }
}

