/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.util;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.ErrorContext;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.rmi.server.UID;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public class GuidGen {
    private static final Logger logger = LoggerFactory.getLogger(GuidGen.class.getCanonicalName());
    private static Random random = new Random(System.currentTimeMillis());
    private static StringBuffer IPAddressHex;
    private static char[] hexTable;
    private static final String DIGEST_ALGO = "MD5";

    private static StringBuffer convertBytesToHexSB(byte[] bytes) {
        StringBuffer sb = new StringBuffer(bytes.length * 2);
        int byteLen = bytes.length;
        for (int index = 0; index < byteLen; ++index) {
            char tempChar = hexTable[(bytes[index] & 0xF0) >>> 4];
            sb.append(tempChar);
            tempChar = hexTable[bytes[index] & 0xF];
            sb.append(tempChar);
        }
        return sb;
    }

    public static String getGUID(String objDesc) {
        StringBuffer sb = new StringBuffer(35);
        sb.append(GuidGen.getTimeMillisHex());
        sb.append(GuidGen.getIPAddressHex());
        sb.append(GuidGen.getSimpleHash(objDesc, null));
        sb.append(GuidGen.getRandomNumber());
        return sb.toString();
    }

    public static String getId() {
        String id = null;
        id = GuidGen.getGUID(GuidGen.getRandomNumber().toString());
        return id;
    }

    private static StringBuffer getIPAddressHex() {
        return IPAddressHex;
    }

    public static StringBuffer getRandomNumber() {
        StringBuffer sb = null;
        byte[] bytes = new byte[4];
        random.nextBytes(bytes);
        sb = GuidGen.convertBytesToHexSB(bytes);
        if (sb == null) {
            new DME2Exception("AFT-DME2-6502", new ErrorContext());
        }
        return sb;
    }

    private static StringBuffer getSimpleHash(String targetStr, byte[] key) {
        StringBuffer sb = new StringBuffer(8);
        byte[] bytes = targetStr.getBytes();
        try {
            MessageDigest md = MessageDigest.getInstance(DIGEST_ALGO);
            md.update(bytes);
            byte[] digest = key == null ? md.digest() : md.digest(key);
            String digestStr = new BigInteger(1, digest).toString(16);
            sb.append(digestStr.substring(0, 8));
        }
        catch (NoSuchAlgorithmException ex) {
            new DME2Exception("AFT-DME2-6500", new ErrorContext().add("exception", ex.getMessage()));
        }
        return sb;
    }

    private static StringBuffer getTimeMillisHex() {
        StringBuffer sb = new StringBuffer(8);
        long time = System.currentTimeMillis();
        String timeHex = Long.toHexString(time);
        int strLength = timeHex.length();
        if (strLength == 8) {
            sb.append(timeHex);
        } else if (strLength > 8) {
            sb.append(timeHex.substring(strLength - 8, strLength));
        } else {
            int remainder = 8 - strLength;
            for (int i = 0; i < remainder; ++i) {
                sb.append('0');
            }
            sb.append(timeHex);
        }
        return sb;
    }

    public static String getUID() {
        String UIDString = null;
        StringBuffer sb = null;
        UID uid = new UID();
        UIDString = uid.toString();
        sb = new StringBuffer(UIDString.length() + 9);
        sb.append(UIDString);
        sb.append(':');
        sb.append(GuidGen.getIPAddressHex());
        return sb.toString();
    }

    static {
        hexTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuffer ipBuffer = new StringBuffer(15);
        try {
            InetAddress localAddr = InetAddress.getLocalHost();
            byte[] IPAddressBytes = localAddr.getAddress();
            int ipAddressLength = IPAddressBytes.length;
            for (int i = 0; i < ipAddressLength; ++i) {
                ipBuffer.append(IPAddressBytes[i]);
                if (i >= ipAddressLength - 1) continue;
                ipBuffer.append('.');
            }
            IPAddressHex = GuidGen.convertBytesToHexSB(IPAddressBytes);
        }
        catch (UnknownHostException ex) {
            logger.error((URI)null, "static GuidGen", "AFT-DME2-6501", (Object)new ErrorContext().add("exception", ex.getMessage()));
        }
    }
}

