/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OfferCache {
    private static Map<String, Long> staleOffers = Collections.synchronizedMap(new HashMap());
    private static long stalenessTime = 0L;
    private static OfferCache instance = new OfferCache();

    private OfferCache() {
        try {
            String stalenessTimeStr = System.getProperty("DME2_OFFER_STALENESS", "5");
            stalenessTime = Long.parseLong(stalenessTimeStr) * 60L * 1000L;
        }
        catch (NumberFormatException ne) {
            stalenessTime = 300000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OfferCache getInstance() {
        if (instance == null) {
            Map<String, Long> map = staleOffers;
            synchronized (map) {
                if (instance == null) {
                    instance = new OfferCache();
                }
            }
        }
        return instance;
    }

    public synchronized void setStale(String offer) {
        if (staleOffers != null && staleOffers.get(offer) == null) {
            staleOffers.put(offer, new Long(System.currentTimeMillis()));
        }
    }

    public synchronized void removeStaleness(String offer) {
        if (staleOffers != null && staleOffers.get(offer) != null) {
            staleOffers.remove(offer);
        }
    }

    public synchronized void removeStaleness(List<String> offers) {
        if (staleOffers != null) {
            for (String offer : offers) {
                if (staleOffers.get(offer) == null) continue;
                staleOffers.remove(offer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStale(String offer) {
        if (staleOffers != null && offer != null) {
            ArrayList<String> offerList = new ArrayList<String>();
            Map<String, Long> map = staleOffers;
            synchronized (map) {
                offerList.addAll(staleOffers.keySet());
            }
            for (String staleOffer : offerList) {
                if (!staleOffer.equalsIgnoreCase(offer)) continue;
                Long time = staleOffers.get(offer);
                if (time == null) {
                    return false;
                }
                long currentTime = System.currentTimeMillis();
                if (currentTime - time < stalenessTime) {
                    return true;
                }
                this.removeStaleness(offer);
                return false;
            }
        }
        return false;
    }
}

