/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.scld.config.strategy;

import com.att.aft.scld.config.dto.Config;
import com.att.aft.scld.config.exception.ConfigException;
import com.att.aft.scld.config.jmx.JMXConfigBeanInf;
import com.att.aft.scld.config.jmx.JxmConfigMBean;
import com.att.aft.scld.config.strategy.AbstractConfigurationStrategy;
import java.lang.management.ManagementFactory;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXConfigurationStrategy
extends AbstractConfigurationStrategy {
    private String managerName;
    private JMXConfigBeanInf jmxConfigBean;

    public JMXConfigurationStrategy(String managerName) {
        this.managerName = managerName;
    }

    public JMXConfigBeanInf getJMXConfigBean() {
        return this.jmxConfigBean;
    }

    @Override
    public void registerForRefresh(Map<String, Map<String, String>> configs, Map<String, Config> defaultConfigs) throws ConfigException {
        try {
            ObjectName jmxName = new ObjectName("com.att.aft.scld:type=ConfigurationManager,name=JmxConfigurationManager-" + this.managerName);
            this.jmxConfigBean = new JxmConfigMBean(this.managerName);
            ManagementFactory.getPlatformMBeanServer().registerMBean(this.jmxConfigBean, jmxName);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            throw new ConfigException("SLCD-CONFIG-2002", e);
        }
        catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            throw new ConfigException("SLCD-CONFIG-2002", e);
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            throw new ConfigException("SLCD-CONFIG-2002", e);
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
            throw new ConfigException("SLCD-CONFIG-2002", e);
        }
    }

    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }

    public static void main(String[] args) throws ConfigException, InterruptedException {
        JMXConfigurationStrategy jvm = new JMXConfigurationStrategy("jmxConsoleConfigManager");
        Map<String, Map<String, String>> configs = null;
        Map<String, Config> defaultConfigs = null;
        jvm.registerForRefresh(configs, defaultConfigs);
        Thread.sleep(Long.MAX_VALUE);
    }
}

