/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.ascii.rest;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.instance.Node;
import com.hazelcast.internal.ascii.TextCommandService;
import com.hazelcast.internal.ascii.rest.HttpCommand;
import com.hazelcast.internal.ascii.rest.HttpCommandProcessor;
import com.hazelcast.internal.ascii.rest.HttpPostCommand;
import com.hazelcast.internal.ascii.rest.RestValue;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.management.ManagementCenterService;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class HttpPostCommandProcessor
extends HttpCommandProcessor<HttpPostCommand> {
    private static final byte[] QUEUE_SIMPLE_VALUE_CONTENT_TYPE = StringUtil.stringToBytes("text/plain");

    public HttpPostCommandProcessor(TextCommandService textCommandService) {
        super(textCommandService);
    }

    @Override
    public void handle(HttpPostCommand command) {
        try {
            String uri = command.getURI();
            if (uri.startsWith("/hazelcast/rest/maps/")) {
                this.handleMap(command, uri);
            } else if (uri.startsWith("/hazelcast/rest/mancenter/changeurl")) {
                this.handleManagementCenterUrlChange(command);
            } else if (uri.startsWith("/hazelcast/rest/queues/")) {
                this.handleQueue(command, uri);
            } else if (uri.startsWith("/hazelcast/rest/management/cluster/state")) {
                this.handleGetClusterState(command);
            } else if (uri.startsWith("/hazelcast/rest/management/cluster/changeState")) {
                this.handleChangeClusterState(command);
            } else {
                if (uri.startsWith("/hazelcast/rest/management/cluster/clusterShutdown")) {
                    this.handleClusterShutdown(command);
                    return;
                }
                if (uri.startsWith("/hazelcast/rest/management/cluster/forceStart")) {
                    this.handleForceStart(command);
                } else if (uri.startsWith("/hazelcast/rest/management/cluster/nodes")) {
                    this.handleListNodes(command);
                } else if (uri.startsWith("/hazelcast/rest/management/cluster/memberShutdown")) {
                    this.handleShutdownNode(command);
                } else if (uri.startsWith("/hazelcast/rest/wan/sync/map")) {
                    this.handleWanSyncMap(command);
                } else {
                    command.setResponse(HttpCommand.RES_400);
                }
            }
        }
        catch (Exception e) {
            command.setResponse(HttpCommand.RES_500);
        }
        this.textCommandService.sendResponse(command);
    }

    private void handleChangeClusterState(HttpPostCommand command) throws UnsupportedEncodingException {
        byte[] data = command.getData();
        String[] strList = StringUtil.bytesToString(data).split("&");
        String groupName = URLDecoder.decode(strList[0], "UTF-8");
        String groupPass = URLDecoder.decode(strList[1], "UTF-8");
        String stateParam = URLDecoder.decode(strList[2], "UTF-8");
        String res = "{\"status\":\"${STATUS}\",\"state\":\"${STATE}\"}";
        try {
            Node node = this.textCommandService.getNode();
            ClusterServiceImpl clusterService = node.getClusterService();
            GroupConfig groupConfig = node.getConfig().getGroupConfig();
            if (!groupConfig.getName().equals(groupName) || !groupConfig.getPassword().equals(groupPass)) {
                res = res.replace("${STATUS}", "forbidden");
                res = res.replace("${STATE}", "null");
            } else {
                ClusterState state = clusterService.getClusterState();
                if (stateParam.equals("frozen")) {
                    state = ClusterState.FROZEN;
                }
                if (stateParam.equals("active")) {
                    state = ClusterState.ACTIVE;
                }
                if (stateParam.equals("passive")) {
                    state = ClusterState.PASSIVE;
                }
                if (!state.equals((Object)clusterService.getClusterState())) {
                    clusterService.changeClusterState(state);
                    res = res.replace("${STATUS}", "success");
                    res = res.replace("${STATE}", state.toString().toLowerCase());
                } else {
                    res = res.replace("${STATUS}", "fail");
                    res = res.replace("${STATE}", state.toString().toLowerCase());
                }
            }
        }
        catch (Throwable throwable) {
            res = res.replace("${STATUS}", "fail");
            res = res.replace("${STATE}", "null");
        }
        command.setResponse(HttpCommand.CONTENT_TYPE_JSON, StringUtil.stringToBytes(res));
    }

    private void handleGetClusterState(HttpPostCommand command) throws UnsupportedEncodingException {
        byte[] data = command.getData();
        String[] strList = StringUtil.bytesToString(data).split("&");
        String groupName = URLDecoder.decode(strList[0], "UTF-8");
        String groupPass = URLDecoder.decode(strList[1], "UTF-8");
        String res = "{\"status\":\"${STATUS}\",\"state\":\"${STATE}\"}";
        try {
            Node node = this.textCommandService.getNode();
            ClusterServiceImpl clusterService = node.getClusterService();
            GroupConfig groupConfig = node.getConfig().getGroupConfig();
            if (!groupConfig.getName().equals(groupName) || !groupConfig.getPassword().equals(groupPass)) {
                res = res.replace("${STATUS}", "forbidden");
                res = res.replace("${STATE}", "null");
            } else {
                res = res.replace("${STATUS}", "success");
                res = res.replace("${STATE}", clusterService.getClusterState().toString().toLowerCase());
            }
        }
        catch (Throwable throwable) {
            res = res.replace("${STATUS}", "fail");
            res = res.replace("${STATE}", "null");
        }
        command.setResponse(HttpCommand.CONTENT_TYPE_JSON, StringUtil.stringToBytes(res));
    }

    private void handleForceStart(HttpPostCommand command) throws UnsupportedEncodingException {
        byte[] data = command.getData();
        String[] strList = StringUtil.bytesToString(data).split("&");
        String groupName = URLDecoder.decode(strList[0], "UTF-8");
        String groupPass = URLDecoder.decode(strList[1], "UTF-8");
        String res = "{\"status\":\"${STATUS}\"}";
        try {
            boolean success;
            Node node = this.textCommandService.getNode();
            GroupConfig groupConfig = node.getConfig().getGroupConfig();
            res = !groupConfig.getName().equals(groupName) || !groupConfig.getPassword().equals(groupPass) ? res.replace("${STATUS}", "forbidden") : res.replace("${STATUS}", (success = node.getNodeExtension().triggerForceStart()) ? "success" : "fail");
        }
        catch (Throwable throwable) {
            res = res.replace("${STATUS}", "fail");
        }
        command.setResponse(HttpCommand.CONTENT_TYPE_JSON, StringUtil.stringToBytes(res));
        this.textCommandService.sendResponse(command);
    }

    private void handleClusterShutdown(HttpPostCommand command) throws UnsupportedEncodingException {
        byte[] data = command.getData();
        String[] strList = StringUtil.bytesToString(data).split("&");
        String groupName = URLDecoder.decode(strList[0], "UTF-8");
        String groupPass = URLDecoder.decode(strList[1], "UTF-8");
        String res = "{\"status\":\"${STATUS}\"}";
        try {
            Node node = this.textCommandService.getNode();
            ClusterServiceImpl clusterService = node.getClusterService();
            GroupConfig groupConfig = node.getConfig().getGroupConfig();
            if (groupConfig.getName().equals(groupName) && groupConfig.getPassword().equals(groupPass)) {
                res = res.replace("${STATUS}", "success");
                command.setResponse(HttpCommand.CONTENT_TYPE_JSON, StringUtil.stringToBytes(res));
                this.textCommandService.sendResponse(command);
                clusterService.shutdown();
                return;
            }
            res = res.replace("${STATUS}", "forbidden");
        }
        catch (Throwable throwable) {
            res = res.replace("${STATUS}", "fail");
        }
        command.setResponse(HttpCommand.CONTENT_TYPE_JSON, StringUtil.stringToBytes(res));
        this.textCommandService.sendResponse(command);
    }

    private void handleListNodes(HttpPostCommand command) throws UnsupportedEncodingException {
        byte[] data = command.getData();
        String[] strList = StringUtil.bytesToString(data).split("&");
        String groupName = URLDecoder.decode(strList[0], "UTF-8");
        String groupPass = URLDecoder.decode(strList[1], "UTF-8");
        String res = "{\"status\":\"${STATUS}\" \"response\":\"${RESPONSE}\"}";
        try {
            Node node = this.textCommandService.getNode();
            ClusterServiceImpl clusterService = node.getClusterService();
            GroupConfig groupConfig = node.getConfig().getGroupConfig();
            if (groupConfig.getName().equals(groupName) && groupConfig.getPassword().equals(groupPass)) {
                res = res.replace("${STATUS}", "success");
                res = res.replace("${RESPONSE}", clusterService.getMembers().toString() + "\n" + BuildInfoProvider.getBuildInfo().getVersion() + "\n" + System.getProperty("java.version"));
                command.setResponse(HttpCommand.CONTENT_TYPE_JSON, StringUtil.stringToBytes(res));
                this.textCommandService.sendResponse(command);
                return;
            }
            res = res.replace("${STATUS}", "forbidden");
            res = res.replace("${RESPONSE}", "null");
        }
        catch (Throwable throwable) {
            res = res.replace("${STATUS}", "fail");
        }
        command.setResponse(HttpCommand.CONTENT_TYPE_JSON, StringUtil.stringToBytes(res));
        this.textCommandService.sendResponse(command);
    }

    private void handleShutdownNode(HttpPostCommand command) throws UnsupportedEncodingException {
        byte[] data = command.getData();
        String[] strList = StringUtil.bytesToString(data).split("&");
        String groupName = URLDecoder.decode(strList[0], "UTF-8");
        String groupPass = URLDecoder.decode(strList[1], "UTF-8");
        String res = "{\"status\":\"${STATUS}\"}";
        try {
            Node node = this.textCommandService.getNode();
            GroupConfig groupConfig = node.getConfig().getGroupConfig();
            if (groupConfig.getName().equals(groupName) && groupConfig.getPassword().equals(groupPass)) {
                res = res.replace("${STATUS}", "success");
                command.setResponse(HttpCommand.CONTENT_TYPE_JSON, StringUtil.stringToBytes(res));
                this.textCommandService.sendResponse(command);
                node.hazelcastInstance.shutdown();
                return;
            }
            res = res.replace("${STATUS}", "forbidden");
        }
        catch (Throwable throwable) {
            res = res.replace("${STATUS}", "fail");
        }
        command.setResponse(HttpCommand.CONTENT_TYPE_JSON, StringUtil.stringToBytes(res));
        this.textCommandService.sendResponse(command);
    }

    private void handleQueue(HttpPostCommand command, String uri) {
        byte[] contentType;
        byte[] data;
        String queueName;
        String simpleValue = null;
        String suffix = uri.endsWith("/") ? uri.substring("/hazelcast/rest/queues/".length(), uri.length() - 1) : uri.substring("/hazelcast/rest/queues/".length(), uri.length());
        int indexSlash = suffix.lastIndexOf(47);
        if (indexSlash == -1) {
            queueName = suffix;
        } else {
            queueName = suffix.substring(0, indexSlash);
            simpleValue = suffix.substring(indexSlash + 1, suffix.length());
        }
        if (simpleValue == null) {
            data = command.getData();
            contentType = command.getContentType();
        } else {
            data = StringUtil.stringToBytes(simpleValue);
            contentType = QUEUE_SIMPLE_VALUE_CONTENT_TYPE;
        }
        boolean offerResult = this.textCommandService.offer(queueName, new RestValue(data, contentType));
        if (offerResult) {
            command.send200();
        } else {
            command.setResponse(HttpCommand.RES_503);
        }
    }

    private void handleManagementCenterUrlChange(HttpPostCommand command) throws UnsupportedEncodingException {
        if (this.textCommandService.getNode().getProperties().getBoolean(GroupProperty.MC_URL_CHANGE_ENABLED)) {
            byte[] res = HttpCommand.RES_204;
            byte[] data = command.getData();
            String[] strList = StringUtil.bytesToString(data).split("&");
            String cluster = URLDecoder.decode(strList[0], "UTF-8");
            String pass = URLDecoder.decode(strList[1], "UTF-8");
            String url = URLDecoder.decode(strList[2], "UTF-8");
            ManagementCenterService managementCenterService = this.textCommandService.getNode().getManagementCenterService();
            if (managementCenterService != null) {
                res = managementCenterService.clusterWideUpdateManagementCenterUrl(cluster, pass, url);
            }
            command.setResponse(res);
        } else {
            command.setResponse(HttpCommand.RES_503);
        }
    }

    private void handleMap(HttpPostCommand command, String uri) {
        int indexEnd = uri.indexOf(47, "/hazelcast/rest/maps/".length());
        String mapName = uri.substring("/hazelcast/rest/maps/".length(), indexEnd);
        String key = uri.substring(indexEnd + 1);
        byte[] data = command.getData();
        this.textCommandService.put(mapName, key, new RestValue(data, command.getContentType()), -1);
        command.send200();
    }

    private void handleWanSyncMap(HttpPostCommand command) throws UnsupportedEncodingException {
        String res = "{\"status\":\"${STATUS}\",\"message\":\"${MESSAGE}\"}";
        byte[] data = command.getData();
        String[] strList = StringUtil.bytesToString(data).split("&");
        String wanRepName = URLDecoder.decode(strList[0], "UTF-8");
        String targetGroup = URLDecoder.decode(strList[1], "UTF-8");
        String mapName = URLDecoder.decode(strList[2], "UTF-8");
        try {
            this.textCommandService.getNode().getNodeEngine().getWanReplicationService().syncMap(wanRepName, targetGroup, mapName);
            res = res.replace("${STATUS}", "success");
            res = res.replace("${MESSAGE}", "Sync initiated");
        }
        catch (Exception ex) {
            res = res.replace("${STATUS}", "fail");
            res = res.replace("${MESSAGE}", ex.getMessage());
        }
        command.setResponse(HttpCommand.CONTENT_TYPE_JSON, StringUtil.stringToBytes(res));
        this.textCommandService.sendResponse(command);
    }

    @Override
    public void handleRejection(HttpPostCommand command) {
        this.handle(command);
    }
}

