/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.diagnostics.BuildInfoPlugin;
import com.hazelcast.internal.diagnostics.ConfigPropertiesPlugin;
import com.hazelcast.internal.diagnostics.Diagnostics;
import com.hazelcast.internal.diagnostics.InvocationPlugin;
import com.hazelcast.internal.diagnostics.MemberHazelcastInstanceInfoPlugin;
import com.hazelcast.internal.diagnostics.MetricsPlugin;
import com.hazelcast.internal.diagnostics.OverloadedConnectionsPlugin;
import com.hazelcast.internal.diagnostics.PendingInvocationsPlugin;
import com.hazelcast.internal.diagnostics.SlowOperationPlugin;
import com.hazelcast.internal.diagnostics.SystemLogPlugin;
import com.hazelcast.internal.diagnostics.SystemPropertiesPlugin;
import com.hazelcast.internal.management.ManagementCenterService;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.metrics.impl.MetricsRegistryImpl;
import com.hazelcast.internal.metrics.metricsets.ClassLoadingMetricSet;
import com.hazelcast.internal.metrics.metricsets.FileMetricSet;
import com.hazelcast.internal.metrics.metricsets.GarbageCollectionMetricSet;
import com.hazelcast.internal.metrics.metricsets.OperatingSystemMetricSet;
import com.hazelcast.internal.metrics.metricsets.RuntimeMetricSet;
import com.hazelcast.internal.metrics.metricsets.ThreadMetricSet;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.internal.partition.MigrationInfo;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingServiceImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.quorum.impl.QuorumServiceImpl;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PostJoinAwareService;
import com.hazelcast.spi.SharedService;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.spi.exception.ServiceNotFoundException;
import com.hazelcast.spi.impl.PacketHandler;
import com.hazelcast.spi.impl.eventservice.InternalEventService;
import com.hazelcast.spi.impl.eventservice.impl.EventServiceImpl;
import com.hazelcast.spi.impl.eventservice.impl.operations.PostJoinRegistrationOperation;
import com.hazelcast.spi.impl.executionservice.InternalExecutionService;
import com.hazelcast.spi.impl.executionservice.impl.ExecutionServiceImpl;
import com.hazelcast.spi.impl.operationservice.InternalOperationService;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.impl.packetdispatcher.PacketDispatcher;
import com.hazelcast.spi.impl.packetdispatcher.impl.PacketDispatcherImpl;
import com.hazelcast.spi.impl.proxyservice.InternalProxyService;
import com.hazelcast.spi.impl.proxyservice.impl.ProxyServiceImpl;
import com.hazelcast.spi.impl.servicemanager.ServiceInfo;
import com.hazelcast.spi.impl.servicemanager.ServiceManager;
import com.hazelcast.spi.impl.servicemanager.impl.ServiceManagerImpl;
import com.hazelcast.spi.impl.waitnotifyservice.WaitNotifyService;
import com.hazelcast.spi.impl.waitnotifyservice.impl.WaitNotifyServiceImpl;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.transaction.TransactionManagerService;
import com.hazelcast.transaction.impl.TransactionManagerServiceImpl;
import com.hazelcast.wan.WanReplicationService;
import java.util.Collection;
import java.util.LinkedList;

public class NodeEngineImpl
implements NodeEngine {
    private final Node node;
    private final ILogger logger;
    private final EventServiceImpl eventService;
    private final OperationServiceImpl operationService;
    private final ExecutionServiceImpl executionService;
    private final WaitNotifyServiceImpl waitNotifyService;
    private final ServiceManagerImpl serviceManager;
    private final TransactionManagerServiceImpl transactionManagerService;
    private final ProxyServiceImpl proxyService;
    private final WanReplicationService wanReplicationService;
    private final PacketDispatcher packetDispatcher;
    private final QuorumServiceImpl quorumService;
    private final MetricsRegistryImpl metricsRegistry;
    private final SerializationService serializationService;
    private final LoggingServiceImpl loggingService;
    private final Diagnostics diagnostics;

    public NodeEngineImpl(Node node) {
        this.node = node;
        this.loggingService = node.loggingService;
        this.serializationService = node.getSerializationService();
        this.logger = node.getLogger(NodeEngine.class.getName());
        this.metricsRegistry = this.newMetricRegistry(node);
        this.proxyService = new ProxyServiceImpl(this);
        this.serviceManager = new ServiceManagerImpl(this);
        this.executionService = new ExecutionServiceImpl(this);
        this.operationService = new OperationServiceImpl(this);
        this.eventService = new EventServiceImpl(this);
        this.waitNotifyService = new WaitNotifyServiceImpl(this);
        this.transactionManagerService = new TransactionManagerServiceImpl(this);
        this.wanReplicationService = node.getNodeExtension().createService(WanReplicationService.class);
        this.packetDispatcher = new PacketDispatcherImpl(this.logger, this.operationService.getOperationExecutor(), this.operationService.getAsyncResponseHandler(), this.operationService.getInvocationMonitor(), this.eventService, new ConnectionManagerPacketHandler());
        this.quorumService = new QuorumServiceImpl(this);
        this.diagnostics = this.newDiagnostics();
        this.serviceManager.registerService("hz:impl:operationService", this.operationService);
        this.serviceManager.registerService("hz:impl:waitNotifyService", this.waitNotifyService);
    }

    private MetricsRegistryImpl newMetricRegistry(Node node) {
        ProbeLevel probeLevel = node.getProperties().getEnum(Diagnostics.METRICS_LEVEL, ProbeLevel.class);
        return new MetricsRegistryImpl(node.getLogger(MetricsRegistryImpl.class), probeLevel);
    }

    private Diagnostics newDiagnostics() {
        MemberImpl localMember = this.node.getLocalMember();
        Address address = localMember.getAddress();
        String addressString = address.getHost().replace(":", "_") + "_" + address.getPort();
        String name = "diagnostics-" + addressString + "-" + System.currentTimeMillis();
        return new Diagnostics(name, this.loggingService.getLogger(Diagnostics.class), this.node.getHazelcastThreadGroup(), this.node.getProperties());
    }

    public MetricsRegistry getMetricsRegistry() {
        return this.metricsRegistry;
    }

    public PacketDispatcher getPacketDispatcher() {
        return this.packetDispatcher;
    }

    public void start() {
        RuntimeMetricSet.register(this.metricsRegistry);
        GarbageCollectionMetricSet.register(this.metricsRegistry);
        OperatingSystemMetricSet.register(this.metricsRegistry);
        ThreadMetricSet.register(this.metricsRegistry);
        ClassLoadingMetricSet.register(this.metricsRegistry);
        FileMetricSet.register(this.metricsRegistry);
        this.metricsRegistry.collectMetrics(this.operationService);
        this.metricsRegistry.collectMetrics(this.proxyService);
        this.metricsRegistry.collectMetrics(this.eventService);
        this.serviceManager.start();
        this.proxyService.init();
        this.operationService.start();
        this.quorumService.start();
        this.diagnostics.start();
        this.diagnostics.register(new BuildInfoPlugin(this));
        this.diagnostics.register(new SystemPropertiesPlugin(this));
        this.diagnostics.register(new ConfigPropertiesPlugin(this));
        this.diagnostics.register(new OverloadedConnectionsPlugin(this));
        this.diagnostics.register(new PendingInvocationsPlugin(this));
        this.diagnostics.register(new MetricsPlugin(this));
        this.diagnostics.register(new SlowOperationPlugin(this));
        this.diagnostics.register(new InvocationPlugin(this));
        this.diagnostics.register(new MemberHazelcastInstanceInfoPlugin(this));
        this.diagnostics.register(new SystemLogPlugin(this));
    }

    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    @Override
    public Address getThisAddress() {
        return this.node.getThisAddress();
    }

    @Override
    public Address getMasterAddress() {
        return this.node.getMasterAddress();
    }

    @Override
    public MemberImpl getLocalMember() {
        return this.node.getLocalMember();
    }

    @Override
    public Config getConfig() {
        return this.node.getConfig();
    }

    @Override
    public ClassLoader getConfigClassLoader() {
        return this.node.getConfigClassLoader();
    }

    @Override
    public InternalEventService getEventService() {
        return this.eventService;
    }

    @Override
    public SerializationService getSerializationService() {
        return this.serializationService;
    }

    @Override
    public InternalOperationService getOperationService() {
        return this.operationService;
    }

    @Override
    public InternalExecutionService getExecutionService() {
        return this.executionService;
    }

    @Override
    public InternalPartitionService getPartitionService() {
        return this.node.getPartitionService();
    }

    @Override
    public ClusterService getClusterService() {
        return this.node.getClusterService();
    }

    public ManagementCenterService getManagementCenterService() {
        return this.node.getManagementCenterService();
    }

    @Override
    public InternalProxyService getProxyService() {
        return this.proxyService;
    }

    public WaitNotifyService getWaitNotifyService() {
        return this.waitNotifyService;
    }

    @Override
    public WanReplicationService getWanReplicationService() {
        return this.wanReplicationService;
    }

    @Override
    public QuorumServiceImpl getQuorumService() {
        return this.quorumService;
    }

    @Override
    public TransactionManagerService getTransactionManagerService() {
        return this.transactionManagerService;
    }

    @Override
    public Data toData(Object object) {
        return this.serializationService.toData(object);
    }

    public Object toObject(Object object) {
        return this.serializationService.toObject(object);
    }

    @Override
    public boolean isActive() {
        return this.isRunning();
    }

    @Override
    public boolean isRunning() {
        return this.node.isRunning();
    }

    @Override
    public HazelcastInstance getHazelcastInstance() {
        return this.node.hazelcastInstance;
    }

    @Override
    public ILogger getLogger(String name) {
        return this.loggingService.getLogger(name);
    }

    @Override
    public ILogger getLogger(Class clazz) {
        return this.loggingService.getLogger(clazz);
    }

    @Override
    public HazelcastProperties getProperties() {
        return this.node.getProperties();
    }

    @Override
    public <T> T getService(String serviceName) {
        Object service = this.serviceManager.getService(serviceName);
        if (service == null) {
            if (this.isRunning()) {
                throw new HazelcastException("Service with name '" + serviceName + "' not found!", new ServiceNotFoundException("Service with name '" + serviceName + "' not found!"));
            }
            throw new RetryableHazelcastException("HazelcastInstance[" + this.getThisAddress() + "] is not active!");
        }
        return service;
    }

    @Override
    public <T extends SharedService> T getSharedService(String serviceName) {
        return this.serviceManager.getSharedService(serviceName);
    }

    public <S> Collection<S> getServices(Class<S> serviceClass) {
        return this.serviceManager.getServices(serviceClass);
    }

    public Collection<ServiceInfo> getServiceInfos(Class serviceClass) {
        return this.serviceManager.getServiceInfos(serviceClass);
    }

    public Node getNode() {
        return this.node;
    }

    public void onMemberLeft(MemberImpl member) {
        this.waitNotifyService.onMemberLeft(member);
        this.operationService.onMemberLeft(member);
        this.eventService.onMemberLeft(member);
    }

    public void onClientDisconnected(String clientUuid) {
        this.waitNotifyService.onClientDisconnected(clientUuid);
    }

    public void onPartitionMigrate(MigrationInfo migrationInfo) {
        this.waitNotifyService.onPartitionMigrate(this.getThisAddress(), migrationInfo);
    }

    public Operation[] getPostJoinOperations() {
        LinkedList<Operation> postJoinOps = new LinkedList<Operation>();
        PostJoinRegistrationOperation eventPostJoinOp = this.eventService.getPostJoinOperation();
        if (eventPostJoinOp != null) {
            postJoinOps.add(eventPostJoinOp);
        }
        Collection<PostJoinAwareService> services = this.getServices(PostJoinAwareService.class);
        for (PostJoinAwareService service : services) {
            Operation postJoinOperation = service.getPostJoinOperation();
            if (postJoinOperation == null) continue;
            if (postJoinOperation.getPartitionId() >= 0) {
                this.logger.severe("Post-join operations cannot implement PartitionAwareOperation! Service: " + service + ", Operation: " + postJoinOperation);
                continue;
            }
            postJoinOps.add(postJoinOperation);
        }
        return postJoinOps.isEmpty() ? null : postJoinOps.toArray(new Operation[postJoinOps.size()]);
    }

    public void reset() {
        this.waitNotifyService.reset();
        this.operationService.reset();
    }

    public void shutdown(boolean terminate) {
        this.logger.finest("Shutting down services...");
        this.waitNotifyService.shutdown();
        this.operationService.shutdownInvocations();
        this.proxyService.shutdown();
        this.serviceManager.shutdown(terminate);
        this.eventService.shutdown();
        this.operationService.shutdownOperationExecutor();
        this.wanReplicationService.shutdown();
        this.executionService.shutdown();
        this.metricsRegistry.shutdown();
        this.diagnostics.shutdown();
    }

    class ConnectionManagerPacketHandler
    implements PacketHandler {
        ConnectionManagerPacketHandler() {
        }

        @Override
        public void handle(Packet packet) throws Exception {
            PacketHandler packetHandler = (PacketHandler)((Object)NodeEngineImpl.this.node.getConnectionManager());
            packetHandler.handle(packet);
        }
    }
}

