/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.interceptor;

import com.att.aft.dme2.internal.apache.commons.logging.Log;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.interceptor.AbstractTraceInterceptor;

public class SimpleTraceInterceptor
extends AbstractTraceInterceptor {
    public SimpleTraceInterceptor() {
    }

    public SimpleTraceInterceptor(boolean useDynamicLogger) {
        this.setUseDynamicLogger(useDynamicLogger);
    }

    @Override
    protected Object invokeUnderTrace(MethodInvocation invocation, Log logger) throws Throwable {
        String invocationDescription = this.getInvocationDescription(invocation);
        logger.trace("Entering " + invocationDescription);
        try {
            Object rval = invocation.proceed();
            logger.trace("Exiting " + invocationDescription);
            return rval;
        }
        catch (Throwable ex) {
            logger.trace("Exception thrown in " + invocationDescription, ex);
            throw ex;
        }
    }

    protected String getInvocationDescription(MethodInvocation invocation) {
        return "method '" + invocation.getMethod().getName() + "' of class [" + invocation.getThis().getClass().getName() + "]";
    }
}

