/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation.beanvalidation;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.ConstraintDescriptor;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.util.Assert;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.validation.SmartValidator;

public class SpringValidatorAdapter
implements SmartValidator,
Validator {
    private static final Set<String> internalAnnotationAttributes = new HashSet<String>(3);
    private Validator targetValidator;

    public SpringValidatorAdapter(Validator targetValidator) {
        Assert.notNull(targetValidator, "Target Validator must not be null");
        this.targetValidator = targetValidator;
    }

    SpringValidatorAdapter() {
    }

    void setTargetValidator(Validator targetValidator) {
        this.targetValidator = targetValidator;
    }

    @Override
    public boolean supports(Class<?> clazz) {
        return this.targetValidator != null;
    }

    @Override
    public void validate(Object target, Errors errors) {
        if (this.targetValidator != null) {
            this.processConstraintViolations(this.targetValidator.validate(target, new Class[0]), errors);
        }
    }

    @Override
    public void validate(Object target, Errors errors, Object ... validationHints) {
        if (this.targetValidator != null) {
            LinkedHashSet<Class> groups = new LinkedHashSet<Class>();
            if (validationHints != null) {
                for (Object hint : validationHints) {
                    if (!(hint instanceof Class)) continue;
                    groups.add((Class)hint);
                }
            }
            this.processConstraintViolations(this.targetValidator.validate(target, groups.toArray(new Class[groups.size()])), errors);
        }
    }

    protected void processConstraintViolations(Set<ConstraintViolation<Object>> violations, Errors errors) {
        for (ConstraintViolation<Object> violation : violations) {
            String field = this.determineField(violation);
            FieldError fieldError = errors.getFieldError(field);
            if (fieldError != null && fieldError.isBindingFailure()) continue;
            try {
                ConstraintDescriptor cd = violation.getConstraintDescriptor();
                String errorCode = this.determineErrorCode(cd);
                Object[] errorArgs = this.getArgumentsForConstraint(errors.getObjectName(), field, cd);
                if (errors instanceof BindingResult) {
                    BindingResult bindingResult = (BindingResult)errors;
                    String nestedField = bindingResult.getNestedPath() + field;
                    if ("".equals(nestedField)) {
                        String[] errorCodes = bindingResult.resolveMessageCodes(errorCode);
                        bindingResult.addError(new ObjectError(errors.getObjectName(), errorCodes, errorArgs, violation.getMessage()));
                        continue;
                    }
                    Object rejectedValue = this.getRejectedValue(field, violation, bindingResult);
                    String[] errorCodes = bindingResult.resolveMessageCodes(errorCode, field);
                    bindingResult.addError(new FieldError(errors.getObjectName(), nestedField, rejectedValue, false, errorCodes, errorArgs, violation.getMessage()));
                    continue;
                }
                errors.rejectValue(field, errorCode, errorArgs, violation.getMessage());
            }
            catch (NotReadablePropertyException ex) {
                throw new IllegalStateException("JSR-303 validated property '" + field + "' does not have a corresponding accessor for Spring data binding - check your DataBinder's configuration (bean property versus direct field access)", ex);
            }
        }
    }

    protected String determineField(ConstraintViolation<Object> violation) {
        return violation.getPropertyPath().toString();
    }

    protected String determineErrorCode(ConstraintDescriptor<?> descriptor) {
        return descriptor.getAnnotation().annotationType().getSimpleName();
    }

    protected Object[] getArgumentsForConstraint(String objectName, String field, ConstraintDescriptor<?> descriptor) {
        LinkedList<MessageSourceResolvable> arguments = new LinkedList<MessageSourceResolvable>();
        arguments.add(this.getResolvableField(objectName, field));
        TreeMap attributesToExpose = new TreeMap();
        for (Map.Entry entry : descriptor.getAttributes().entrySet()) {
            String attributeName = (String)entry.getKey();
            Object attributeValue = entry.getValue();
            if (internalAnnotationAttributes.contains(attributeName)) continue;
            if (attributeValue instanceof String) {
                attributeValue = new ResolvableAttribute(attributeValue.toString());
            }
            attributesToExpose.put(attributeName, attributeValue);
        }
        arguments.addAll(attributesToExpose.values());
        return arguments.toArray(new Object[arguments.size()]);
    }

    protected MessageSourceResolvable getResolvableField(String objectName, String field) {
        String[] codes = new String[]{objectName + "." + field, field};
        return new DefaultMessageSourceResolvable(codes, field);
    }

    protected Object getRejectedValue(String field, ConstraintViolation<Object> violation, BindingResult bindingResult) {
        Object invalidValue = violation.getInvalidValue();
        if (!"".equals(field) && (invalidValue == violation.getLeafBean() || field.contains(".") && !field.contains("[]"))) {
            invalidValue = bindingResult.getRawFieldValue(field);
        }
        return invalidValue;
    }

    public <T> Set<ConstraintViolation<T>> validate(T object, Class<?> ... groups) {
        Assert.state(this.targetValidator != null, "No target Validator set");
        return this.targetValidator.validate(object, (Class[])groups);
    }

    public <T> Set<ConstraintViolation<T>> validateProperty(T object, String propertyName, Class<?> ... groups) {
        Assert.state(this.targetValidator != null, "No target Validator set");
        return this.targetValidator.validateProperty(object, propertyName, (Class[])groups);
    }

    public <T> Set<ConstraintViolation<T>> validateValue(Class<T> beanType, String propertyName, Object value, Class<?> ... groups) {
        Assert.state(this.targetValidator != null, "No target Validator set");
        return this.targetValidator.validateValue(beanType, propertyName, value, (Class[])groups);
    }

    public BeanDescriptor getConstraintsForClass(Class<?> clazz) {
        Assert.state(this.targetValidator != null, "No target Validator set");
        return this.targetValidator.getConstraintsForClass(clazz);
    }

    public <T> T unwrap(Class<T> type) {
        Assert.state(this.targetValidator != null, "No target Validator set");
        return (T)(type != null ? this.targetValidator.unwrap(type) : this.targetValidator);
    }

    static {
        internalAnnotationAttributes.add("message");
        internalAnnotationAttributes.add("groups");
        internalAnnotationAttributes.add("payload");
    }

    private static class ResolvableAttribute
    implements MessageSourceResolvable {
        private final String resolvableString;

        public ResolvableAttribute(String resolvableString) {
            this.resolvableString = resolvableString;
        }

        @Override
        public String[] getCodes() {
            return new String[]{this.resolvableString};
        }

        @Override
        public Object[] getArguments() {
            return null;
        }

        @Override
        public String getDefaultMessage() {
            return this.resolvableString;
        }
    }
}

