/*
 * Decompiled with CFR 0.152.
 */
package com.audienceproject.shaded.google.common.util.concurrent;

import com.audienceproject.shaded.google.common.base.Preconditions;
import com.audienceproject.shaded.google.common.util.concurrent.SleepingTicker;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class RateLimiter {
    private final SleepingTicker ticker;
    private final long offsetNanos;
    double storedPermits;
    double maxPermits;
    volatile double stableIntervalMicros;
    private final Object mutex = new Object();
    private long nextFreeTicketMicros = 0L;

    public static RateLimiter create(double d) {
        return RateLimiter.create(SleepingTicker.SYSTEM_TICKER, d);
    }

    static RateLimiter create(SleepingTicker sleepingTicker, double d) {
        Bursty bursty = new Bursty(sleepingTicker);
        bursty.setRate(d);
        return bursty;
    }

    public static RateLimiter create(double d, long l, TimeUnit timeUnit) {
        return RateLimiter.create(SleepingTicker.SYSTEM_TICKER, d, l, timeUnit);
    }

    static RateLimiter create(SleepingTicker sleepingTicker, double d, long l, TimeUnit timeUnit) {
        WarmingUp warmingUp = new WarmingUp(sleepingTicker, l, timeUnit);
        warmingUp.setRate(d);
        return warmingUp;
    }

    static RateLimiter createBursty(SleepingTicker sleepingTicker, double d, int n) {
        Bursty bursty = new Bursty(sleepingTicker);
        bursty.setRate(d);
        bursty.maxPermits = n;
        return bursty;
    }

    private RateLimiter(SleepingTicker sleepingTicker) {
        this.ticker = sleepingTicker;
        this.offsetNanos = sleepingTicker.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setRate(double d) {
        Preconditions.checkArgument(d > 0.0 && !Double.isNaN(d), "rate must be positive");
        Object object = this.mutex;
        synchronized (object) {
            double d2;
            this.resync(this.readSafeMicros());
            this.stableIntervalMicros = d2 = (double)TimeUnit.SECONDS.toMicros(1L) / d;
            this.doSetRate(d, d2);
        }
    }

    abstract void doSetRate(double var1, double var3);

    public final double getRate() {
        return (double)TimeUnit.SECONDS.toMicros(1L) / this.stableIntervalMicros;
    }

    public void acquire() {
        this.acquire(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire(int n) {
        long l;
        RateLimiter.checkPermits(n);
        Object object = this.mutex;
        synchronized (object) {
            l = this.reserveNextTicket(n, this.readSafeMicros());
        }
        this.ticker.sleepMicrosUninterruptibly(l);
    }

    public boolean tryAcquire(long l, TimeUnit timeUnit) {
        return this.tryAcquire(1, l, timeUnit);
    }

    public boolean tryAcquire(int n) {
        return this.tryAcquire(n, 0L, TimeUnit.MICROSECONDS);
    }

    public boolean tryAcquire() {
        return this.tryAcquire(1, 0L, TimeUnit.MICROSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryAcquire(int n, long l, TimeUnit timeUnit) {
        long l2;
        long l3 = timeUnit.toMicros(l);
        RateLimiter.checkPermits(n);
        Object object = this.mutex;
        synchronized (object) {
            long l4 = this.readSafeMicros();
            if (this.nextFreeTicketMicros > l4 + l3) {
                return false;
            }
            l2 = this.reserveNextTicket(n, l4);
        }
        this.ticker.sleepMicrosUninterruptibly(l2);
        return true;
    }

    private static void checkPermits(int n) {
        Preconditions.checkArgument(n > 0, "Requested permits must be positive");
    }

    private long reserveNextTicket(double d, long l) {
        this.resync(l);
        long l2 = this.nextFreeTicketMicros - l;
        double d2 = Math.min(d, this.storedPermits);
        double d3 = d - d2;
        long l3 = this.storedPermitsToWaitTime(this.storedPermits, d2) + (long)(d3 * this.stableIntervalMicros);
        this.nextFreeTicketMicros += l3;
        this.storedPermits -= d2;
        return l2;
    }

    abstract long storedPermitsToWaitTime(double var1, double var3);

    private void resync(long l) {
        if (l > this.nextFreeTicketMicros) {
            this.storedPermits = Math.min(this.maxPermits, this.storedPermits + (double)(l - this.nextFreeTicketMicros) / this.stableIntervalMicros);
            this.nextFreeTicketMicros = l;
        }
    }

    private long readSafeMicros() {
        return TimeUnit.NANOSECONDS.toMicros(this.ticker.read() - this.offsetNanos);
    }

    public String toString() {
        return String.format("RateLimiter[stableRate=%3.1fqps]", 1000000.0 / this.stableIntervalMicros);
    }

    private static class Bursty
    extends RateLimiter {
        Bursty(SleepingTicker sleepingTicker) {
            super(sleepingTicker);
        }

        @Override
        void doSetRate(double d, double d2) {
            double d3 = this.maxPermits;
            this.maxPermits = d;
            this.storedPermits = d3 == 0.0 ? 0.0 : this.storedPermits * this.maxPermits / d3;
        }

        @Override
        long storedPermitsToWaitTime(double d, double d2) {
            return 0L;
        }
    }

    private static class WarmingUp
    extends RateLimiter {
        final long warmupPeriodMicros;
        private double slope;
        private double halfPermits;

        WarmingUp(SleepingTicker sleepingTicker, long l, TimeUnit timeUnit) {
            super(sleepingTicker);
            this.warmupPeriodMicros = timeUnit.toMicros(l);
        }

        @Override
        void doSetRate(double d, double d2) {
            double d3 = this.maxPermits;
            this.maxPermits = (double)this.warmupPeriodMicros / d2;
            this.halfPermits = this.maxPermits / 2.0;
            double d4 = d2 * 3.0;
            this.slope = (d4 - d2) / this.halfPermits;
            this.storedPermits = d3 == Double.POSITIVE_INFINITY ? 0.0 : (d3 == 0.0 ? this.maxPermits : this.storedPermits * this.maxPermits / d3);
        }

        @Override
        long storedPermitsToWaitTime(double d, double d2) {
            double d3 = d - this.halfPermits;
            long l = 0L;
            if (d3 > 0.0) {
                double d4 = Math.min(d3, d2);
                l = (long)(d4 * (this.permitsToTime(d3) + this.permitsToTime(d3 - d4)) / 2.0);
                d2 -= d4;
            }
            l = (long)((double)l + this.stableIntervalMicros * d2);
            return l;
        }

        private double permitsToTime(double d) {
            return this.stableIntervalMicros + d * this.slope;
        }
    }
}

