/*
 * Decompiled with CFR 0.152.
 */
package com.audienceproject.spark.dynamodb.connector;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDBAsync;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.ItemCollection;
import com.amazonaws.services.dynamodbv2.document.ScanOutcome;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.document.spec.ScanSpec;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import com.amazonaws.services.dynamodbv2.xspec.ExpressionSpecBuilder;
import com.audienceproject.spark.dynamodb.connector.DynamoConnector;
import com.audienceproject.spark.dynamodb.connector.FilterPushdown$;
import com.audienceproject.spark.dynamodb.connector.KeySchema;
import com.audienceproject.spark.dynamodb.connector.KeySchema$;
import java.io.Serializable;
import org.apache.spark.sql.sources.Filter;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple4;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.sys.SystemProperties;

@ScalaSignature(bytes="\u0006\u0001\u0005Mc!\u0002\u000f\u001e\u0001}9\u0003\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\t\u0011\t\u0003!\u0011!Q\u0001\n]B\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0011\")1\n\u0001C\u0001\u0019\"9!\u000b\u0001b\u0001\n\u0013\u0019\u0006BB,\u0001A\u0003%A\u000bC\u0004Y\u0001\t\u0007I\u0011B*\t\re\u0003\u0001\u0015!\u0003U\u0011\u001dQ\u0006A1A\u0005\nmCaa\u0018\u0001!\u0002\u0013a\u0006b\u00021\u0001\u0005\u0004%Ia\u0017\u0005\u0007C\u0002\u0001\u000b\u0011\u0002/\t\u000f\t\u0004!\u0019!C\u00057\"11\r\u0001Q\u0001\nqCq\u0001\u001a\u0001C\u0002\u0013\u00053\u000b\u0003\u0004f\u0001\u0001\u0006I\u0001\u0016\u0005\u000bM\u0002\u0001\n\u0011aA!\u0002\u00139\u0007b\u00029\u0001\u0005\u0004%\t%\u001d\u0005\u0007e\u0002\u0001\u000b\u0011\u00026\t\u000fM\u0004!\u0019!C!i\"1Q\u000f\u0001Q\u0001\n5DqA\u001e\u0001C\u0002\u0013\u0005s\u000f\u0003\u0004y\u0001\u0001\u0006I\u0001\u0012\u0005\bs\u0002\u0011\r\u0011\"\u0011x\u0011\u0019Q\b\u0001)A\u0005\t\")1\u0010\u0001C!y\n\u0019B+\u00192mK&sG-\u001a=D_:tWm\u0019;pe*\u0011adH\u0001\nG>tg.Z2u_JT!\u0001I\u0011\u0002\u0011\u0011Lh.Y7pI\nT!AI\u0012\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0011*\u0013aD1vI&,gnY3qe>TWm\u0019;\u000b\u0003\u0019\n1aY8n'\u0011\u0001\u0001F\f\u001a\u0011\u0005%bS\"\u0001\u0016\u000b\u0003-\nQa]2bY\u0006L!!\f\u0016\u0003\r\u0005s\u0017PU3g!\ty\u0003'D\u0001\u001e\u0013\t\tTDA\bEs:\fWn\\\"p]:,7\r^8s!\tI3'\u0003\u00025U\ta1+\u001a:jC2L'0\u00192mK\u0006IA/\u00192mK:\u000bW.Z\u0002\u0001!\tAtH\u0004\u0002:{A\u0011!HK\u0007\u0002w)\u0011AHN\u0001\u0007yI|w\u000e\u001e \n\u0005yR\u0013A\u0002)sK\u0012,g-\u0003\u0002A\u0003\n11\u000b\u001e:j]\u001eT!A\u0010\u0016\u0002\u0013%tG-\u001a=OC6,\u0017a\u00039be\u0006dG.\u001a7jg6\u0004\"!K#\n\u0005\u0019S#aA%oi\u0006Q\u0001/\u0019:b[\u0016$XM]:\u0011\taJugN\u0005\u0003\u0015\u0006\u00131!T1q\u0003\u0019a\u0014N\\5u}Q)QJT(Q#B\u0011q\u0006\u0001\u0005\u0006k\u0015\u0001\ra\u000e\u0005\u0006\u0005\u0016\u0001\ra\u000e\u0005\u0006\u0007\u0016\u0001\r\u0001\u0012\u0005\u0006\u000f\u0016\u0001\r\u0001S\u0001\u000fG>t7/[:uK:$(+Z1e+\u0005!\u0006CA\u0015V\u0013\t1&FA\u0004C_>dW-\u00198\u0002\u001f\r|gn]5ti\u0016tGOU3bI\u0002\naBZ5mi\u0016\u0014\b+^:iI><h.A\bgS2$XM\u001d)vg\"$wn\u001e8!\u0003\u0019\u0011XmZ5p]V\tA\fE\u0002*;^J!A\u0018\u0016\u0003\r=\u0003H/[8o\u0003\u001d\u0011XmZ5p]\u0002\nqA]8mK\u0006\u0013h.\u0001\u0005s_2,\u0017I\u001d8!\u0003E\u0001(o\u001c<jI\u0016\u00148\t\\1tg:\u000bW.Z\u0001\u0013aJ|g/\u001b3fe\u000ec\u0017m]:OC6,\u0007%A\u000bgS2$XM\u001d)vg\"$wn\u001e8F]\u0006\u0014G.\u001a3\u0002-\u0019LG\u000e^3s!V\u001c\b\u000eZ8x]\u0016s\u0017M\u00197fI\u0002\n1\u0001\u001f\u00136!\u0019I\u0003N[7E\t&\u0011\u0011N\u000b\u0002\u0007)V\u0004H.\u001a\u001b\u0011\u0005=Z\u0017B\u00017\u001e\u0005%YU-_*dQ\u0016l\u0017\r\u0005\u0002*]&\u0011qN\u000b\u0002\u0007\t>,(\r\\3\u0002\u0013-,\u0017pU2iK6\fW#\u00016\u0002\u0015-,\u0017pU2iK6\f\u0007%A\u0005sK\u0006$G*[7jiV\tQ.\u0001\u0006sK\u0006$G*[7ji\u0002\n\u0011\"\u001b;f[2KW.\u001b;\u0016\u0003\u0011\u000b!\"\u001b;f[2KW.\u001b;!\u00035!x\u000e^1m'\u0016<W.\u001a8ug\u0006qAo\u001c;bYN+w-\\3oiN\u0004\u0013\u0001B:dC:$r!`A\r\u0003;\t\u0019\u0004E\u0003\u007f\u0003\u001f\t\u0019\"D\u0001\u0000\u0015\u0011\t\t!a\u0001\u0002\u0011\u0011|7-^7f]RTA!!\u0002\u0002\b\u0005QA-\u001f8b[>$'M\u001e\u001a\u000b\t\u0005%\u00111B\u0001\tg\u0016\u0014h/[2fg*\u0019\u0011QB\u0013\u0002\u0013\u0005l\u0017M_8oC^\u001c\u0018bAA\t\u007f\nq\u0011\n^3n\u0007>dG.Z2uS>t\u0007c\u0001@\u0002\u0016%\u0019\u0011qC@\u0003\u0017M\u001b\u0017M\\(vi\u000e|W.\u001a\u0005\u0007\u00037Y\u0002\u0019\u0001#\u0002\u0015M,w-\\3oi:+X\u000eC\u0004\u0002 m\u0001\r!!\t\u0002\u000f\r|G.^7ogB)\u00111EA\u0017o9!\u0011QEA\u0015\u001d\rQ\u0014qE\u0005\u0002W%\u0019\u00111\u0006\u0016\u0002\u000fA\f7m[1hK&!\u0011qFA\u0019\u0005\r\u0019V-\u001d\u0006\u0004\u0003WQ\u0003bBA\u001b7\u0001\u0007\u0011qG\u0001\bM&dG/\u001a:t!\u0019\t\u0019#!\f\u0002:A!\u00111HA(\u001b\t\tiD\u0003\u0003\u0002@\u0005\u0005\u0013aB:pkJ\u001cWm\u001d\u0006\u0005\u0003\u0007\n)%A\u0002tc2T1AIA$\u0015\u0011\tI%a\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\ti%A\u0002pe\u001eLA!!\u0015\u0002>\t1a)\u001b7uKJ\u0004")
public class TableIndexConnector
implements DynamoConnector,
scala.Serializable {
    private final String tableName;
    private final String indexName;
    private final int parallelism;
    private final boolean consistentRead;
    private final boolean filterPushdown;
    private final Option<String> region;
    private final Option<String> roleArn;
    private final Option<String> providerClassName;
    private final boolean filterPushdownEnabled;
    private final /* synthetic */ Tuple4 x$5;
    private final KeySchema keySchema;
    private final double readLimit;
    private final int itemLimit;
    private final int totalSegments;
    private transient SystemProperties com$audienceproject$spark$dynamodb$connector$DynamoConnector$$properties;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public DynamoDB getDynamoDB(Option<String> region, Option<String> roleArn, Option<String> providerClassName) {
        return DynamoConnector.getDynamoDB$(this, region, roleArn, providerClassName);
    }

    @Override
    public Option<String> getDynamoDB$default$1() {
        return DynamoConnector.getDynamoDB$default$1$(this);
    }

    @Override
    public Option<String> getDynamoDB$default$2() {
        return DynamoConnector.getDynamoDB$default$2$(this);
    }

    @Override
    public Option<String> getDynamoDB$default$3() {
        return DynamoConnector.getDynamoDB$default$3$(this);
    }

    @Override
    public AmazonDynamoDBAsync getDynamoDBAsyncClient(Option<String> region, Option<String> roleArn, Option<String> providerClassName) {
        return DynamoConnector.getDynamoDBAsyncClient$(this, region, roleArn, providerClassName);
    }

    @Override
    public Option<String> getDynamoDBAsyncClient$default$1() {
        return DynamoConnector.getDynamoDBAsyncClient$default$1$(this);
    }

    @Override
    public Option<String> getDynamoDBAsyncClient$default$2() {
        return DynamoConnector.getDynamoDBAsyncClient$default$2$(this);
    }

    @Override
    public Option<String> getDynamoDBAsyncClient$default$3() {
        return DynamoConnector.getDynamoDBAsyncClient$default$3$(this);
    }

    @Override
    public boolean isEmpty() {
        return DynamoConnector.isEmpty$(this);
    }

    @Override
    public boolean nonEmpty() {
        return DynamoConnector.nonEmpty$(this);
    }

    private SystemProperties com$audienceproject$spark$dynamodb$connector$DynamoConnector$$properties$lzycompute() {
        TableIndexConnector tableIndexConnector = this;
        synchronized (tableIndexConnector) {
            if (!this.bitmap$trans$0) {
                this.com$audienceproject$spark$dynamodb$connector$DynamoConnector$$properties = DynamoConnector.com$audienceproject$spark$dynamodb$connector$DynamoConnector$$properties$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.com$audienceproject$spark$dynamodb$connector$DynamoConnector$$properties;
    }

    @Override
    public SystemProperties com$audienceproject$spark$dynamodb$connector$DynamoConnector$$properties() {
        return !this.bitmap$trans$0 ? this.com$audienceproject$spark$dynamodb$connector$DynamoConnector$$properties$lzycompute() : this.com$audienceproject$spark$dynamodb$connector$DynamoConnector$$properties;
    }

    private boolean consistentRead() {
        return this.consistentRead;
    }

    private boolean filterPushdown() {
        return this.filterPushdown;
    }

    private Option<String> region() {
        return this.region;
    }

    private Option<String> roleArn() {
        return this.roleArn;
    }

    private Option<String> providerClassName() {
        return this.providerClassName;
    }

    @Override
    public boolean filterPushdownEnabled() {
        return this.filterPushdownEnabled;
    }

    @Override
    public KeySchema keySchema() {
        return this.keySchema;
    }

    @Override
    public double readLimit() {
        return this.readLimit;
    }

    @Override
    public int itemLimit() {
        return this.itemLimit;
    }

    @Override
    public int totalSegments() {
        return this.totalSegments;
    }

    @Override
    public ItemCollection<ScanOutcome> scan(int segmentNum, Seq<String> columns, Seq<Filter> filters) {
        BoxedUnit boxedUnit;
        ScanSpec scanSpec = new ScanSpec().withSegment(Predef$.MODULE$.int2Integer(segmentNum)).withTotalSegments(Predef$.MODULE$.int2Integer(this.totalSegments())).withMaxPageSize(this.itemLimit()).withReturnConsumedCapacity(ReturnConsumedCapacity.TOTAL).withConsistentRead(Predef$.MODULE$.boolean2Boolean(this.consistentRead()));
        if (columns.nonEmpty()) {
            ExpressionSpecBuilder xspec = new ExpressionSpecBuilder().addProjections((String[])columns.toArray(ClassTag$.MODULE$.apply(String.class)));
            Object object = filters.nonEmpty() && this.filterPushdown() ? xspec.withCondition(FilterPushdown$.MODULE$.apply(filters)) : BoxedUnit.UNIT;
            boxedUnit = scanSpec.withExpressionSpec(xspec.buildForScan());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.getDynamoDB(this.region(), this.roleArn(), this.providerClassName()).getTable(this.tableName).getIndex(this.indexName).scan(scanSpec);
    }

    public static final /* synthetic */ boolean $anonfun$x$5$1(TableIndexConnector $this, GlobalSecondaryIndexDescription x$1) {
        String string = x$1.getIndexName();
        String string2 = $this.indexName;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ int $anonfun$x$5$5(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$x$5$8(Long x$3) {
        return Predef$.MODULE$.Long2long(x$3) > 0L;
    }

    public TableIndexConnector(String tableName, String indexName, int parallelism, Map<String, String> parameters) {
        this.tableName = tableName;
        this.indexName = indexName;
        this.parallelism = parallelism;
        DynamoConnector.$init$(this);
        this.consistentRead = new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)"stronglyConsistentReads", (Function0 & Serializable & scala.Serializable)() -> "false"))).toBoolean();
        this.filterPushdown = new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)"filterPushdown", (Function0 & Serializable & scala.Serializable)() -> "true"))).toBoolean();
        this.region = parameters.get((Object)"region");
        this.roleArn = parameters.get((Object)"roleArn");
        this.providerClassName = parameters.get((Object)"providerclassname");
        this.filterPushdownEnabled = this.filterPushdown();
        Table table = this.getDynamoDB(this.region(), this.roleArn(), this.providerClassName()).getTable(tableName);
        GlobalSecondaryIndexDescription indexDesc = (GlobalSecondaryIndexDescription)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(table.describe().getGlobalSecondaryIndexes()).asScala()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TableIndexConnector.$anonfun$x$5$1(this, x$1))).get();
        KeySchema keySchema = KeySchema$.MODULE$.fromDescription((Seq<KeySchemaElement>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(indexDesc.getKeySchema()).asScala()));
        int bytesPerRCU = new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)"bytesPerRCU", (Function0 & Serializable & scala.Serializable)() -> "4000"))).toInt();
        int maxPartitionBytes = new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)"maxpartitionbytes", (Function0 & Serializable & scala.Serializable)() -> "128000000"))).toInt();
        double targetCapacity = new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)"targetCapacity", (Function0 & Serializable & scala.Serializable)() -> "1"))).toDouble();
        int readFactor = this.consistentRead() ? 1 : 2;
        Long indexSize = indexDesc.getIndexSizeBytes();
        Long itemCount = indexDesc.getItemCount();
        int numPartitions = BoxesRunTime.unboxToInt((Object)parameters.get((Object)"readpartitions").map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)TableIndexConnector.$anonfun$x$5$5(x$2))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            void var3_3;
            int sizeBased = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper((int)(Predef$.MODULE$.Long2long(indexSize) / (long)maxPartitionBytes)), 1);
            int remainder = sizeBased % $this.parallelism;
            return remainder > 0 ? sizeBased + ($this.parallelism - remainder) : var3_3;
        }));
        long readThroughput = new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)"throughput", (Function0 & Serializable & scala.Serializable)() -> (String)Option$.MODULE$.apply((Object)indexDesc.getProvisionedThroughput().getReadCapacityUnits()).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TableIndexConnector.$anonfun$x$5$8(x$3))).map((Function1 & Serializable & scala.Serializable)x$4 -> ((Object)BoxesRunTime.boxToLong((long)x$4)).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "100")))).toLong();
        double avgItemSize = (double)Predef$.MODULE$.Long2long(indexSize) / (double)Predef$.MODULE$.Long2long(itemCount);
        double readCapacity = (double)readThroughput * targetCapacity;
        double rateLimit = readCapacity / (double)parallelism;
        int itemLimit = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper((int)((double)bytesPerRCU / avgItemSize * rateLimit) * readFactor), 1);
        Tuple4 tuple4 = new Tuple4((Object)keySchema, (Object)BoxesRunTime.boxToDouble((double)rateLimit), (Object)BoxesRunTime.boxToInteger((int)itemLimit), (Object)BoxesRunTime.boxToInteger((int)numPartitions));
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        KeySchema keySchema2 = (KeySchema)tuple4._1();
        double readLimit = BoxesRunTime.unboxToDouble((Object)tuple4._2());
        int itemLimit2 = BoxesRunTime.unboxToInt((Object)tuple4._3());
        int totalSegments = BoxesRunTime.unboxToInt((Object)tuple4._4());
        Tuple4 tuple42 = new Tuple4((Object)keySchema2, (Object)BoxesRunTime.boxToDouble((double)readLimit), (Object)BoxesRunTime.boxToInteger((int)itemLimit2), (Object)BoxesRunTime.boxToInteger((int)totalSegments));
        this.x$5 = tuple42;
        this.keySchema = (KeySchema)this.x$5._1();
        this.readLimit = BoxesRunTime.unboxToDouble((Object)this.x$5._2());
        this.itemLimit = BoxesRunTime.unboxToInt((Object)this.x$5._3());
        this.totalSegments = BoxesRunTime.unboxToInt((Object)this.x$5._4());
    }
}

