/*
 * Decompiled with CFR 0.152.
 */
package com.audienceproject.spark.dynamodb.datasource;

import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.audienceproject.shaded.google.common.util.concurrent.RateLimiter;
import com.audienceproject.spark.dynamodb.connector.ColumnSchema;
import com.audienceproject.spark.dynamodb.connector.TableConnector;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.write.DataWriter;
import org.apache.spark.sql.connector.write.WriterCommitMessage;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Q4Aa\u0003\u0007\u0001/!AQ\u0007\u0001B\u0001B\u0003%a\u0007\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003<\u0011!q\u0004A!A!\u0002\u0013y\u0004\"B&\u0001\t\u0003a\u0005b\u0002*\u0001\u0005\u0004%Ia\u0015\u0005\u0007E\u0002\u0001\u000b\u0011\u0002+\t\u000b\r\u0002A\u0011I2\t\u000b1\u0004A\u0011I7\t\u000bE\u0004A\u0011\t:\t\u000bM\u0004A\u0011\t:\u0003-\u0011Kh.Y7p\t\u0006$\u0018-\u00169eCR,wK]5uKJT!!\u0004\b\u0002\u0015\u0011\fG/Y:pkJ\u001cWM\u0003\u0002\u0010!\u0005AA-\u001f8b[>$'M\u0003\u0002\u0012%\u0005)1\u000f]1sW*\u00111\u0003F\u0001\u0010CV$\u0017.\u001a8dKB\u0014xN[3di*\tQ#A\u0002d_6\u001c\u0001aE\u0002\u00011\u0001\u0002\"!\u0007\u0010\u000e\u0003iQ!a\u0007\u000f\u0002\t1\fgn\u001a\u0006\u0002;\u0005!!.\u0019<b\u0013\ty\"D\u0001\u0004PE*,7\r\u001e\t\u0004C5zS\"\u0001\u0012\u000b\u0005\r\"\u0013!B<sSR,'BA\u0013'\u0003%\u0019wN\u001c8fGR|'O\u0003\u0002(Q\u0005\u00191/\u001d7\u000b\u0005EI#B\u0001\u0016,\u0003\u0019\t\u0007/Y2iK*\tA&A\u0002pe\u001eL!A\f\u0012\u0003\u0015\u0011\u000bG/Y,sSR,'\u000f\u0005\u00021g5\t\u0011G\u0003\u00023M\u0005A1-\u0019;bYf\u001cH/\u0003\u00025c\tY\u0011J\u001c;fe:\fGNU8x\u00031\u0019w\u000e\\;n]N\u001b\u0007.Z7b!\t9\u0014(D\u00019\u0015\t)c\"\u0003\u0002;q\ta1i\u001c7v[:\u001c6\r[3nCB\u0011q\u0007P\u0005\u0003{a\u0012a\u0002V1cY\u0016\u001cuN\u001c8fGR|'/\u0001\u0004dY&,g\u000e\u001e\t\u0003\u0001&k\u0011!\u0011\u0006\u0003\u0005\u000e\u000b\u0001\u0002Z8dk6,g\u000e\u001e\u0006\u0003\t\u0016\u000b!\u0002Z=oC6|GM\u0019<3\u0015\t1u)\u0001\u0005tKJ4\u0018nY3t\u0015\tAE#A\u0005b[\u0006TxN\\1xg&\u0011!*\u0011\u0002\t\tft\u0017-\\8E\u0005\u00061A(\u001b8jiz\"B!T(Q#B\u0011a\nA\u0007\u0002\u0019!)Q\u0007\u0002a\u0001m!)Q\u0005\u0002a\u0001w!)a\b\u0002a\u0001\u007f\u0005Y!/\u0019;f\u0019&l\u0017\u000e^3s+\u0005!\u0006CA+a\u001b\u00051&BA,Y\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u00033j\u000bA!\u001e;jY*\u00111\fX\u0001\u0007G>lWn\u001c8\u000b\u0005us\u0016AB4p_\u001edWM\u0003\u0002`%\u000511\u000f[1eK\u0012L!!\u0019,\u0003\u0017I\u000bG/\u001a'j[&$XM]\u0001\re\u0006$X\rT5nSR,'\u000f\t\u000b\u0003I*\u0004\"!\u001a5\u000e\u0003\u0019T\u0011aZ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u001a\u0014A!\u00168ji\")1n\u0002a\u0001_\u00051!/Z2pe\u0012\faaY8n[&$H#\u00018\u0011\u0005\u0005z\u0017B\u00019#\u0005M9&/\u001b;fe\u000e{W.\\5u\u001b\u0016\u001c8/Y4f\u0003\u0015\t'm\u001c:u)\u0005!\u0017!B2m_N,\u0007")
public class DynamoDataUpdateWriter
implements DataWriter<InternalRow> {
    private final ColumnSchema columnSchema;
    private final TableConnector connector;
    private final DynamoDB client;
    private final RateLimiter rateLimiter;

    private RateLimiter rateLimiter() {
        return this.rateLimiter;
    }

    public void write(InternalRow record) {
        this.connector.updateItem(this.columnSchema, record, this.client, this.rateLimiter());
    }

    public WriterCommitMessage commit() {
        return new WriterCommitMessage(null){};
    }

    public void abort() {
    }

    public void close() {
        this.client.shutdown();
    }

    public DynamoDataUpdateWriter(ColumnSchema columnSchema, TableConnector connector, DynamoDB client) {
        this.columnSchema = columnSchema;
        this.connector = connector;
        this.client = client;
        this.rateLimiter = RateLimiter.create(connector.writeLimit());
    }
}

