/*
 * Decompiled with CFR 0.152.
 */
package com.audienceproject.spark.dynamodb.datasource;

import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.document.ScanOutcome;
import com.audienceproject.spark.dynamodb.connector.DynamoConnector;
import com.audienceproject.spark.dynamodb.connector.TableConnector;
import com.audienceproject.spark.dynamodb.connector.TableIndexConnector;
import com.audienceproject.spark.dynamodb.datasource.DynamoScanBuilder;
import com.audienceproject.spark.dynamodb.datasource.DynamoTable$;
import com.audienceproject.spark.dynamodb.datasource.DynamoWriteBuilder;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.WriteBuilder;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\re\u0001\u0002\u000b\u0016\u0001\u0001B\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\")!\u000b\u0001C\u0001'\"9\u0001\f\u0001b\u0001\n\u0013I\u0006B\u00021\u0001A\u0003%!\fC\u0004b\u0001\t\u0007I\u0011\u00022\t\r9\u0004\u0001\u0015!\u0003d\u0011\u0015y\u0007\u0001\"\u0011q\u0011\u0015a\b\u0001\"\u0011~\u0011\u0015q\b\u0001\"\u0011\u0000\u0011\u001d\t\t\u0002\u0001C!\u0003'Aq!a\t\u0001\t\u0003\n)\u0003C\u0004\u0002>\u0001!I!a\u0010\t\r\u0005\u001d\u0003\u0001\"\u0003~\u0011\u001d\tI\u0005\u0001C\u0005\u0003\u0017:\u0011\"!\u0018\u0016\u0003\u0003E\t!a\u0018\u0007\u0011Q)\u0012\u0011!E\u0001\u0003CBaAU\t\u0005\u0002\u0005%\u0004\"CA6#E\u0005I\u0011AA7\u0005-!\u0015P\\1n_R\u000b'\r\\3\u000b\u0005Y9\u0012A\u00033bi\u0006\u001cx.\u001e:dK*\u0011\u0001$G\u0001\tIft\u0017-\\8eE*\u0011!dG\u0001\u0006gB\f'o\u001b\u0006\u00039u\tq\"Y;eS\u0016t7-\u001a9s_*,7\r\u001e\u0006\u0002=\u0005\u00191m\\7\u0004\u0001M)\u0001!I\u00159wA\u0011!eJ\u0007\u0002G)\u0011A%J\u0001\u0005Y\u0006twMC\u0001'\u0003\u0011Q\u0017M^1\n\u0005!\u001a#AB(cU\u0016\u001cG\u000f\u0005\u0002+m5\t1F\u0003\u0002-[\u000591-\u0019;bY><'B\u0001\u00180\u0003%\u0019wN\u001c8fGR|'O\u0003\u00021c\u0005\u00191/\u001d7\u000b\u0005i\u0011$BA\u001a5\u0003\u0019\t\u0007/Y2iK*\tQ'A\u0002pe\u001eL!aN\u0016\u0003\u000bQ\u000b'\r\\3\u0011\u0005)J\u0014B\u0001\u001e,\u00051\u0019V\u000f\u001d9peR\u001c(+Z1e!\tQC(\u0003\u0002>W\ti1+\u001e9q_J$8o\u0016:ji\u0016\fqa\u001c9uS>t7\u000f\u0005\u0002A\u00076\t\u0011I\u0003\u0002C_\u0005!Q\u000f^5m\u0013\t!\u0015I\u0001\rDCN,\u0017J\\:f]NLG/\u001b<f'R\u0014\u0018N\\4NCB\f!\"^:feN\u001b\u0007.Z7b!\r9%\nT\u0007\u0002\u0011*\t\u0011*A\u0003tG\u0006d\u0017-\u0003\u0002L\u0011\n1q\n\u001d;j_:\u0004\"!\u0014)\u000e\u00039S!aT\u0018\u0002\u000bQL\b/Z:\n\u0005Es%AC*ueV\u001cG\u000fV=qK\u00061A(\u001b8jiz\"2\u0001\u0016,X!\t)\u0006!D\u0001\u0016\u0011\u0015q4\u00011\u0001@\u0011\u001d)5\u0001%AA\u0002\u0019\u000ba\u0001\\8hO\u0016\u0014X#\u0001.\u0011\u0005msV\"\u0001/\u000b\u0005u#\u0014!B:mMRR\u0017BA0]\u0005\u0019aunZ4fe\u00069An\\4hKJ\u0004\u0013a\u00043z]\u0006lwnQ8o]\u0016\u001cGo\u001c:\u0016\u0003\r\u00142\u0001Z4k\r\u0011)\u0007\u0001A2\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u000b\u00059:\u0002CA$i\u0013\tI\u0007J\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0005\u0002lY6\ta-\u0003\u0002nM\nyA)\u001f8b[>\u001cuN\u001c8fGR|'/\u0001\tes:\fWn\\\"p]:,7\r^8sA\u0005!a.Y7f)\u0005\t\bC\u0001:z\u001d\t\u0019x\u000f\u0005\u0002u\u00116\tQO\u0003\u0002w?\u00051AH]8pizJ!\u0001\u001f%\u0002\rA\u0013X\rZ3g\u0013\tQ8P\u0001\u0004TiJLgn\u001a\u0006\u0003q\"\u000baa]2iK6\fG#\u0001'\u0002\u0019\r\f\u0007/\u00192jY&$\u0018.Z:\u0015\u0005\u0005\u0005\u0001CBA\u0002\u0003\u000f\tY!\u0004\u0002\u0002\u0006)\u0011!)J\u0005\u0005\u0003\u0013\t)AA\u0002TKR\u00042AKA\u0007\u0013\r\tya\u000b\u0002\u0010)\u0006\u0014G.Z\"ba\u0006\u0014\u0017\u000e\\5us\u0006qa.Z<TG\u0006t')^5mI\u0016\u0014H\u0003BA\u000b\u0003C\u0001B!a\u0006\u0002\u001e5\u0011\u0011\u0011\u0004\u0006\u0004\u00037i\u0013\u0001\u0002:fC\u0012LA!a\b\u0002\u001a\tY1kY1o\u0005VLG\u000eZ3s\u0011\u0015q4\u00021\u0001@\u0003=qWm^,sSR,')^5mI\u0016\u0014H\u0003BA\u0014\u0003g\u0001B!!\u000b\u000205\u0011\u00111\u0006\u0006\u0004\u0003[i\u0013!B<sSR,\u0017\u0002BA\u0019\u0003W\u0011Ab\u0016:ji\u0016\u0014U/\u001b7eKJDq!!\u000e\r\u0001\u0004\t9$\u0001\u0003j]\u001a|\u0007\u0003BA\u0015\u0003sIA!a\u000f\u0002,\t\u0001Bj\\4jG\u0006dwK]5uK&sgm\\\u0001\u0016O\u0016$H)\u001a4bk2$\b+\u0019:bY2,G.[:n+\t\t\t\u0005E\u0002H\u0003\u0007J1!!\u0012I\u0005\rIe\u000e^\u0001\fS:4WM]*dQ\u0016l\u0017-A\u0005j]\u001a,'\u000fV=qKR!\u0011QJA*!\ri\u0015qJ\u0005\u0004\u0003#r%\u0001\u0003#bi\u0006$\u0016\u0010]3\t\u000f\u0005Us\u00021\u0001\u0002X\u0005)a/\u00197vKB\u0019q)!\u0017\n\u0007\u0005m\u0003JA\u0002B]f\f1\u0002R=oC6|G+\u00192mKB\u0011Q+E\n\u0004#\u0005\r\u0004cA$\u0002f%\u0019\u0011q\r%\u0003\r\u0005s\u0017PU3g)\t\ty&A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u0003\u0003_R3ARA9W\t\t\u0019\b\u0005\u0003\u0002v\u0005}TBAA<\u0015\u0011\tI(a\u001f\u0002\u0013Ut7\r[3dW\u0016$'bAA?\u0011\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0005\u0015q\u000f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class DynamoTable
implements Table,
SupportsRead,
SupportsWrite {
    private final CaseInsensitiveStringMap options;
    private final Option<StructType> userSchema;
    private final Logger logger;
    private final scala.Serializable dynamoConnector;

    public static Option<StructType> $lessinit$greater$default$2() {
        return DynamoTable$.MODULE$.$lessinit$greater$default$2();
    }

    public Transform[] partitioning() {
        return super.partitioning();
    }

    public Map<String, String> properties() {
        return super.properties();
    }

    private Logger logger() {
        return this.logger;
    }

    private scala.Serializable dynamoConnector() {
        return this.dynamoConnector;
    }

    public String name() {
        return this.options.get((Object)"tablename");
    }

    public StructType schema() {
        return (StructType)this.userSchema.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.inferSchema());
    }

    public java.util.Set<TableCapability> capabilities() {
        return (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableCapability[]{TableCapability.BATCH_READ, TableCapability.BATCH_WRITE, TableCapability.ACCEPT_ANY_SCHEMA}))).asJava();
    }

    public ScanBuilder newScanBuilder(CaseInsensitiveStringMap options) {
        return new DynamoScanBuilder((DynamoConnector)this.dynamoConnector(), this.schema());
    }

    public WriteBuilder newWriteBuilder(LogicalWriteInfo info) {
        scala.collection.immutable.Map parameters = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(((scala.collection.mutable.MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)info.options()).asScala()).toSeq());
        scala.Serializable serializable = this.dynamoConnector();
        if (!(serializable instanceof TableConnector)) {
            throw new RuntimeException("Unable to write to a GSI, please omit `indexName` option.");
        }
        TableConnector tableConnector = (TableConnector)serializable;
        DynamoWriteBuilder dynamoWriteBuilder = new DynamoWriteBuilder(tableConnector, (scala.collection.immutable.Map<String, String>)parameters, info.schema());
        return dynamoWriteBuilder;
    }

    private int getDefaultParallelism() {
        int n;
        Option option = SparkSession$.MODULE$.getActiveSession();
        if (option instanceof Some) {
            Some some = (Some)option;
            SparkSession spark = (SparkSession)some.value();
            n = spark.sparkContext().defaultParallelism();
        } else if (None$.MODULE$.equals(option)) {
            this.logger().warn("Unable to read defaultParallelism from SparkSession. Parallelism will be 1 unless overwritten with option `defaultParallelism`");
            n = 1;
        } else {
            throw new MatchError((Object)option);
        }
        return n;
    }

    private StructType inferSchema() {
        Seq inferenceItems = ((DynamoConnector)this.dynamoConnector()).nonEmpty() && this.options.getBoolean("inferSchema", true) ? (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(((ScanOutcome)((DynamoConnector)this.dynamoConnector()).scan(0, (Seq<String>)((Seq)Nil$.MODULE$), (Seq<Filter>)((Seq)Nil$.MODULE$)).firstPage().getLowLevelResult()).getItems()).asScala() : (Seq)Nil$.MODULE$;
        scala.collection.immutable.Map typeMapping = (scala.collection.immutable.Map)inferenceItems.foldLeft((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            scala.collection.immutable.Map map = (scala.collection.immutable.Map)tuple2._1();
            Item item = (Item)tuple2._2();
            scala.collection.immutable.Map map2 = map.$plus$plus((GenTraversableOnce)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(item.asMap()).asScala()).mapValues((Function1 & Serializable & scala.Serializable)value -> this.inferType(value)));
            return map2;
        });
        Seq typeSeq = ((TraversableOnce)typeMapping.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            DataType sparkType = (DataType)tuple2._2();
            StructField structField = new StructField(name, sparkType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
            return structField;
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        if (typeSeq.size() > 100) {
            throw new RuntimeException("Schema inference not possible, too many attributes in table.");
        }
        return StructType$.MODULE$.apply(typeSeq);
    }

    private DataType inferType(Object value) {
        Object object;
        Object object2 = value;
        if (object2 instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object2;
            object = bigDecimal.scale() == 0 ? (bigDecimal.precision() < 10 ? IntegerType$.MODULE$ : (bigDecimal.precision() < 19 ? LongType$.MODULE$ : DataTypes.createDecimalType((int)bigDecimal.precision(), (int)bigDecimal.scale()))) : DoubleType$.MODULE$;
        } else if (object2 instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)object2;
            object = arrayList.isEmpty() ? ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$) : ArrayType$.MODULE$.apply(this.inferType(arrayList.get(0)));
        } else if (object2 instanceof java.util.Set) {
            java.util.Set set = (java.util.Set)object2;
            object = set.isEmpty() ? ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$) : ArrayType$.MODULE$.apply(this.inferType(set.iterator().next()));
        } else if (object2 instanceof Map) {
            Map map = (Map)object2;
            Seq mapFields = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)DynamoTable.$anonfun$inferType$1(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$2 -> {
                Tuple2 tuple2 = x$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String fieldName = (String)tuple2._1();
                Object fieldValue = tuple2._2();
                StructField structField = new StructField(fieldName, this.inferType(fieldValue), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                return structField;
            }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toSeq();
            object = StructType$.MODULE$.apply(mapFields);
        } else {
            object = object2 instanceof Boolean ? BooleanType$.MODULE$ : (object2 instanceof byte[] ? BinaryType$.MODULE$ : StringType$.MODULE$);
        }
        return object;
    }

    public static final /* synthetic */ int $anonfun$dynamoConnector$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$inferType$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public DynamoTable(CaseInsensitiveStringMap options, Option<StructType> userSchema) {
        this.options = options;
        this.userSchema = userSchema;
        this.logger = LoggerFactory.getLogger(this.getClass());
        Option indexName = Option$.MODULE$.apply((Object)options.get((Object)"indexname"));
        int defaultParallelism = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)options.get((Object)"defaultparallelism")).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)DynamoTable.$anonfun$dynamoConnector$1(x$1))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.getDefaultParallelism()));
        scala.collection.immutable.Map optionsMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(((scala.collection.mutable.MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)options).asScala()).toSeq());
        this.dynamoConnector = indexName.isDefined() ? new TableIndexConnector(this.name(), (String)indexName.get(), defaultParallelism, (scala.collection.immutable.Map<String, String>)optionsMap) : new TableConnector(this.name(), defaultParallelism, (scala.collection.immutable.Map<String, String>)optionsMap);
    }
}

