/*
 * Decompiled with CFR 0.152.
 */
package com.audienceproject.spark.dynamodb.datasource;

import com.amazonaws.services.dynamodbv2.document.IncompatibleTypeException;
import com.amazonaws.services.dynamodbv2.document.Item;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set$;
import scala.collection.mutable.SetLike;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class TypeConversion$ {
    public static TypeConversion$ MODULE$;
    private final Function1<Object, UTF8String> stringConverter;

    static {
        new TypeConversion$();
    }

    public Function1<Item, Object> apply(String attrName, DataType sparkType) {
        Function1 function1;
        DataType dataType = sparkType;
        if (BooleanType$.MODULE$.equals(dataType)) {
            function1 = this.nullableGet((Function1<Item, Function1<String, Object>>)(Function1 & Serializable & scala.Serializable)x$12 -> (Function1 & Serializable & scala.Serializable)x$1 -> x$12.getBOOL(x$1), attrName);
        } else if (StringType$.MODULE$.equals(dataType)) {
            function1 = this.nullableGet((Function1<Item, Function1<String, Object>>)(Function1 & Serializable & scala.Serializable)item -> (Function1 & Serializable & scala.Serializable)attrName -> UTF8String.fromString((String)item.getString(attrName)), attrName);
        } else if (IntegerType$.MODULE$.equals(dataType)) {
            function1 = this.nullableGet((Function1<Item, Function1<String, Object>>)(Function1 & Serializable & scala.Serializable)x$2 -> (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$2.getInt(x$1)), attrName);
        } else if (LongType$.MODULE$.equals(dataType)) {
            function1 = this.nullableGet((Function1<Item, Function1<String, Object>>)(Function1 & Serializable & scala.Serializable)x$3 -> (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$3.getLong(x$1)), attrName);
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            function1 = this.nullableGet((Function1<Item, Function1<String, Object>>)(Function1 & Serializable & scala.Serializable)x$4 -> (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)x$4.getDouble(x$1)), attrName);
        } else if (FloatType$.MODULE$.equals(dataType)) {
            function1 = this.nullableGet((Function1<Item, Function1<String, Object>>)(Function1 & Serializable & scala.Serializable)x$5 -> (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToFloat((float)x$5.getFloat(x$1)), attrName);
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            function1 = this.nullableGet((Function1<Item, Function1<String, Object>>)(Function1 & Serializable & scala.Serializable)x$6 -> (Function1 & Serializable & scala.Serializable)x$1 -> x$6.getBinary(x$1), attrName);
        } else if (DecimalType$.MODULE$.unapply(dataType)) {
            function1 = this.nullableGet((Function1<Item, Function1<String, Object>>)(Function1 & Serializable & scala.Serializable)x$7 -> (Function1 & Serializable & scala.Serializable)x$1 -> x$7.getNumber(x$1), attrName);
        } else if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType innerType = arrayType.elementType();
            function1 = this.nullableGet((Function1<Item, Function1<String, Object>>)(Function1 & Serializable & scala.Serializable)x$8 -> (Function1 & Serializable & scala.Serializable)x$1 -> x$8.getList(x$1), attrName).andThen(this.extractArray(this.com$audienceproject$spark$dynamodb$datasource$TypeConversion$$convertValue(innerType)));
        } else if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            DataType dataType2 = keyType;
            StringType$ stringType$ = StringType$.MODULE$;
            if (dataType2 == null ? stringType$ != null : !dataType2.equals(stringType$)) {
                throw new IllegalArgumentException(new StringBuilder(71).append("Invalid Map key type '").append(keyType.typeName()).append("'. DynamoDB only supports String as Map key type.").toString());
            }
            function1 = this.nullableGet((Function1<Item, Function1<String, Object>>)(Function1 & Serializable & scala.Serializable)x$9 -> (Function1 & Serializable & scala.Serializable)x$1 -> x$9.getRawMap(x$1), attrName).andThen(this.extractMap(this.com$audienceproject$spark$dynamodb$datasource$TypeConversion$$convertValue(valueType)));
        } else if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            Tuple2[] nestedConversions = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).collect((PartialFunction)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1 extends StructField, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 != null) {
                        String name = A1.name();
                        DataType dataType = A1.dataType();
                        object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), TypeConversion$.MODULE$.com$audienceproject$spark$dynamodb$datasource$TypeConversion$$convertValue(dataType));
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(StructField x1) {
                    StructField structField = x1;
                    boolean bl = structField != null;
                    return bl;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            function1 = this.nullableGet((Function1<Item, Function1<String, Object>>)(Function1 & Serializable & scala.Serializable)x$10 -> (Function1 & Serializable & scala.Serializable)x$1 -> x$10.getRawMap(x$1), attrName).andThen(this.extractStruct((Seq<Tuple2<String, Function1<Object, Object>>>)Predef$.MODULE$.wrapRefArray((Object[])nestedConversions)));
        } else {
            throw new IllegalArgumentException(new StringBuilder(76).append("Spark DataType '").append(sparkType.typeName()).append("' could not be mapped to a corresponding DynamoDB data type.").toString());
        }
        return function1;
    }

    private Function1<Object, UTF8String> stringConverter() {
        return this.stringConverter;
    }

    public Function1<Object, Object> com$audienceproject$spark$dynamodb$datasource$TypeConversion$$convertValue(DataType sparkType) {
        Function1<Object, Object> function1;
        DataType dataType = sparkType;
        if (IntegerType$.MODULE$.equals(dataType)) {
            function1 = this.nullableConvert((Function1<BigDecimal, Object>)(Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.intValue()));
        } else if (LongType$.MODULE$.equals(dataType)) {
            function1 = this.nullableConvert((Function1<BigDecimal, Object>)(Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.longValue()));
        } else if (DoubleType$.MODULE$.equals(dataType)) {
            function1 = this.nullableConvert((Function1<BigDecimal, Object>)(Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToDouble((double)x$13.doubleValue()));
        } else if (FloatType$.MODULE$.equals(dataType)) {
            function1 = this.nullableConvert((Function1<BigDecimal, Object>)(Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToFloat((float)x$14.floatValue()));
        } else if (DecimalType$.MODULE$.unapply(dataType)) {
            function1 = this.nullableConvert((Function1<BigDecimal, Object>)(Function1 & Serializable & scala.Serializable)x -> (BigDecimal)Predef$.MODULE$.identity(x));
        } else if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType innerType = arrayType.elementType();
            function1 = this.extractArray(this.com$audienceproject$spark$dynamodb$datasource$TypeConversion$$convertValue(innerType));
        } else if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            DataType dataType2 = keyType;
            StringType$ stringType$ = StringType$.MODULE$;
            if (dataType2 == null ? stringType$ != null : !dataType2.equals(stringType$)) {
                throw new IllegalArgumentException(new StringBuilder(71).append("Invalid Map key type '").append(keyType.typeName()).append("'. DynamoDB only supports String as Map key type.").toString());
            }
            function1 = this.extractMap(this.com$audienceproject$spark$dynamodb$datasource$TypeConversion$$convertValue(valueType));
        } else if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            StructField[] fields = structType.fields();
            Tuple2[] nestedConversions = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).collect((PartialFunction)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1 extends StructField, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 != null) {
                        String name = A1.name();
                        DataType dataType = A1.dataType();
                        object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), TypeConversion$.MODULE$.com$audienceproject$spark$dynamodb$datasource$TypeConversion$$convertValue(dataType));
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(StructField x1) {
                    StructField structField = x1;
                    boolean bl = structField != null;
                    return bl;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            function1 = this.extractStruct((Seq<Tuple2<String, Function1<Object, Object>>>)Predef$.MODULE$.wrapRefArray((Object[])nestedConversions));
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            function1 = x0$1 -> {
                Boolean bl;
                Object object = x0$1;
                if (object instanceof Boolean) {
                    boolean bl2 = BoxesRunTime.unboxToBoolean((Object)object);
                    bl = BoxesRunTime.boxToBoolean((boolean)bl2);
                } else {
                    bl = null;
                }
                return bl;
            };
        } else if (StringType$.MODULE$.equals(dataType)) {
            function1 = x0$2 -> {
                UTF8String uTF8String;
                Object object = x0$2;
                if (object instanceof String) {
                    String string = (String)object;
                    uTF8String = UTF8String.fromString((String)string);
                } else {
                    uTF8String = null;
                }
                return uTF8String;
            };
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            function1 = x0$3 -> {
                byte[] byArray;
                Object object = x0$3;
                byte[] byArray2 = object instanceof byte[] ? (byArray = (byte[])object) : null;
                return byArray2;
            };
        } else {
            throw new IllegalArgumentException(new StringBuilder(76).append("Spark DataType '").append(sparkType.typeName()).append("' could not be mapped to a corresponding DynamoDB data type.").toString());
        }
        return function1;
    }

    private Function1<Item, Object> nullableGet(Function1<Item, Function1<String, Object>> getter, String attrName) {
        return (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            Item item = x0$1;
            if (item.hasAttribute(attrName)) {
                Object object2;
                try {
                    object2 = ((Function1)getter.apply((Object)item)).apply((Object)attrName);
                }
                catch (NumberFormatException numberFormatException) {
                    object2 = null;
                }
                catch (IncompatibleTypeException incompatibleTypeException) {
                    object2 = null;
                }
                object = object2;
            } else {
                object = null;
            }
            return object;
        };
    }

    private Function1<Object, Object> nullableConvert(Function1<BigDecimal, Object> converter) {
        return (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            Object object2 = x0$1;
            if (object2 instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)object2;
                object = converter.apply((Object)bigDecimal);
            } else {
                object = null;
            }
            return object;
        };
    }

    private Function1<Object, Object> extractArray(Function1<Object, Object> converter) {
        return (Function1 & Serializable & scala.Serializable)x0$1 -> {
            GenericArrayData genericArrayData;
            Object object = x0$1;
            if (object instanceof List) {
                List list = (List)object;
                genericArrayData = new GenericArrayData((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).map(converter, Buffer$.MODULE$.canBuildFrom()));
            } else if (object instanceof Set) {
                Set set = (Set)object;
                genericArrayData = new GenericArrayData(((SetLike)((scala.collection.SetLike)JavaConverters$.MODULE$.asScalaSetConverter(set).asScala()).map(converter, Set$.MODULE$.canBuildFrom())).toSeq());
            } else {
                genericArrayData = null;
            }
            return genericArrayData;
        };
    }

    private Function1<Object, Object> extractMap(Function1<Object, Object> converter) {
        return (Function1 & Serializable & scala.Serializable)x0$1 -> {
            ArrayBasedMapData arrayBasedMapData;
            Object object = x0$1;
            if (object instanceof Map) {
                Map map = (Map)object;
                arrayBasedMapData = ArrayBasedMapData$.MODULE$.apply(map, MODULE$.stringConverter(), converter);
            } else {
                arrayBasedMapData = null;
            }
            return arrayBasedMapData;
        };
    }

    private Function1<Object, Object> extractStruct(Seq<Tuple2<String, Function1<Object, Object>>> conversions) {
        return (Function1 & Serializable & scala.Serializable)x0$1 -> {
            InternalRow internalRow;
            Object object = x0$1;
            if (object instanceof Map) {
                Map map = (Map)object;
                internalRow = InternalRow$.MODULE$.fromSeq((Seq)conversions.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String name = (String)tuple2._1();
                    Function1 conv = (Function1)tuple2._2();
                    Object object = conv.apply(map.get(name));
                    return object;
                }, Seq$.MODULE$.canBuildFrom()));
            } else {
                internalRow = null;
            }
            return internalRow;
        };
    }

    private TypeConversion$() {
        MODULE$ = this;
        this.stringConverter = (Function1 & Serializable & scala.Serializable)value -> UTF8String.fromString((String)((String)value));
    }
}

