/*
 * Decompiled with CFR 0.152.
 */
package com.augustbonds.foundation;

import com.augustbonds.foundation.OutOfBoundsException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;
import java.util.function.Predicate;

public class Array<E>
implements Iterable<E> {
    Object[] contents;
    private int size;
    private int preallocatedSize;

    public Array() {
        this.size = 0;
        this.preallocatedSize = 10;
        this.contents = new Object[this.preallocatedSize];
    }

    private Array(Object[] newContents, int size) {
        this.contents = newContents;
        this.preallocatedSize = newContents.length;
        this.size = size;
    }

    public int size() {
        return this.size;
    }

    public void append(E element) {
        if ((double)this.size > (double)this.preallocatedSize * 0.8) {
            this.grow();
        }
        this.contents[this.size] = element;
        ++this.size;
    }

    public void set(int index, E element) {
        this.checkIndex(index);
        this.contents[index] = element;
    }

    public void remove(int index) {
        this.checkIndex(index);
        if (this.size == 1) {
            this.contents[0] = null;
        }
        Object[] newContents = Arrays.copyOf(this.contents, this.size - 1);
        System.arraycopy(this.contents, index + 1, newContents, index, this.size - 1 - index);
        this.contents = newContents;
        --this.size;
        this.preallocatedSize = this.size;
    }

    public <O> Array<O> map(Function<E, O> toMap) {
        Object[] result = new Object[this.size];
        for (int i = 0; i < this.size; ++i) {
            result[i] = toMap.apply(this.get(i));
        }
        return new Array<E>(result, this.size);
    }

    public E get(int index) {
        this.checkIndex(index);
        return (E)this.contents[index];
    }

    public Array<E> filter(Predicate<E> predicate) {
        Array<Object> filtered = new Array<Object>();
        for (int i = 0; i < this.size; ++i) {
            if (!predicate.test(this.contents[i])) continue;
            filtered.append(this.contents[i]);
        }
        return filtered;
    }

    public void sort(Comparator<E> comparator) {
        new Wrapper().sort(comparator);
    }

    @Override
    public Iterator<E> iterator() {
        return new ArrayIterator();
    }

    private void grow() {
        int newSize = this.size * 2 + 10;
        this.contents = Arrays.copyOf(this.contents, newSize);
        this.preallocatedSize = newSize;
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.size) {
            throw new OutOfBoundsException();
        }
    }

    private void insert(E element, int index) {
        Object[] newContents = Arrays.copyOf(this.contents, this.size + 1);
        newContents[index] = element;
        System.arraycopy(this.contents, index, newContents, index + 1, this.size + 1 - index);
        this.contents = newContents;
        ++this.size;
        this.preallocatedSize = this.size;
    }

    private void clear() {
        this.size = 0;
        this.contents = new Object[10];
        this.preallocatedSize = 10;
    }

    class Wrapper
    implements List<E> {
        private Wrapper subListParent;
        private final int startIndex;
        private int size;

        Wrapper() {
            this.startIndex = 0;
            this.size = Array.this.size();
        }

        Wrapper(int fromIndex, int toIndex) {
            this.startIndex = fromIndex;
            this.size = toIndex - this.startIndex;
        }

        private Wrapper(int fromIndex, int toIndex, Wrapper parent) {
            this(fromIndex, toIndex);
            this.subListParent = parent;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                for (int i = this.startIndex; i < this.startIndex + this.size; ++i) {
                    if (Array.this.contents[i] != null) continue;
                    return true;
                }
            } else {
                for (int i = this.startIndex; i < this.startIndex + this.size; ++i) {
                    if (!o.equals(Array.this.contents[i])) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public Iterator<E> iterator() {
            return new ArrayIterator(this.startIndex, this.startIndex + this.size);
        }

        @Override
        public Object[] toArray() {
            Object[] newArray = new Object[this.size];
            System.arraycopy(Array.this.contents, this.startIndex, newArray, 0, this.size);
            return newArray;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return Arrays.copyOfRange(Array.this.contents, this.startIndex, this.startIndex + this.size, a.getClass());
        }

        @Override
        public boolean add(E e) {
            Array.this.insert(e, this.startIndex + this.size);
            this.incrementSize();
            return true;
        }

        @Override
        public boolean remove(Object o) {
            if (o == null) {
                for (int i = this.startIndex; i < this.startIndex + this.size; ++i) {
                    if (Array.this.contents[i] != null) continue;
                    Array.this.remove(i);
                    this.decrementSize();
                    return true;
                }
            } else {
                for (int i = this.startIndex; i < this.startIndex + this.size; ++i) {
                    if (!o.equals(Array.this.contents[i])) continue;
                    Array.this.remove(i);
                    this.decrementSize();
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return false;
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            return false;
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return false;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return false;
        }

        @Override
        public void clear() {
            Array.this.clear();
        }

        @Override
        public E get(int index) {
            return Array.this.get(this.startIndex + index);
        }

        @Override
        public E set(int index, E element) {
            Array.this.set(this.startIndex + index, element);
            return element;
        }

        @Override
        public void add(int index, E element) {
            Array.this.insert(element, this.startIndex + index);
            this.incrementSize();
        }

        @Override
        public E remove(int index) {
            Object element = Array.this.get(this.startIndex + index);
            Array.this.remove(index);
            this.decrementSize();
            return element;
        }

        @Override
        public int indexOf(Object o) {
            if (o == null) {
                for (int i = this.startIndex; i < this.startIndex + this.size; ++i) {
                    if (Array.this.contents[i] != null) continue;
                    return i;
                }
            } else {
                for (int i = this.startIndex; i < this.startIndex + this.size; ++i) {
                    if (!o.equals(Array.this.contents[i])) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            if (o == null) {
                for (int i = this.startIndex + this.size - 1; i >= this.startIndex; --i) {
                    if (Array.this.contents[i] != null) continue;
                    return i;
                }
            } else {
                for (int i = this.startIndex + this.size - 1; i >= this.startIndex; --i) {
                    if (!o.equals(Array.this.contents[i])) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public ListIterator<E> listIterator() {
            return new ArrayIterator();
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return new ArrayIterator(this.startIndex + index);
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            return new Wrapper(this.startIndex + fromIndex, this.startIndex + toIndex, this);
        }

        private void decrementSize() {
            --this.size;
            if (this.subListParent == null) {
                Array.this.size--;
            } else {
                this.subListParent.decrementSize();
            }
        }

        private void incrementSize() {
            ++this.size;
            if (this.subListParent == null) {
                Array.this.size++;
            } else {
                this.subListParent.incrementSize();
            }
        }
    }

    private class ArrayIterator
    implements ListIterator<E> {
        final int startIndex;
        int index;
        int size;

        private ArrayIterator() {
            this.startIndex = 0;
            this.index = 0;
            this.size = Array.this.size();
        }

        private ArrayIterator(int index) {
            this.startIndex = 0;
            this.index = index;
            this.size = Array.this.size();
        }

        private ArrayIterator(int fromIndex, int toIndex) {
            this.index = this.startIndex = fromIndex;
            this.size = toIndex - this.startIndex;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.startIndex + this.size;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new OutOfBoundsException("Called next() on empty iterator.");
            }
            return Array.this.get(this.index++);
        }

        @Override
        public boolean hasPrevious() {
            return this.index > this.startIndex;
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new OutOfBoundsException("Called previous() on empty iterator.");
            }
            return Array.this.get(--this.index);
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            this.checkIndex(this.index);
            Array.this.remove(this.index);
            --this.size;
        }

        @Override
        public void set(E e) {
            this.checkIndex(this.index - 1);
            Array.this.set(this.index - 1, e);
        }

        @Override
        public void add(E e) {
            Array.this.insert(e, this.startIndex + this.size);
            ++this.size;
        }

        private void checkIndex(int index) {
            if (index < this.startIndex || index >= this.startIndex + this.size) {
                throw new OutOfBoundsException();
            }
        }
    }
}

