/*
 * Decompiled with CFR 0.152.
 */
package com.augustbonds.foundation;

import com.augustbonds.foundation.OutOfBoundsException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;

public class Dictionary<K, V>
implements Iterable<Entry<K, V>> {
    private final Map<K, V> contents = new HashMap();

    public V get(K key) {
        return this.contents.get(key);
    }

    public void put(K key, V value) {
        this.contents.put(key, value);
    }

    public void forEach(BiConsumer<K, V> consumer) {
        this.contents.forEach(consumer);
    }

    public int size() {
        return this.contents.size();
    }

    @Override
    public Iterator<Entry<K, V>> iterator() {
        return new DictionaryIterator();
    }

    private class DictionaryEntry
    implements Entry<K, V> {
        private final Map.Entry<K, V> entry;

        private DictionaryEntry(Map.Entry<K, V> entry) {
            this.entry = entry;
        }

        @Override
        public K getKey() {
            return this.entry.getKey();
        }

        @Override
        public V getValue() {
            return this.entry.getValue();
        }
    }

    private class DictionaryIterator
    implements Iterator<Entry<K, V>> {
        private final Iterator<Map.Entry<K, V>> iterator;

        private DictionaryIterator() {
            this.iterator = Dictionary.this.contents.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Entry<K, V> next() {
            try {
                Map.Entry next = this.iterator.next();
                return new DictionaryEntry(next);
            }
            catch (NoSuchElementException e) {
                throw new OutOfBoundsException("Called next() on empty iterator.");
            }
        }
    }

    public static interface Entry<K, V> {
        public K getKey();

        public V getValue();
    }
}

