/*
 * Decompiled with CFR 0.152.
 */
package COSE;

import COSE.CoseException;
import COSE.KeyKeys;
import COSE.OneKey;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X9Curve;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;

public class ECPrivateKey
implements java.security.interfaces.ECPrivateKey {
    ECPoint point;
    String algorithm;
    ECParameterSpec ecParameterSpec;
    BigInteger privateKey;
    byte[] encodedKey;

    public ECPrivateKey(OneKey oneKey) throws CoseException, IOException {
        int keySize;
        ASN1ObjectIdentifier curveOID;
        org.bouncycastle.math.ec.ECPoint pubPoint;
        X9ECParameters p = oneKey.GetCurve();
        ECDomainParameters parameters = new ECDomainParameters(p.getCurve(), p.getG(), p.getN(), p.getH());
        if (oneKey.get(KeyKeys.EC2_Y).getType() == CBORType.Boolean) {
            byte[] X = oneKey.get(KeyKeys.EC2_X.AsCBOR()).GetByteString();
            byte[] rgb = new byte[X.length + 1];
            System.arraycopy(X, 0, rgb, 1, X.length);
            rgb[0] = (byte)(2 + (oneKey.get(KeyKeys.EC2_Y).AsBoolean() ? 1 : 0));
            pubPoint = p.getCurve().decodePoint(rgb);
            this.point = new ECPoint(this.point.getAffineX(), this.point.getAffineY());
        } else {
            this.point = new ECPoint(new BigInteger(1, oneKey.get(KeyKeys.EC2_X).GetByteString()), new BigInteger(1, oneKey.get(KeyKeys.EC2_Y).GetByteString()));
            pubPoint = p.getCurve().createPoint(new BigInteger(1, oneKey.get(KeyKeys.EC2_X).GetByteString()), new BigInteger(1, oneKey.get(KeyKeys.EC2_Y).GetByteString()));
        }
        ECPublicKeyParameters pub = new ECPublicKeyParameters(pubPoint, parameters);
        ECPrivateKeyParameters priv = new ECPrivateKeyParameters(new BigInteger(1, oneKey.get(KeyKeys.EC2_D.AsCBOR()).GetByteString()), parameters);
        this.algorithm = "EC";
        CBORObject curve = oneKey.get(KeyKeys.EC2_Curve);
        if (curve.equals(KeyKeys.EC2_P256)) {
            curveOID = SECObjectIdentifiers.secp256r1;
            keySize = 256;
        } else if (curve.equals(KeyKeys.EC2_P384)) {
            curveOID = SECObjectIdentifiers.secp384r1;
            keySize = 384;
        } else if (curve.equals(KeyKeys.EC2_P521)) {
            curveOID = SECObjectIdentifiers.secp521r1;
            keySize = 521;
        } else {
            throw new CoseException("Unrecognized Curve");
        }
        this.privateKey = new BigInteger(1, oneKey.get(KeyKeys.EC2_D).GetByteString());
        ECFieldFp field = new ECFieldFp(p.getCurve().getField().getCharacteristic());
        EllipticCurve crv = new EllipticCurve(field, p.getCurve().getA().toBigInteger(), p.getCurve().getB().toBigInteger());
        ECPoint pt = new ECPoint(p.getG().getRawXCoord().toBigInteger(), p.getG().getRawYCoord().toBigInteger());
        this.ecParameterSpec = new ECParameterSpec(crv, pt, p.getN(), p.getH().intValue());
        AlgorithmIdentifier alg = new AlgorithmIdentifier(X9Curve.id_ecPublicKey, (ASN1Encodable)curveOID);
        org.bouncycastle.asn1.sec.ECPrivateKey asnPrivate = new org.bouncycastle.asn1.sec.ECPrivateKey(keySize, this.privateKey);
        byte[] x = asnPrivate.getEncoded();
        PrivateKeyInfo asnPrivateX = new PrivateKeyInfo(alg, (ASN1Encodable)asnPrivate);
        this.encodedKey = asnPrivateX.getEncoded();
    }

    @Override
    public BigInteger getS() {
        return this.privateKey;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        return this.encodedKey;
    }

    @Override
    public ECParameterSpec getParams() {
        return this.ecParameterSpec;
    }
}

