/*
 * Decompiled with CFR 0.152.
 */
package COSE;

import COSE.CoseException;
import java.util.ArrayList;
import java.util.Arrays;

public class ASN1 {
    public static final byte[] Oid_secp256r1 = new byte[]{6, 8, 42, -122, 72, -50, 61, 3, 1, 7};
    public static final byte[] Oid_secp384r1 = new byte[]{6, 5, 43, -127, 4, 0, 34};
    public static final byte[] Oid_secp521r1 = new byte[]{6, 5, 43, -127, 4, 0, 35};
    public static final byte[] oid_ecPublicKey = new byte[]{6, 7, 42, -122, 72, -50, 61, 2, 1};
    public static final byte[] Oid_X25519 = new byte[]{6, 3, 43, 101, 110};
    public static final byte[] Oid_X448 = new byte[]{6, 3, 43, 101, 111};
    public static final byte[] Oid_Ed25519 = new byte[]{6, 3, 43, 101, 112};
    public static final byte[] Oid_Ed448 = new byte[]{6, 3, 43, 101, 113};
    private static final byte[] SequenceTag = new byte[]{48};
    private static final byte[] OctetStringTag = new byte[]{4};
    private static final byte[] BitStringTag = new byte[]{3};

    public static byte[] EncodeSubjectPublicKeyInfo(byte[] algorithm, byte[] keyBytes) throws CoseException {
        try {
            ArrayList<byte[]> xxx = new ArrayList<byte[]>();
            xxx.add(algorithm);
            xxx.add(new byte[]{3});
            xxx.add(ASN1.ComputeLength(keyBytes.length + 1));
            xxx.add(new byte[]{0});
            xxx.add(keyBytes);
            return ASN1.Sequence(xxx);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.print(e.toString());
            throw e;
        }
    }

    public static byte[] EncodeEcPrivateKey(byte[] oid, byte[] keyBytes, byte[] spki) throws CoseException {
        ArrayList<byte[]> xxx = new ArrayList<byte[]>();
        xxx.add(new byte[]{2, 1, 1});
        xxx.add(OctetStringTag);
        xxx.add(ASN1.ComputeLength(keyBytes.length));
        xxx.add(keyBytes);
        xxx.add(new byte[]{-96});
        xxx.add(ASN1.ComputeLength(oid.length));
        xxx.add(oid);
        if (spki != null) {
            xxx.add(new byte[]{-95});
            xxx.add(ASN1.ComputeLength(spki.length + 1));
            xxx.add(new byte[]{0});
            xxx.add(spki);
        }
        byte[] ecPrivateKey = ASN1.Sequence(xxx);
        return ecPrivateKey;
    }

    public static ArrayList<TagValue> DecodeSubjectPublicKeyInfo(byte[] encoding) throws CoseException {
        TagValue spki = ASN1.DecodeCompound(0, encoding);
        if (spki.tag != 48) {
            throw new CoseException("Invalid SPKI");
        }
        ArrayList<TagValue> tvl = spki.list;
        if (tvl.size() != 2) {
            throw new CoseException("Invalid SPKI");
        }
        if (tvl.get((int)0).tag != 48) {
            throw new CoseException("Invalid SPKI");
        }
        if (tvl.get((int)0).list.isEmpty() || tvl.get((int)0).list.size() > 2) {
            throw new CoseException("Invalid SPKI");
        }
        if (tvl.get((int)0).list.get((int)0).tag != 6) {
            throw new CoseException("Invalid SPKI");
        }
        if (tvl.get((int)1).tag != 3) {
            throw new CoseException("Invalid SPKI");
        }
        return tvl;
    }

    public static TagValue DecodeCompound(int offset, byte[] encoding) throws CoseException {
        ArrayList<TagValue> result = new ArrayList<TagValue>();
        byte retTag = encoding[offset];
        if ((encoding[offset] & 0x20) != 32) {
            throw new CoseException("Invalid structure");
        }
        int[] l = ASN1.DecodeLength(offset + 1, encoding);
        int sequenceLength = l[1];
        if (offset + sequenceLength > encoding.length) {
            throw new CoseException("Invalid sequence");
        }
        offset += l[0] + 1;
        while (sequenceLength > 0) {
            byte tag = encoding[offset];
            l = ASN1.DecodeLength(offset + 1, encoding);
            if (l[1] > sequenceLength) {
                throw new CoseException("Invalid sequence");
            }
            if ((tag & 0x20) != 0) {
                result.add(ASN1.DecodeCompound(offset, encoding));
                offset += 1 + l[0] + l[1];
                sequenceLength -= 1 + l[0] + l[1];
                continue;
            }
            if (tag == 6) {
                result.add(new TagValue((int)tag, Arrays.copyOfRange(encoding, offset, offset + l[1] + l[0] + 1)));
            } else {
                result.add(new TagValue((int)tag, Arrays.copyOfRange(encoding, offset + l[0] + 1, offset + 1 + l[0] + l[1])));
            }
            offset += 1 + l[0] + l[1];
            sequenceLength -= 1 + l[0] + l[1];
        }
        return new TagValue((int)retTag, result);
    }

    public static byte[] EncodePKCS8(byte[] algorithm, byte[] keyBytes, byte[] spki) throws CoseException {
        try {
            ArrayList<byte[]> xxx = new ArrayList<byte[]>();
            xxx.add(new byte[]{2, 1, 0});
            xxx.add(algorithm);
            xxx.add(OctetStringTag);
            xxx.add(ASN1.ComputeLength(keyBytes.length));
            xxx.add(keyBytes);
            return ASN1.Sequence(xxx);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.print(e.toString());
            throw e;
        }
    }

    public static ArrayList<TagValue> DecodePKCS8(byte[] encodedData) throws CoseException {
        TagValue pkcs8 = ASN1.DecodeCompound(0, encodedData);
        if (pkcs8.tag != 48) {
            throw new CoseException("Invalid PKCS8 structure");
        }
        ArrayList<TagValue> retValue = pkcs8.list;
        if (retValue.size() != 3 && retValue.size() != 4) {
            throw new CoseException("Invalid PKCS8 structure");
        }
        if (retValue.get((int)0).tag != 2 && retValue.get((int)0).value[0] != 0) {
            throw new CoseException("Invalid PKCS8 structure");
        }
        if (retValue.get((int)1).tag != 48) {
            throw new CoseException("Invalid PKCS8 structure");
        }
        if (retValue.get((int)1).list.isEmpty() || retValue.get((int)1).list.size() > 2) {
            throw new CoseException("Invalid PKCS8 structure");
        }
        if (retValue.get((int)1).list.get((int)0).tag != 6) {
            throw new CoseException("Invalid PKCS8 structure");
        }
        if (retValue.get((int)2).tag != 4) {
            throw new CoseException("Invalid PKCS8 structure");
        }
        if (retValue.size() == 4 && retValue.get((int)3).tag != 160) {
            throw new CoseException("Invalid PKCS8 structure");
        }
        byte[] pk = retValue.get((int)2).value;
        TagValue pkd = ASN1.DecodeCompound(0, pk);
        ArrayList<TagValue> pkdl = pkd.list;
        if (pkd.tag != 48) {
            throw new CoseException("Invalid ECPrivateKey");
        }
        if (pkdl.size() < 2 || pkdl.size() > 4) {
            throw new CoseException("Invalid ECPrivateKey");
        }
        if (pkdl.get((int)0).tag != 2 && retValue.get((int)0).value[0] != 1) {
            throw new CoseException("Invalid ECPrivateKey");
        }
        if (pkdl.get((int)1).tag != 4) {
            throw new CoseException("Invalid ECPrivateKey");
        }
        if (pkdl.size() > 2 && ((pkdl.get((int)2).tag & 0xFF) != 160 ? pkdl.size() != 3 || (pkdl.get((int)2).tag & 0xFF) != 161 : pkdl.size() == 4 && (pkdl.get((int)3).tag & 0xFF) != 161)) {
            throw new CoseException("Invalid ECPrivateKey");
        }
        retValue.get((int)2).list = pkdl;
        retValue.get((int)2).value = null;
        retValue.get((int)2).tag = 48;
        return retValue;
    }

    public static byte[] EncodeSignature(byte[] r, byte[] s) throws CoseException {
        ArrayList<byte[]> x = new ArrayList<byte[]>();
        x.add(ASN1.UnsignedInteger(r));
        x.add(ASN1.UnsignedInteger(s));
        return ASN1.Sequence(x);
    }

    public static byte[] EncodeOctetString(byte[] data) throws CoseException {
        ArrayList<byte[]> x = new ArrayList<byte[]>();
        x.add(OctetStringTag);
        x.add(ASN1.ComputeLength(data.length));
        x.add(data);
        return ASN1.ToBytes(x);
    }

    public static byte[] AlgorithmIdentifier(byte[] oid, byte[] params) throws CoseException {
        ArrayList<byte[]> xxx = new ArrayList<byte[]>();
        xxx.add(oid);
        if (params != null) {
            xxx.add(params);
        }
        return ASN1.Sequence(xxx);
    }

    private static byte[] Sequence(ArrayList<byte[]> members) throws CoseException {
        byte[] y = ASN1.ToBytes(members);
        ArrayList<byte[]> x = new ArrayList<byte[]>();
        x.add(SequenceTag);
        x.add(ASN1.ComputeLength(y.length));
        x.add(y);
        return ASN1.ToBytes(x);
    }

    private static byte[] UnsignedInteger(byte[] i) throws CoseException {
        int offset;
        int pad = 0;
        for (offset = 0; offset < i.length && i[offset] == 0; ++offset) {
        }
        if (offset == i.length) {
            return new byte[]{2, 1, 0};
        }
        if ((i[offset] & 0x80) != 0) {
            ++pad;
        }
        int length = i.length - offset;
        byte[] der = new byte[2 + length + pad];
        der[0] = 2;
        der[1] = (byte)(length + pad);
        System.arraycopy(i, offset, der, 2 + pad, length);
        return der;
    }

    private static byte[] ComputeLength(int x) throws CoseException {
        if (x <= 127) {
            return new byte[]{(byte)x};
        }
        if (x < 256) {
            return new byte[]{-127, (byte)x};
        }
        throw new CoseException("Error in ASN1.GetLength");
    }

    private static int[] DecodeLength(int offset, byte[] data) throws CoseException {
        if ((data[offset] & 0x80) == 0) {
            return new int[]{1, data[offset]};
        }
        if (data[offset] == 128) {
            throw new CoseException("Indefinite length encoding not supported");
        }
        int length = data[offset] & 0x7F;
        int retValue = 0;
        for (int i = 0; i < length; ++i) {
            retValue = retValue * 256 + (data[i + offset + 1] & 0xFF);
        }
        return new int[]{length + 1, retValue};
    }

    private static byte[] ToBytes(ArrayList<byte[]> x) {
        int l = 0;
        l = x.stream().map(r -> ((byte[])r).length).reduce(l, Integer::sum);
        byte[] b = new byte[l];
        l = 0;
        for (byte[] r2 : x) {
            System.arraycopy(r2, 0, b, l, r2.length);
            l += r2.length;
        }
        return b;
    }

    public static class TagValue {
        public int tag;
        public byte[] value;
        public ArrayList<TagValue> list;

        public TagValue(int tagIn, byte[] valueIn) {
            this.tag = tagIn;
            this.value = valueIn;
        }

        public TagValue(int tagIn, ArrayList<TagValue> listIn) {
            this.tag = tagIn;
            this.list = listIn;
        }
    }
}

