/*
 * Decompiled with CFR 0.152.
 */
package COSE;

import COSE.CoseException;
import COSE.EncryptCommon;
import COSE.MessageTag;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;

public class Encrypt0Message
extends EncryptCommon {
    public Encrypt0Message() {
        this(true, true);
    }

    public Encrypt0Message(boolean emitTag, boolean emitContent) {
        this.context = "Encrypt0";
        this.messageTag = MessageTag.Encrypt0;
        this.emitTag = emitTag;
        this.emitContent = emitContent;
    }

    @Override
    public void DecodeFromCBORObject(CBORObject obj) throws CoseException {
        if (obj.size() != 3) {
            throw new CoseException("Invalid Encrypt0 structure");
        }
        if (obj.get(0).getType() == CBORType.ByteString) {
            if (obj.get(0).GetByteString().length == 0) {
                this.rgbProtected = new byte[0];
                this.objProtected = CBORObject.NewMap();
            } else {
                this.rgbProtected = obj.get(0).GetByteString();
                this.objProtected = CBORObject.DecodeFromBytes((byte[])this.rgbProtected);
                if (this.objProtected.getType() != CBORType.Map) {
                    throw new CoseException("Invalid Encrypt0 structure");
                }
            }
        } else {
            throw new CoseException("Invalid Encrypt0 structure");
        }
        if (obj.get(1).getType() != CBORType.Map) {
            throw new CoseException("Invalid Encrypt0 structure");
        }
        this.objUnprotected = obj.get(1);
        if (obj.get(2).getType() == CBORType.ByteString) {
            this.rgbEncrypt = obj.get(2).GetByteString();
        } else if (!obj.get(2).isNull()) {
            throw new CoseException("Invalid Encrypt0 structure");
        }
    }

    @Override
    protected CBORObject EncodeCBORObject() throws CoseException {
        if (this.rgbEncrypt == null) {
            throw new CoseException("Encrypt function not called");
        }
        CBORObject obj = CBORObject.NewArray();
        if (this.objProtected.size() > 0) {
            obj.Add((Object)this.objProtected.EncodeToBytes());
        } else {
            obj.Add(CBORObject.FromObject((byte[])new byte[0]));
        }
        obj.Add(this.objUnprotected);
        if (this.emitContent) {
            obj.Add((Object)this.rgbEncrypt);
        } else {
            obj.Add(CBORObject.Null);
        }
        return obj;
    }

    public byte[] decrypt(byte[] rgbKey) throws CoseException {
        return super.decryptWithKey(rgbKey);
    }

    public void encrypt(byte[] rgbKey) throws CoseException, IllegalStateException {
        super.encryptWithKey(rgbKey);
    }
}

