/*
 * Decompiled with CFR 0.152.
 */
package com.aurelhubert.ahbottomnavigation;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.Snackbar;
import android.support.design.widget.TabLayout;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorCompat;
import android.support.v4.view.ViewPropertyAnimatorUpdateListener;
import android.support.v4.view.animation.LinearOutSlowInInterpolator;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import com.aurelhubert.ahbottomnavigation.AHHelper;
import com.aurelhubert.ahbottomnavigation.R;
import com.aurelhubert.ahbottomnavigation.VerticalScrollingBehavior;

public class AHBottomNavigationBehavior<V extends View>
extends VerticalScrollingBehavior<V> {
    private static final Interpolator INTERPOLATOR = new LinearOutSlowInInterpolator();
    private static final int ANIM_DURATION = 300;
    private int mTabLayoutId;
    private boolean hidden = false;
    private ViewPropertyAnimatorCompat mTranslationAnimator;
    private TabLayout mTabLayout;
    private Snackbar.SnackbarLayout snackbarLayout;
    private View mTabsHolder;
    private int mSnackbarHeight = -1;
    private float targetOffset = 0.0f;

    public AHBottomNavigationBehavior() {
    }

    public AHBottomNavigationBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AHBottomNavigationBehavior_Params);
        this.mTabLayoutId = a.getResourceId(R.styleable.AHBottomNavigationBehavior_Params_tabLayoutId, -1);
        a.recycle();
    }

    public boolean onLayoutChild(CoordinatorLayout parent, V child, int layoutDirection) {
        boolean layoutChild = super.onLayoutChild(parent, child, layoutDirection);
        if (this.mTabLayout == null && this.mTabLayoutId != -1) {
            this.mTabLayout = this.findTabLayout((View)child);
            this.getTabsHolder();
        }
        return layoutChild;
    }

    private TabLayout findTabLayout(View child) {
        if (this.mTabLayoutId == 0) {
            return null;
        }
        return (TabLayout)child.findViewById(this.mTabLayoutId);
    }

    public boolean onDependentViewChanged(CoordinatorLayout parent, V child, View dependency) {
        return super.onDependentViewChanged(parent, child, dependency);
    }

    public void onDependentViewRemoved(CoordinatorLayout parent, V child, View dependency) {
        super.onDependentViewRemoved(parent, child, dependency);
    }

    public boolean layoutDependsOn(CoordinatorLayout parent, V child, View dependency) {
        this.updateSnackbar((View)child, dependency);
        return super.layoutDependsOn(parent, child, dependency);
    }

    @Override
    public void onNestedVerticalOverScroll(CoordinatorLayout coordinatorLayout, V child, int direction, int currentOverScroll, int totalOverScroll) {
    }

    @Override
    public void onDirectionNestedPreScroll(CoordinatorLayout coordinatorLayout, V child, View target, int dx, int dy, int[] consumed, int scrollDirection) {
        this.handleDirection(child, scrollDirection);
    }

    private void handleDirection(V child, int scrollDirection) {
        if (scrollDirection == -1 && this.hidden) {
            this.hidden = false;
            this.animateOffset(child, 0);
        } else if (scrollDirection == 1 && !this.hidden) {
            this.hidden = true;
            this.animateOffset(child, child.getHeight());
        }
    }

    @Override
    protected boolean onNestedDirectionFling(CoordinatorLayout coordinatorLayout, V child, View target, float velocityX, float velocityY, int scrollDirection) {
        this.handleDirection(child, scrollDirection);
        return true;
    }

    private void animateOffset(V child, int offset) {
        this.ensureOrCancelAnimator(child);
        this.mTranslationAnimator.translationY((float)offset).start();
        this.animateTabsHolder(offset);
        this.animateSnackBar(offset);
    }

    private void animateTabsHolder(int offset) {
        if (this.mTabsHolder != null) {
            offset = offset > 0 ? 0 : 1;
            ViewCompat.animate((View)this.mTabsHolder).alpha((float)offset).setDuration(300L).start();
        }
    }

    private void animateSnackBar(int offset) {
        if (this.snackbarLayout != null) {
            AHHelper.updateBottomMargin((View)this.snackbarLayout, offset > 0 ? 0 : offset, offset > 0 ? offset : 0, 300);
        }
    }

    private void ensureOrCancelAnimator(V child) {
        if (this.mTranslationAnimator == null) {
            this.mTranslationAnimator = ViewCompat.animate(child);
            this.mTranslationAnimator.setDuration(300L);
            this.mTranslationAnimator.setUpdateListener(new ViewPropertyAnimatorUpdateListener(){

                public void onAnimationUpdate(View view) {
                    AHBottomNavigationBehavior.this.targetOffset = view.getTranslationY();
                    if (AHBottomNavigationBehavior.this.snackbarLayout != null && AHBottomNavigationBehavior.this.snackbarLayout.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                        ViewGroup.MarginLayoutParams p = (ViewGroup.MarginLayoutParams)AHBottomNavigationBehavior.this.snackbarLayout.getLayoutParams();
                        p.setMargins(p.leftMargin, p.topMargin, p.rightMargin, (int)AHBottomNavigationBehavior.this.targetOffset);
                        AHBottomNavigationBehavior.this.snackbarLayout.requestLayout();
                    }
                }
            });
            this.mTranslationAnimator.setInterpolator(INTERPOLATOR);
        } else {
            this.mTranslationAnimator.cancel();
        }
    }

    private void getTabsHolder() {
        if (this.mTabLayout != null) {
            this.mTabsHolder = this.mTabLayout.getChildAt(0);
        }
    }

    public static <V extends View> AHBottomNavigationBehavior<V> from(V view) {
        ViewGroup.LayoutParams params = view.getLayoutParams();
        if (!(params instanceof CoordinatorLayout.LayoutParams)) {
            throw new IllegalArgumentException("The view is not a child of CoordinatorLayout");
        }
        CoordinatorLayout.Behavior behavior = ((CoordinatorLayout.LayoutParams)params).getBehavior();
        if (!(behavior instanceof AHBottomNavigationBehavior)) {
            throw new IllegalArgumentException("The view is not associated with AHBottomNavigationBehavior");
        }
        return (AHBottomNavigationBehavior)behavior;
    }

    public void setTabLayoutId(int tabId) {
        this.mTabLayoutId = tabId;
    }

    public void resetOffset(V view) {
        this.animateOffset(view, 0);
    }

    public void updateSnackbar(View child, View dependency) {
        if (dependency != null && dependency instanceof Snackbar.SnackbarLayout) {
            this.snackbarLayout = (Snackbar.SnackbarLayout)dependency;
            if (this.mSnackbarHeight == -1) {
                this.mSnackbarHeight = dependency.getHeight();
            }
            int targetMargin = (int)((float)(this.mSnackbarHeight + child.getMeasuredHeight()) - child.getTranslationY());
            if (Build.VERSION.SDK_INT < 21) {
                child.bringToFront();
            }
            if (dependency.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                ViewGroup.MarginLayoutParams p = (ViewGroup.MarginLayoutParams)dependency.getLayoutParams();
                p.setMargins(p.leftMargin, p.topMargin, p.rightMargin, targetMargin);
                dependency.requestLayout();
            }
        }
    }
}

