/*
 * Decompiled with CFR 0.152.
 */
package com.aurelhubert.ahbottomnavigation;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.FloatingActionButton;
import android.support.design.widget.Snackbar;
import android.support.design.widget.TabLayout;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorCompat;
import android.support.v4.view.ViewPropertyAnimatorUpdateListener;
import android.support.v4.view.animation.LinearOutSlowInInterpolator;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import com.aurelhubert.ahbottomnavigation.R;
import com.aurelhubert.ahbottomnavigation.VerticalScrollingBehavior;

public class AHBottomNavigationBehavior<V extends View>
extends VerticalScrollingBehavior<V> {
    private static final Interpolator INTERPOLATOR = new LinearOutSlowInInterpolator();
    private static final int ANIM_DURATION = 300;
    private int mTabLayoutId;
    private boolean hidden = false;
    private ViewPropertyAnimatorCompat translationAnimator;
    private ObjectAnimator translationObjectAnimator;
    private TabLayout mTabLayout;
    private Snackbar.SnackbarLayout snackbarLayout;
    private FloatingActionButton floatingActionButton;
    private int mSnackbarHeight = -1;
    private boolean fabBottomMarginInitialized = false;
    private float targetOffset = 0.0f;
    private float fabTargetOffset = 0.0f;
    private float fabDefaultBottomMargin = 0.0f;
    private float snackBarY = 0.0f;

    public AHBottomNavigationBehavior() {
    }

    public AHBottomNavigationBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AHBottomNavigationBehavior_Params);
        this.mTabLayoutId = a.getResourceId(R.styleable.AHBottomNavigationBehavior_Params_tabLayoutId, -1);
        a.recycle();
    }

    public boolean onLayoutChild(CoordinatorLayout parent, V child, int layoutDirection) {
        boolean layoutChild = super.onLayoutChild(parent, child, layoutDirection);
        if (this.mTabLayout == null && this.mTabLayoutId != -1) {
            this.mTabLayout = this.findTabLayout((View)child);
        }
        return layoutChild;
    }

    private TabLayout findTabLayout(View child) {
        if (this.mTabLayoutId == 0) {
            return null;
        }
        return (TabLayout)child.findViewById(this.mTabLayoutId);
    }

    public boolean onDependentViewChanged(CoordinatorLayout parent, V child, View dependency) {
        return super.onDependentViewChanged(parent, child, dependency);
    }

    public void onDependentViewRemoved(CoordinatorLayout parent, V child, View dependency) {
        super.onDependentViewRemoved(parent, child, dependency);
    }

    public boolean layoutDependsOn(CoordinatorLayout parent, V child, View dependency) {
        this.updateSnackbar((View)child, dependency);
        this.updateFloatingActionButton(dependency);
        return super.layoutDependsOn(parent, child, dependency);
    }

    @Override
    public void onNestedVerticalOverScroll(CoordinatorLayout coordinatorLayout, V child, int direction, int currentOverScroll, int totalOverScroll) {
    }

    @Override
    public void onDirectionNestedPreScroll(CoordinatorLayout coordinatorLayout, V child, View target, int dx, int dy, int[] consumed, int scrollDirection) {
        this.handleDirection(child, scrollDirection);
    }

    private void handleDirection(V child, int scrollDirection) {
        if (scrollDirection == -1 && this.hidden) {
            this.hidden = false;
            this.animateOffset(child, 0);
        } else if (scrollDirection == 1 && !this.hidden) {
            this.hidden = true;
            this.animateOffset(child, child.getHeight());
        }
    }

    @Override
    protected boolean onNestedDirectionFling(CoordinatorLayout coordinatorLayout, V child, View target, float velocityX, float velocityY, int scrollDirection) {
        this.handleDirection(child, scrollDirection);
        return true;
    }

    private void animateOffset(V child, int offset) {
        if (Build.VERSION.SDK_INT < 19) {
            this.ensureOrCancelObjectAnimation(child, offset);
            this.translationObjectAnimator.start();
        } else {
            this.ensureOrCancelAnimator(child);
            this.translationAnimator.translationY((float)offset).start();
        }
    }

    private void ensureOrCancelAnimator(V child) {
        if (this.translationAnimator == null) {
            this.translationAnimator = ViewCompat.animate(child);
            this.translationAnimator.setDuration(300L);
            this.translationAnimator.setUpdateListener(new ViewPropertyAnimatorUpdateListener(){

                public void onAnimationUpdate(View view) {
                    ViewGroup.MarginLayoutParams p;
                    if (AHBottomNavigationBehavior.this.snackbarLayout != null && AHBottomNavigationBehavior.this.snackbarLayout.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                        AHBottomNavigationBehavior.this.targetOffset = (float)view.getMeasuredHeight() - view.getTranslationY();
                        p = (ViewGroup.MarginLayoutParams)AHBottomNavigationBehavior.this.snackbarLayout.getLayoutParams();
                        p.setMargins(p.leftMargin, p.topMargin, p.rightMargin, (int)AHBottomNavigationBehavior.this.targetOffset);
                        AHBottomNavigationBehavior.this.snackbarLayout.requestLayout();
                    }
                    if (AHBottomNavigationBehavior.this.floatingActionButton != null && AHBottomNavigationBehavior.this.floatingActionButton.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                        p = (ViewGroup.MarginLayoutParams)AHBottomNavigationBehavior.this.floatingActionButton.getLayoutParams();
                        AHBottomNavigationBehavior.this.fabTargetOffset = AHBottomNavigationBehavior.this.fabDefaultBottomMargin - view.getTranslationY() + AHBottomNavigationBehavior.this.snackBarY;
                        p.setMargins(p.leftMargin, p.topMargin, p.rightMargin, (int)AHBottomNavigationBehavior.this.fabTargetOffset);
                        AHBottomNavigationBehavior.this.floatingActionButton.requestLayout();
                    }
                }
            });
            this.translationAnimator.setInterpolator(INTERPOLATOR);
        } else {
            this.translationAnimator.cancel();
        }
    }

    private void ensureOrCancelObjectAnimation(V child, int offset) {
        if (this.translationObjectAnimator != null) {
            Log.d((String)"AHBottomNav", (String)"ensureOrCancelObjectAnimation: CANCEL");
            this.translationObjectAnimator.cancel();
        }
        Log.d((String)"AHBottomNav", (String)"ensureOrCancelObjectAnimation: NEW");
        this.translationObjectAnimator = ObjectAnimator.ofFloat(child, (Property)View.TRANSLATION_Y, (float[])new float[]{offset});
        this.translationObjectAnimator.setDuration(300L);
        this.translationObjectAnimator.setInterpolator((TimeInterpolator)INTERPOLATOR);
        this.translationObjectAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener((View)child){
            final /* synthetic */ View val$child;
            {
                this.val$child = view;
            }

            public void onAnimationUpdate(ValueAnimator animation) {
                ViewGroup.MarginLayoutParams p;
                if (AHBottomNavigationBehavior.this.snackbarLayout != null && AHBottomNavigationBehavior.this.snackbarLayout.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                    AHBottomNavigationBehavior.this.targetOffset = (float)this.val$child.getMeasuredHeight() - this.val$child.getTranslationY();
                    p = (ViewGroup.MarginLayoutParams)AHBottomNavigationBehavior.this.snackbarLayout.getLayoutParams();
                    p.setMargins(p.leftMargin, p.topMargin, p.rightMargin, (int)AHBottomNavigationBehavior.this.targetOffset);
                    AHBottomNavigationBehavior.this.snackbarLayout.requestLayout();
                }
                if (AHBottomNavigationBehavior.this.floatingActionButton != null && AHBottomNavigationBehavior.this.floatingActionButton.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                    p = (ViewGroup.MarginLayoutParams)AHBottomNavigationBehavior.this.floatingActionButton.getLayoutParams();
                    AHBottomNavigationBehavior.this.fabTargetOffset = AHBottomNavigationBehavior.this.fabDefaultBottomMargin - this.val$child.getTranslationY() + AHBottomNavigationBehavior.this.snackBarY;
                    p.setMargins(p.leftMargin, p.topMargin, p.rightMargin, (int)AHBottomNavigationBehavior.this.fabTargetOffset);
                    AHBottomNavigationBehavior.this.floatingActionButton.requestLayout();
                    Log.d((String)"AHBottomNav", (String)("onLayoutChange: " + AHBottomNavigationBehavior.this.fabTargetOffset + " / " + AHBottomNavigationBehavior.this.fabDefaultBottomMargin + " / " + this.val$child.getTranslationY() + " / " + AHBottomNavigationBehavior.this.snackBarY));
                }
            }
        });
    }

    public static <V extends View> AHBottomNavigationBehavior<V> from(V view) {
        ViewGroup.LayoutParams params = view.getLayoutParams();
        if (!(params instanceof CoordinatorLayout.LayoutParams)) {
            throw new IllegalArgumentException("The view is not a child of CoordinatorLayout");
        }
        CoordinatorLayout.Behavior behavior = ((CoordinatorLayout.LayoutParams)params).getBehavior();
        if (!(behavior instanceof AHBottomNavigationBehavior)) {
            throw new IllegalArgumentException("The view is not associated with AHBottomNavigationBehavior");
        }
        return (AHBottomNavigationBehavior)behavior;
    }

    public void setTabLayoutId(int tabId) {
        this.mTabLayoutId = tabId;
    }

    public void resetOffset(V view) {
        this.animateOffset(view, 0);
    }

    public void updateSnackbar(final View child, View dependency) {
        if (dependency != null && dependency instanceof Snackbar.SnackbarLayout) {
            this.snackbarLayout = (Snackbar.SnackbarLayout)dependency;
            if (Build.VERSION.SDK_INT >= 19) {
                this.snackbarLayout.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

                    public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                        if (AHBottomNavigationBehavior.this.floatingActionButton != null && AHBottomNavigationBehavior.this.floatingActionButton.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                            ViewGroup.MarginLayoutParams p = (ViewGroup.MarginLayoutParams)AHBottomNavigationBehavior.this.floatingActionButton.getLayoutParams();
                            AHBottomNavigationBehavior.this.snackBarY = (float)bottom - v.getY();
                            AHBottomNavigationBehavior.this.fabTargetOffset = AHBottomNavigationBehavior.this.fabDefaultBottomMargin - child.getTranslationY() + AHBottomNavigationBehavior.this.snackBarY;
                            p.setMargins(p.leftMargin, p.topMargin, p.rightMargin, (int)AHBottomNavigationBehavior.this.fabTargetOffset);
                            AHBottomNavigationBehavior.this.floatingActionButton.requestLayout();
                        }
                    }
                });
            }
            if (this.mSnackbarHeight == -1) {
                this.mSnackbarHeight = dependency.getHeight();
            }
            int targetMargin = (int)((float)child.getMeasuredHeight() - child.getTranslationY());
            if (Build.VERSION.SDK_INT < 21) {
                child.bringToFront();
            }
            if (dependency.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                ViewGroup.MarginLayoutParams p = (ViewGroup.MarginLayoutParams)dependency.getLayoutParams();
                p.setMargins(p.leftMargin, p.topMargin, p.rightMargin, targetMargin);
                dependency.requestLayout();
            }
        }
    }

    public void updateFloatingActionButton(View dependency) {
        if (dependency != null && dependency instanceof FloatingActionButton) {
            this.floatingActionButton = (FloatingActionButton)dependency;
            if (!this.fabBottomMarginInitialized && dependency.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                this.fabBottomMarginInitialized = true;
                ViewGroup.MarginLayoutParams p = (ViewGroup.MarginLayoutParams)dependency.getLayoutParams();
                this.fabDefaultBottomMargin = p.bottomMargin;
            }
        }
    }
}

