/*
 * Decompiled with CFR 0.152.
 */
package com.aureusapps.android.extensions;

import android.content.Context;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import androidx.core.content.ContextCompat;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\u001a\u0012\u0010\u0004\u001a\u00020\u0003*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002\u001a+\u0010\u0007\u001a\u0004\u0018\u00010\u0003*\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00022\b\b\u0002\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000b\u001a!\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u000e\u001a!\u0010\u000f\u001a\u0004\u0018\u00010\r*\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u000e\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"dimenMap", "", "", "", "getAttributePosition", "Landroid/util/AttributeSet;", "attrName", "getColorAttribute", "context", "Landroid/content/Context;", "defaultColor", "(Landroid/util/AttributeSet;Landroid/content/Context;Ljava/lang/String;I)Ljava/lang/Integer;", "getDimensionAttribute", "", "(Landroid/util/AttributeSet;Landroid/content/Context;Ljava/lang/String;)Ljava/lang/Float;", "getFloatAttribute", "extensions_release"})
@SourceDebugExtension(value={"SMAP\nAttributeSetExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttributeSetExtensions.kt\ncom/aureusapps/android/extensions/AttributeSetExtensionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n288#2,2:120\n288#2,2:122\n*S KotlinDebug\n*F\n+ 1 AttributeSetExtensions.kt\ncom/aureusapps/android/extensions/AttributeSetExtensionsKt\n*L\n102#1:120,2\n118#1:122,2\n*E\n"})
public final class AttributeSetExtensionsKt {
    @NotNull
    private static final Map<String, Integer> dimenMap;

    @Nullable
    public static final Integer getColorAttribute(@NotNull AttributeSet $this$getColorAttribute, @NotNull Context context, @NotNull String attrName, int defaultColor) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)$this$getColorAttribute, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrName, (String)"attrName");
        try {
            int attrIndex = AttributeSetExtensionsKt.getAttributePosition($this$getColorAttribute, attrName);
            if (attrIndex >= 0) {
                Integer n2;
                String attrValue = $this$getColorAttribute.getAttributeValue(attrIndex);
                Intrinsics.checkNotNullExpressionValue((Object)attrValue, (String)"attrValue");
                if (StringsKt.contains$default((CharSequence)attrValue, (CharSequence)"@", (boolean)false, (int)2, null)) {
                    int colorResId = Integer.parseInt(StringsKt.replace$default((String)attrValue, (String)"@", (String)"", (boolean)false, (int)4, null));
                    n2 = ContextCompat.getColor((Context)context, (int)colorResId);
                } else if (StringsKt.contains$default((CharSequence)attrValue, (CharSequence)"?", (boolean)false, (int)2, null)) {
                    int colorAttrId = Integer.parseInt(StringsKt.replace$default((String)attrValue, (String)"?", (String)"", (boolean)false, (int)4, null));
                    TypedValue outValue = new TypedValue();
                    n2 = context.getTheme().resolveAttribute(colorAttrId, outValue, true) ? outValue.data : defaultColor;
                } else {
                    n2 = $this$getColorAttribute.getAttributeUnsignedIntValue(attrIndex, defaultColor);
                }
                return n2;
            }
            n = null;
        }
        catch (Exception e) {
            return defaultColor;
        }
        return n;
    }

    public static /* synthetic */ Integer getColorAttribute$default(AttributeSet attributeSet, Context context, String string, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = -16777216;
        }
        return AttributeSetExtensionsKt.getColorAttribute(attributeSet, context, string, n);
    }

    @Nullable
    public static final Float getFloatAttribute(@NotNull AttributeSet $this$getFloatAttribute, @NotNull Context context, @NotNull String attrName) {
        Intrinsics.checkNotNullParameter((Object)$this$getFloatAttribute, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrName, (String)"attrName");
        int attrIndex = AttributeSetExtensionsKt.getAttributePosition($this$getFloatAttribute, attrName);
        if (attrIndex >= 0) {
            Float f;
            String attrValue = $this$getFloatAttribute.getAttributeValue(attrIndex);
            Intrinsics.checkNotNullExpressionValue((Object)attrValue, (String)"attrValue");
            if (StringsKt.startsWith$default((String)attrValue, (String)"@", (boolean)false, (int)2, null)) {
                int floatResId = Integer.parseInt(StringsKt.replace$default((String)attrValue, (String)"@", (String)"", (boolean)false, (int)4, null));
                f = Float.valueOf(context.getResources().getDimension(floatResId));
            } else if (StringsKt.startsWith$default((String)attrValue, (String)"?", (boolean)false, (int)2, null)) {
                int floatAttrId = Integer.parseInt(StringsKt.replace$default((String)attrValue, (String)"?", (String)"", (boolean)false, (int)4, null));
                TypedValue outValue = new TypedValue();
                f = context.getTheme().resolveAttribute(floatAttrId, outValue, true) ? Float.valueOf(outValue.getDimension(context.getResources().getDisplayMetrics())) : null;
            } else {
                f = Float.valueOf($this$getFloatAttribute.getAttributeFloatValue(attrIndex, 0.0f));
            }
            return f;
        }
        return null;
    }

    @Nullable
    public static final Float getDimensionAttribute(@NotNull AttributeSet $this$getDimensionAttribute, @NotNull Context context, @NotNull String attrName) {
        Float f;
        Intrinsics.checkNotNullParameter((Object)$this$getDimensionAttribute, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrName, (String)"attrName");
        int attrIndex = AttributeSetExtensionsKt.getAttributePosition($this$getDimensionAttribute, attrName);
        if (attrIndex < 0) {
            return null;
        }
        String attrValue = $this$getDimensionAttribute.getAttributeValue(attrIndex);
        Intrinsics.checkNotNullExpressionValue((Object)attrValue, (String)"attrValue");
        if (StringsKt.startsWith$default((String)attrValue, (String)"@", (boolean)false, (int)2, null)) {
            int dimenResId = Integer.parseInt(StringsKt.replace$default((String)attrValue, (String)"@", (String)"", (boolean)false, (int)4, null));
            f = Float.valueOf(context.getResources().getDimension(dimenResId));
        } else if (StringsKt.startsWith$default((String)attrValue, (String)"?", (boolean)false, (int)2, null)) {
            int dimenAttrId = Integer.parseInt(StringsKt.replace$default((String)attrValue, (String)"?", (String)"", (boolean)false, (int)4, null));
            TypedValue outValue = new TypedValue();
            f = context.getTheme().resolveAttribute(dimenAttrId, outValue, true) ? Float.valueOf(outValue.getDimension(context.getResources().getDisplayMetrics())) : null;
        } else {
            Object v1;
            block7: {
                Iterable $this$firstOrNull$iv = dimenMap.entrySet();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Map.Entry it = (Map.Entry)element$iv;
                    boolean bl = false;
                    if (!StringsKt.endsWith$default((String)attrValue, (String)((String)it.getKey()), (boolean)false, (int)2, null)) continue;
                    v1 = element$iv;
                    break block7;
                }
                v1 = null;
            }
            Map.Entry dimenUnit = v1;
            if (dimenUnit == null) {
                return Float.valueOf(Float.parseFloat(attrValue));
            }
            return Float.valueOf(TypedValue.applyDimension((int)((Number)dimenUnit.getValue()).intValue(), (float)Float.parseFloat(StringsKt.replace$default((String)attrValue, (String)((String)dimenUnit.getKey()), (String)"", (boolean)false, (int)4, null)), (DisplayMetrics)context.getResources().getDisplayMetrics()));
        }
        return f;
    }

    public static final int getAttributePosition(@NotNull AttributeSet $this$getAttributePosition, @NotNull String attrName) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$getAttributePosition, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)attrName, (String)"attrName");
            Iterable $this$firstOrNull$iv = (Iterable)RangesKt.until((int)0, (int)$this$getAttributePosition.getAttributeCount());
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                int i = ((Number)element$iv).intValue();
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)$this$getAttributePosition.getAttributeName(i), (Object)attrName)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Integer n = v0;
        return n != null ? n : -1;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"px", (Object)0), TuplesKt.to((Object)"dip", (Object)1), TuplesKt.to((Object)"dp", (Object)1), TuplesKt.to((Object)"sp", (Object)2), TuplesKt.to((Object)"pt", (Object)3), TuplesKt.to((Object)"in", (Object)4), TuplesKt.to((Object)"mm", (Object)5)};
        dimenMap = MapsKt.mapOf((Pair[])pairArray);
    }
}

