/*
 * Decompiled with CFR 0.152.
 */
package com.aureusapps.android.extensions;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import com.aureusapps.android.extensions.UriExtensionsKt;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J>\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\n2\b\b\u0002\u0010\u0011\u001a\u00020\f2\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007\u00a8\u0006\u0014"}, d2={"Lcom/aureusapps/android/extensions/BitmapUtils;", "", "()V", "decodeUri", "Landroid/graphics/Bitmap;", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "getMimeType", "", "format", "Landroid/graphics/Bitmap$CompressFormat;", "saveInDirectory", "bitmap", "directoryUri", "displayName", "compressFormat", "compressQuality", "", "extensions_release"})
public final class BitmapUtils {
    @NotNull
    public static final BitmapUtils INSTANCE = new BitmapUtils();

    private BitmapUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @JvmStatic
    @Nullable
    public static final Bitmap decodeUri(@NotNull Context context, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        inputStream = null;
        bitmap = null;
        try {
            block17: {
                var4_4 = uri.getScheme();
                if (var4_4 == null) break block17;
                switch (var4_4.hashCode()) {
                    case 3143036: {
                        if (!var4_4.equals("file")) {
                            ** break;
                        }
                        ** GOTO lbl26
                    }
                    case -368816979: {
                        if (!var4_4.equals("android.resource")) {
                            ** break;
                        }
                        ** GOTO lbl26
                    }
                    case 3213448: {
                        if (var4_4.equals("http")) break;
                        ** break;
                    }
                    case 99617003: {
                        if (var4_4.equals("https")) break;
                        ** break;
                    }
                    case 951530617: {
                        if (!var4_4.equals("content")) ** break;
lbl26:
                        // 3 sources

                        inputStream = context.getContentResolver().openInputStream(uri);
                        ** break;
                    }
                }
                v0 = new Request.Builder();
                v1 = uri.toString();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"uri.toString()");
                request = v0.url(v1).build();
                client = new OkHttpClient.Builder().build();
                response = client.newCall(request).execute();
                body = response.body();
                if (body == null) ** break;
                if (response.code() == 200) {
                    inputStream = body.byteStream();
                    ** break;
                }
                response.close();
            }
            bitmap = inputStream != null ? BitmapFactory.decodeStream((InputStream)inputStream) : null;
        }
        catch (Exception var4_5) {
        }
        finally {
            v2 = inputStream;
            if (v2 != null) {
                v2.close();
            }
        }
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @Nullable
    public static final Uri saveInDirectory(@NotNull Context context, @NotNull Bitmap bitmap, @NotNull Uri directoryUri, @NotNull String displayName, @NotNull Bitmap.CompressFormat compressFormat, int compressQuality) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Intrinsics.checkNotNullParameter((Object)directoryUri, (String)"directoryUri");
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter((Object)compressFormat, (String)"compressFormat");
        OutputStream outputStream = null;
        Uri uri = null;
        try {
            String mimeType = INSTANCE.getMimeType(compressFormat);
            Uri newUri = UriExtensionsKt.createFile(directoryUri, context, displayName, mimeType);
            if (newUri != null && (outputStream = context.getContentResolver().openOutputStream(newUri)) != null && bitmap.compress(compressFormat, compressQuality, outputStream)) {
                uri = newUri;
            }
        }
        finally {
            OutputStream outputStream2 = outputStream;
            if (outputStream2 != null) {
                outputStream2.close();
            }
        }
        return uri;
    }

    public static /* synthetic */ Uri saveInDirectory$default(Context context, Bitmap bitmap, Uri uri, String string, Bitmap.CompressFormat compressFormat, int n, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            compressFormat = Bitmap.CompressFormat.PNG;
        }
        if ((n2 & 0x20) != 0) {
            n = 100;
        }
        return BitmapUtils.saveInDirectory(context, bitmap, uri, string, compressFormat, n);
    }

    private final String getMimeType(Bitmap.CompressFormat format) {
        String string;
        block11: {
            block10: {
                if (Build.VERSION.SDK_INT < 30) break block10;
                switch (WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
                    case 1: {
                        string = "image/png";
                        break block11;
                    }
                    case 2: {
                        string = "image/jpeg";
                        break block11;
                    }
                    case 3: 
                    case 4: {
                        string = "image/webp";
                        break block11;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown compress format");
                    }
                }
            }
            switch (WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
                case 1: {
                    string = "image/png";
                    break;
                }
                case 2: {
                    string = "image/jpeg";
                    break;
                }
                case 5: {
                    string = "image/webp";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown compress format");
                }
            }
        }
        return string;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Bitmap.CompressFormat.values().length];
            try {
                nArray[Bitmap.CompressFormat.PNG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Bitmap.CompressFormat.JPEG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Bitmap.CompressFormat.WEBP_LOSSY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Bitmap.CompressFormat.WEBP_LOSSLESS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Bitmap.CompressFormat.WEBP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

