/*
 * Decompiled with CFR 0.152.
 */
package com.aureusapps.android.extensions;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0012\u0010\u0003\u001a\u00020\u0004*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u001a\n\u0010\u0006\u001a\u00020\u0004*\u00020\u0002\u001a\u001c\u0010\u0007\u001a\u00020\b*\u00020\u00022\u0006\u0010\t\u001a\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010\f\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\r\u001a\u00020\b\u001a\u0012\u0010\u000e\u001a\u00020\u000f*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u0010"}, d2={"nextByte", "", "Ljava/nio/ByteBuffer;", "nextBytes", "", "count", "nextInt", "nextString", "", "size", "charset", "Ljava/nio/charset/Charset;", "putString", "value", "skipBytes", "", "extensions_release"})
public final class ByteBufferExtensionsKt {
    public static final byte nextByte(@NotNull ByteBuffer $this$nextByte) {
        Intrinsics.checkNotNullParameter((Object)$this$nextByte, (String)"<this>");
        return $this$nextByte.get();
    }

    public static final int nextBytes(@NotNull ByteBuffer $this$nextBytes, int count) {
        Intrinsics.checkNotNullParameter((Object)$this$nextBytes, (String)"<this>");
        if (count > 4) {
            throw new IndexOutOfBoundsException("Out of byte count [" + count + "]");
        }
        int v = 0;
        for (int i = 0; i < count; ++i) {
            int u = $this$nextBytes.get() & 0xFF;
            v |= u << i * 8;
        }
        return v;
    }

    public static final int nextInt(@NotNull ByteBuffer $this$nextInt) {
        Intrinsics.checkNotNullParameter((Object)$this$nextInt, (String)"<this>");
        return $this$nextInt.getInt();
    }

    @NotNull
    public static final String nextString(@NotNull ByteBuffer $this$nextString, int size, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$nextString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        int n = 0;
        byte[] byArray = new byte[size];
        while (n < size) {
            int n2 = n++;
            byArray[n2] = $this$nextString.get();
        }
        byte[] byArray2 = byArray;
        return new String(byArray2, charset);
    }

    public static /* synthetic */ String nextString$default(ByteBuffer byteBuffer, int n, Charset charset, int n2, Object object) {
        if ((n2 & 2) != 0) {
            charset = Charsets.US_ASCII;
        }
        return ByteBufferExtensionsKt.nextString(byteBuffer, n, charset);
    }

    public static final void skipBytes(@NotNull ByteBuffer $this$skipBytes, int count) {
        Intrinsics.checkNotNullParameter((Object)$this$skipBytes, (String)"<this>");
        $this$skipBytes.position($this$skipBytes.position() + count);
    }

    @NotNull
    public static final ByteBuffer putString(@NotNull ByteBuffer $this$putString, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$putString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        byte[] byArray = value.getBytes(Charsets.US_ASCII);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        $this$putString.put(byArray);
        return $this$putString;
    }
}

