/*
 * Decompiled with CFR 0.152.
 */
package com.aureusapps.android.extensions;

import android.content.Context;
import android.net.Uri;
import com.aureusapps.android.extensions.InputStreamExtensionsKt;
import com.aureusapps.android.extensions.UriExtensionsKt;
import java.io.Closeable;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.Util;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004J\u0018\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\f"}, d2={"Lcom/aureusapps/android/extensions/CryptoUtils;", "", "()V", "generateHash", "", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "algorithm", "generateMD5", "generateSHA1", "extensions_release"})
public final class CryptoUtils {
    @NotNull
    public static final CryptoUtils INSTANCE = new CryptoUtils();

    private CryptoUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String generateHash(@NotNull Context context, @NotNull Uri uri, @NotNull String algorithm) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        String hash = null;
        InputStream inputStream = null;
        try {
            inputStream = UriExtensionsKt.openInputStream(uri, context);
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            InputStream inputStream2 = inputStream;
            if (inputStream2 != null) {
                InputStreamExtensionsKt.readBytes$default(inputStream2, 0, (Function2)new Function2<byte[], Integer, Boolean>(digest){
                    final /* synthetic */ MessageDigest $digest;
                    {
                        this.$digest = $digest;
                        super(2);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull byte[] buffer, int bytesRead) {
                        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                        this.$digest.update(buffer, 0, bytesRead);
                        return true;
                    }
                }, 1, null);
            }
            byte[] hashBytes = digest.digest();
            StringBuilder builder = new StringBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)hashBytes, (String)"hashBytes");
            for (byte by : hashBytes) {
                String string = "%02x";
                Object[] objectArray = new Object[]{by};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                builder.append(string2);
            }
            hash = builder.toString();
        }
        catch (Exception exception) {
        }
        finally {
            InputStream inputStream3 = inputStream;
            if (inputStream3 != null) {
                Util.closeQuietly((Closeable)inputStream3);
            }
        }
        return hash;
    }

    @Nullable
    public final String generateMD5(@NotNull Context context, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return this.generateHash(context, uri, "MD5");
    }

    @Nullable
    public final String generateSHA1(@NotNull Context context, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return this.generateHash(context, uri, "SHA-1");
    }
}

